/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.neoforge.datagen.provider;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.init.ModTags;
import biomesoplenty.neoforge.datagen.BOPBlockFamilies;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class BOPRecipeProvider
extends RecipeProvider {
    public BOPRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        this.generateForEnabledBlockFamiliesBOP(FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.planksFromLogs((ItemLike)BOPBlocks.ORIGIN_OAK_PLANKS, ModTags.Items.ORIGIN_OAK_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.FIR_PLANKS, ModTags.Items.FIR_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.PINE_PLANKS, ModTags.Items.PINE_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.MAPLE_PLANKS, ModTags.Items.MAPLE_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.REDWOOD_PLANKS, ModTags.Items.REDWOOD_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.MAHOGANY_PLANKS, ModTags.Items.MAHOGANY_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.JACARANDA_PLANKS, ModTags.Items.JACARANDA_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.PALM_PLANKS, ModTags.Items.PALM_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.WILLOW_PLANKS, ModTags.Items.WILLOW_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.DEAD_PLANKS, ModTags.Items.DEAD_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.MAGIC_PLANKS, ModTags.Items.MAGIC_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.UMBRAN_PLANKS, ModTags.Items.UMBRAN_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.HELLBARK_PLANKS, ModTags.Items.HELLBARK_LOGS, 4);
        this.planksFromLogs((ItemLike)BOPBlocks.EMPYREAL_PLANKS, ModTags.Items.EMPYREAL_LOGS, 4);
        this.woodFromLogs((ItemLike)BOPBlocks.ORIGIN_OAK_WOOD, (ItemLike)BOPBlocks.ORIGIN_OAK_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.FIR_WOOD, (ItemLike)BOPBlocks.FIR_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.PINE_WOOD, (ItemLike)BOPBlocks.PINE_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.MAPLE_WOOD, (ItemLike)BOPBlocks.MAPLE_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.REDWOOD_WOOD, (ItemLike)BOPBlocks.REDWOOD_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.MAHOGANY_WOOD, (ItemLike)BOPBlocks.MAHOGANY_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.JACARANDA_WOOD, (ItemLike)BOPBlocks.JACARANDA_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.PALM_WOOD, (ItemLike)BOPBlocks.PALM_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.WILLOW_WOOD, (ItemLike)BOPBlocks.WILLOW_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.DEAD_WOOD, (ItemLike)BOPBlocks.DEAD_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.MAGIC_WOOD, (ItemLike)BOPBlocks.MAGIC_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.UMBRAN_WOOD, (ItemLike)BOPBlocks.UMBRAN_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.HELLBARK_WOOD, (ItemLike)BOPBlocks.HELLBARK_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.EMPYREAL_WOOD, (ItemLike)BOPBlocks.EMPYREAL_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_ORIGIN_OAK_WOOD, (ItemLike)BOPBlocks.STRIPPED_ORIGIN_OAK_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_FIR_WOOD, (ItemLike)BOPBlocks.STRIPPED_FIR_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_PINE_WOOD, (ItemLike)BOPBlocks.STRIPPED_PINE_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_MAPLE_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAPLE_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_REDWOOD_WOOD, (ItemLike)BOPBlocks.STRIPPED_REDWOOD_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_MAHOGANY_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAHOGANY_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_JACARANDA_WOOD, (ItemLike)BOPBlocks.STRIPPED_JACARANDA_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_PALM_WOOD, (ItemLike)BOPBlocks.STRIPPED_PALM_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_WILLOW_WOOD, (ItemLike)BOPBlocks.STRIPPED_WILLOW_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_DEAD_WOOD, (ItemLike)BOPBlocks.STRIPPED_DEAD_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_MAGIC_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAGIC_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_UMBRAN_WOOD, (ItemLike)BOPBlocks.STRIPPED_UMBRAN_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_HELLBARK_WOOD, (ItemLike)BOPBlocks.STRIPPED_HELLBARK_LOG);
        this.woodFromLogs((ItemLike)BOPBlocks.STRIPPED_EMPYREAL_WOOD, (ItemLike)BOPBlocks.STRIPPED_EMPYREAL_LOG);
        this.woodenBoat((ItemLike)BOPItems.ORIGIN_OAK_BOAT, (ItemLike)BOPBlocks.ORIGIN_OAK_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.FIR_BOAT, (ItemLike)BOPBlocks.FIR_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.PINE_BOAT, (ItemLike)BOPBlocks.PINE_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.MAPLE_BOAT, (ItemLike)BOPBlocks.MAPLE_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.REDWOOD_BOAT, (ItemLike)BOPBlocks.REDWOOD_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.MAHOGANY_BOAT, (ItemLike)BOPBlocks.MAHOGANY_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.JACARANDA_BOAT, (ItemLike)BOPBlocks.JACARANDA_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.PALM_BOAT, (ItemLike)BOPBlocks.PALM_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.WILLOW_BOAT, (ItemLike)BOPBlocks.WILLOW_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.DEAD_BOAT, (ItemLike)BOPBlocks.DEAD_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.MAGIC_BOAT, (ItemLike)BOPBlocks.MAGIC_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.UMBRAN_BOAT, (ItemLike)BOPBlocks.UMBRAN_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.HELLBARK_BOAT, (ItemLike)BOPBlocks.HELLBARK_PLANKS);
        this.woodenBoat((ItemLike)BOPItems.EMPYREAL_BOAT, (ItemLike)BOPBlocks.EMPYREAL_PLANKS);
        this.chestBoat((ItemLike)BOPItems.ORIGIN_OAK_CHEST_BOAT, (ItemLike)BOPItems.ORIGIN_OAK_BOAT);
        this.chestBoat((ItemLike)BOPItems.FIR_CHEST_BOAT, (ItemLike)BOPItems.FIR_BOAT);
        this.chestBoat((ItemLike)BOPItems.PINE_CHEST_BOAT, (ItemLike)BOPItems.PINE_BOAT);
        this.chestBoat((ItemLike)BOPItems.MAPLE_CHEST_BOAT, (ItemLike)BOPItems.MAPLE_BOAT);
        this.chestBoat((ItemLike)BOPItems.REDWOOD_CHEST_BOAT, (ItemLike)BOPItems.REDWOOD_BOAT);
        this.chestBoat((ItemLike)BOPItems.MAHOGANY_CHEST_BOAT, (ItemLike)BOPItems.MAHOGANY_BOAT);
        this.chestBoat((ItemLike)BOPItems.JACARANDA_CHEST_BOAT, (ItemLike)BOPItems.JACARANDA_BOAT);
        this.chestBoat((ItemLike)BOPItems.PALM_CHEST_BOAT, (ItemLike)BOPItems.PALM_BOAT);
        this.chestBoat((ItemLike)BOPItems.WILLOW_CHEST_BOAT, (ItemLike)BOPItems.WILLOW_BOAT);
        this.chestBoat((ItemLike)BOPItems.DEAD_CHEST_BOAT, (ItemLike)BOPItems.DEAD_BOAT);
        this.chestBoat((ItemLike)BOPItems.MAGIC_CHEST_BOAT, (ItemLike)BOPItems.MAGIC_BOAT);
        this.chestBoat((ItemLike)BOPItems.UMBRAN_CHEST_BOAT, (ItemLike)BOPItems.UMBRAN_BOAT);
        this.chestBoat((ItemLike)BOPItems.HELLBARK_CHEST_BOAT, (ItemLike)BOPItems.HELLBARK_BOAT);
        this.chestBoat((ItemLike)BOPItems.EMPYREAL_CHEST_BOAT, (ItemLike)BOPItems.EMPYREAL_BOAT);
        this.hangingSign((ItemLike)BOPItems.ORIGIN_OAK_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_ORIGIN_OAK_LOG);
        this.hangingSign((ItemLike)BOPItems.FIR_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_FIR_LOG);
        this.hangingSign((ItemLike)BOPItems.PINE_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_PINE_LOG);
        this.hangingSign((ItemLike)BOPItems.MAPLE_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_MAPLE_LOG);
        this.hangingSign((ItemLike)BOPItems.REDWOOD_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_REDWOOD_LOG);
        this.hangingSign((ItemLike)BOPItems.MAHOGANY_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_MAHOGANY_LOG);
        this.hangingSign((ItemLike)BOPItems.JACARANDA_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_JACARANDA_LOG);
        this.hangingSign((ItemLike)BOPItems.PALM_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_PALM_LOG);
        this.hangingSign((ItemLike)BOPItems.WILLOW_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_WILLOW_LOG);
        this.hangingSign((ItemLike)BOPItems.DEAD_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_DEAD_LOG);
        this.hangingSign((ItemLike)BOPItems.MAGIC_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_MAGIC_LOG);
        this.hangingSign((ItemLike)BOPItems.UMBRAN_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_UMBRAN_LOG);
        this.hangingSign((ItemLike)BOPItems.HELLBARK_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_HELLBARK_LOG);
        this.hangingSign((ItemLike)BOPItems.EMPYREAL_HANGING_SIGN, (ItemLike)BOPBlocks.STRIPPED_EMPYREAL_LOG);
        this.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE, Ingredient.of((ItemLike)BOPBlocks.WHITE_SANDSTONE_SLAB)).unlockedBy("has_white_sandstone", this.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).unlockedBy("has_chiseled_white_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE)).unlockedBy("has_cut_white_sandstone", this.has((ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.WHITE_SAND).pattern("##").pattern("##").unlockedBy("has_white_sand", this.has((ItemLike)BOPBlocks.WHITE_SAND)).save(this.output);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_SLAB, Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SANDSTONE, BOPBlocks.CHISELED_WHITE_SANDSTONE})).unlockedBy("has_white_sandstone", this.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).unlockedBy("has_chiseled_white_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE)).save(this.output);
        this.stairBuilder((ItemLike)BOPBlocks.WHITE_SANDSTONE_STAIRS, Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SANDSTONE, BOPBlocks.CHISELED_WHITE_SANDSTONE, BOPBlocks.CUT_WHITE_SANDSTONE})).unlockedBy("has_white_sandstone", this.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).unlockedBy("has_chiseled_white_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE)).unlockedBy("has_cut_white_sandstone", this.has((ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE)).save(this.output);
        this.cut(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        this.wall(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_WALL, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)BOPBlocks.WHITE_SANDSTONE), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE.asItem(), (float)0.1f, (int)200).unlockedBy("has_white_sandstone", this.has((ItemLike)BOPBlocks.WHITE_SANDSTONE)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.WHITE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.WHITE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.WHITE_SANDSTONE_WALL, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_WHITE_SANDSTONE, (ItemLike)BOPBlocks.WHITE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE);
        this.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE, Ingredient.of((ItemLike)BOPBlocks.ORANGE_SANDSTONE_SLAB)).unlockedBy("has_orange_sandstone", this.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).unlockedBy("has_chiseled_orange_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE)).unlockedBy("has_cut_orange_sandstone", this.has((ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.ORANGE_SAND).pattern("##").pattern("##").unlockedBy("has_orange_sand", this.has((ItemLike)BOPBlocks.ORANGE_SAND)).save(this.output);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_SLAB, Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_SANDSTONE, BOPBlocks.CHISELED_ORANGE_SANDSTONE})).unlockedBy("has_orange_sandstone", this.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).unlockedBy("has_chiseled_orange_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE)).save(this.output);
        this.stairBuilder((ItemLike)BOPBlocks.ORANGE_SANDSTONE_STAIRS, Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.ORANGE_SANDSTONE, BOPBlocks.CHISELED_ORANGE_SANDSTONE, BOPBlocks.CUT_ORANGE_SANDSTONE})).unlockedBy("has_orange_sandstone", this.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).unlockedBy("has_chiseled_orange_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE)).unlockedBy("has_cut_orange_sandstone", this.has((ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE)).save(this.output);
        this.cut(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        this.wall(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_WALL, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)BOPBlocks.ORANGE_SANDSTONE), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE.asItem(), (float)0.1f, (int)200).unlockedBy("has_orange_sandstone", this.has((ItemLike)BOPBlocks.ORANGE_SANDSTONE)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.ORANGE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.ORANGE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.ORANGE_SANDSTONE_WALL, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_ORANGE_SANDSTONE, (ItemLike)BOPBlocks.ORANGE_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE_SLAB, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE);
        this.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE, Ingredient.of((ItemLike)BOPBlocks.BLACK_SANDSTONE_SLAB)).unlockedBy("has_black_sandstone", this.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).unlockedBy("has_chiseled_black_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE)).unlockedBy("has_cut_black_sandstone", this.has((ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BLACK_SAND).pattern("##").pattern("##").unlockedBy("has_black_sand", this.has((ItemLike)BOPBlocks.BLACK_SAND)).save(this.output);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_SLAB, Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BLACK_SANDSTONE, BOPBlocks.CHISELED_BLACK_SANDSTONE})).unlockedBy("has_black_sandstone", this.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).unlockedBy("has_chiseled_black_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE)).save(this.output);
        this.stairBuilder((ItemLike)BOPBlocks.BLACK_SANDSTONE_STAIRS, Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.BLACK_SANDSTONE, BOPBlocks.CHISELED_BLACK_SANDSTONE, BOPBlocks.CUT_BLACK_SANDSTONE})).unlockedBy("has_black_sandstone", this.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).unlockedBy("has_chiseled_black_sandstone", this.has((ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE)).unlockedBy("has_cut_black_sandstone", this.has((ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE)).save(this.output);
        this.cut(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        this.wall(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_WALL, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)BOPBlocks.BLACK_SANDSTONE), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE.asItem(), (float)0.1f, (int)200).unlockedBy("has_black_sandstone", this.has((ItemLike)BOPBlocks.BLACK_SANDSTONE)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.BLACK_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.BLACK_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACK_SANDSTONE_WALL, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BLACK_SANDSTONE, (ItemLike)BOPBlocks.BLACK_SANDSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE_SLAB, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS, (ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE);
        this.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS, Ingredient.of((ItemLike)BOPBlocks.BRIMSTONE_BRICK_SLAB)).unlockedBy("has_brimstone_bricks", this.has((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).unlockedBy("has_chiseled_brimstone_bricks", this.has((ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS, 4).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BRIMSTONE).pattern("##").pattern("##").unlockedBy("has_brimstone", this.has((ItemLike)BOPBlocks.BRIMSTONE)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS, (ItemLike)BOPBlocks.BRIMSTONE);
        this.slabBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_SLAB, Ingredient.of((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).unlockedBy("has_brimstone_bricks", this.has((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_SLAB, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS, 2);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_SLAB, (ItemLike)BOPBlocks.BRIMSTONE, 2);
        this.stairBuilder((ItemLike)BOPBlocks.BRIMSTONE_BRICK_STAIRS, Ingredient.of((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).unlockedBy("has_brimstone_bricks", this.has((ItemLike)BOPBlocks.BRIMSTONE_BRICKS)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_STAIRS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_STAIRS, (ItemLike)BOPBlocks.BRIMSTONE);
        this.wall(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_WALL, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_WALL, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BRICK_WALL, (ItemLike)BOPBlocks.BRIMSTONE);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS, (ItemLike)BOPBlocks.BRIMSTONE_BRICKS);
        this.stonecutterResultFromBase(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.CHISELED_BRIMSTONE_BRICKS, (ItemLike)BOPBlocks.BRIMSTONE);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_CLUSTER, 2).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BRIMSTONE).pattern("#").pattern("#").unlockedBy("has_brimstone", this.has((ItemLike)BOPBlocks.BRIMSTONE)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_CLUSTER, (ItemLike)BOPBlocks.BRIMSTONE, 2);
        this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BUD, 4).requires((ItemLike)BOPBlocks.BRIMSTONE).unlockedBy("has_brimstone", this.has((ItemLike)BOPBlocks.BRIMSTONE)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_BUD, (ItemLike)BOPBlocks.BRIMSTONE, 4);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BRIMSTONE_FUMAROLE).define(Character.valueOf('#'), (ItemLike)BOPBlocks.BRIMSTONE).define(Character.valueOf('F'), (ItemLike)Items.FIRE_CHARGE).pattern(" # ").pattern("#F#").pattern("###").unlockedBy("has_brimstone", this.has((ItemLike)BOPBlocks.BRIMSTONE)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACKSTONE_BULB, 2).define(Character.valueOf('#'), (ItemLike)Blocks.BLACKSTONE).define(Character.valueOf('O'), (ItemLike)Blocks.CRYING_OBSIDIAN).pattern("O").pattern("#").unlockedBy("has_blackstone", this.has((ItemLike)Blocks.BLACKSTONE)).save(this.output);
        this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACKSTONE_SPINES, 4).requires((ItemLike)Blocks.BLACKSTONE).unlockedBy("has_blackstone", this.has((ItemLike)Blocks.BLACKSTONE)).save(this.output);
        this.stonecutterResultFromBase(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.BLACKSTONE_SPINES, (ItemLike)Blocks.BLACKSTONE, 4);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ALGAL_END_STONE).requires((ItemLike)Blocks.END_STONE).requires((ItemLike)BOPBlocks.ENDERPHYTE).unlockedBy("has_enderphyte", this.has((ItemLike)BOPBlocks.ENDERPHYTE)).save(this.output);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.NULL_END_STONE).requires((ItemLike)Blocks.END_STONE).requires((ItemLike)BOPBlocks.NULL_LEAVES).unlockedBy("has_null_leaves", this.has((ItemLike)BOPBlocks.NULL_LEAVES)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.UNMAPPED_END_STONE, 4).define(Character.valueOf('#'), (ItemLike)Blocks.END_STONE).define(Character.valueOf('B'), (ItemLike)BOPItems.LIQUID_NULL_BUCKET).pattern(" # ").pattern("#B#").pattern(" # ").unlockedBy("has_liquid_null_bucket", this.has((ItemLike)BOPItems.LIQUID_NULL_BUCKET)).save(this.output);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.MOSSY_BLACK_SAND).requires((ItemLike)BOPBlocks.BLACK_SAND).requires((ItemLike)Blocks.MOSS_BLOCK).unlockedBy("has_moss_block", this.has((ItemLike)Blocks.MOSS_BLOCK)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.FLESH).define(Character.valueOf('#'), (ItemLike)Items.ROTTEN_FLESH).define(Character.valueOf('B'), (ItemLike)BOPItems.BLOOD_BUCKET).pattern(" # ").pattern("#B#").pattern(" # ").unlockedBy("has_blood_bucket", this.has((ItemLike)BOPItems.BLOOD_BUCKET)).save(this.output);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK).define(Character.valueOf('#'), (ItemLike)BOPItems.ROSE_QUARTZ_CHUNK).pattern("##").pattern("##").unlockedBy("has_rose_quartz_chunk", this.has((ItemLike)BOPItems.ROSE_QUARTZ_CHUNK)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.RED_MAPLE_LEAF_LITTER, 12).define(Character.valueOf('#'), (ItemLike)BOPBlocks.RED_MAPLE_LEAVES).pattern("###").unlockedBy("has_red_maple_leaves", this.has((ItemLike)BOPBlocks.RED_MAPLE_LEAVES)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.ORANGE_MAPLE_LEAF_LITTER, 12).define(Character.valueOf('#'), (ItemLike)BOPBlocks.ORANGE_MAPLE_LEAVES).pattern("###").unlockedBy("has_orange_maple_leaves", this.has((ItemLike)BOPBlocks.ORANGE_MAPLE_LEAVES)).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BOPBlocks.YELLOW_MAPLE_LEAF_LITTER, 12).define(Character.valueOf('#'), (ItemLike)BOPBlocks.YELLOW_MAPLE_LEAVES).pattern("###").unlockedBy("has_yellow_maple_leaves", this.has((ItemLike)BOPBlocks.YELLOW_MAPLE_LEAVES)).save(this.output);
        this.oneToOneConversionRecipe((ItemLike)Items.BROWN_DYE, (ItemLike)BOPBlocks.CATTAIL, "brown_dye", 2);
        this.oneToOneConversionRecipe((ItemLike)Items.CYAN_DYE, (ItemLike)BOPBlocks.GLOWFLOWER, "cyan_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.GRAY_DYE, (ItemLike)BOPBlocks.WILTED_LILY, "gray_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)BOPBlocks.BLUE_HYDRANGEA, "light_blue_dye", 2);
        this.oneToOneConversionRecipe((ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)BOPBlocks.ICY_IRIS, "light_blue_dye", 2);
        this.oneToOneConversionRecipe((ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)BOPBlocks.ENDBLOOM, "light_gray_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.MAGENTA_DYE, (ItemLike)BOPBlocks.PURPLE_WILDFLOWERS, "magenta_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.ORANGE_DYE, (ItemLike)BOPBlocks.BURNING_BLOSSOM, "orange_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.ORANGE_DYE, (ItemLike)BOPBlocks.ORANGE_COSMOS, "orange_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.ORANGE_DYE, (ItemLike)BOPBlocks.MARIGOLD, "orange_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.PINK_DYE, (ItemLike)BOPBlocks.PINK_DAFFODIL, "pink_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.PINK_DYE, (ItemLike)BOPBlocks.PINK_HIBISCUS, "pink_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.PURPLE_DYE, (ItemLike)BOPBlocks.LAVENDER, "purple_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.PURPLE_DYE, (ItemLike)BOPBlocks.TALL_LAVENDER, "purple_dye", 2);
        this.oneToOneConversionRecipe((ItemLike)Items.PURPLE_DYE, (ItemLike)BOPBlocks.VIOLET, "purple_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.RED_DYE, (ItemLike)BOPBlocks.ORIGIN_ROSE, "red_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.RED_DYE, (ItemLike)BOPBlocks.WATERLILY, "red_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.WHITE_DYE, (ItemLike)BOPBlocks.WHITE_LAVENDER, "white_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.WHITE_DYE, (ItemLike)BOPBlocks.TALL_WHITE_LAVENDER, "white_dye", 2);
        this.oneToOneConversionRecipe((ItemLike)Items.WHITE_DYE, (ItemLike)BOPBlocks.WHITE_PETALS, "white_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.YELLOW_DYE, (ItemLike)BOPBlocks.ORIGIN_DANDELION, "yellow_dye");
        this.oneToOneConversionRecipe((ItemLike)Items.YELLOW_DYE, (ItemLike)BOPBlocks.GOLDENROD, "yellow_dye", 2);
        this.oneToOneConversionRecipe((ItemLike)Items.WHITE_DYE, (ItemLike)BOPBlocks.WHITE_FLOWER_PETAL_BLOCK, "white_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)BOPBlocks.LIGHT_GRAY_FLOWER_PETAL_BLOCK, "light_gray_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.GRAY_DYE, (ItemLike)BOPBlocks.GRAY_FLOWER_PETAL_BLOCK, "gray_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.BLACK_DYE, (ItemLike)BOPBlocks.BLACK_FLOWER_PETAL_BLOCK, "black_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.BROWN_DYE, (ItemLike)BOPBlocks.BROWN_FLOWER_PETAL_BLOCK, "brown_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.RED_DYE, (ItemLike)BOPBlocks.RED_FLOWER_PETAL_BLOCK, "red_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.ORANGE_DYE, (ItemLike)BOPBlocks.ORANGE_FLOWER_PETAL_BLOCK, "orange_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.YELLOW_DYE, (ItemLike)BOPBlocks.YELLOW_FLOWER_PETAL_BLOCK, "yellow_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.LIME_DYE, (ItemLike)BOPBlocks.LIME_FLOWER_PETAL_BLOCK, "lime_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.GREEN_DYE, (ItemLike)BOPBlocks.GREEN_FLOWER_PETAL_BLOCK, "green_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.CYAN_DYE, (ItemLike)BOPBlocks.CYAN_FLOWER_PETAL_BLOCK, "cyan_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)BOPBlocks.LIGHT_BLUE_FLOWER_PETAL_BLOCK, "light_blue_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.BLUE_DYE, (ItemLike)BOPBlocks.BLUE_FLOWER_PETAL_BLOCK, "blue_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.PURPLE_DYE, (ItemLike)BOPBlocks.PURPLE_FLOWER_PETAL_BLOCK, "purple_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.MAGENTA_DYE, (ItemLike)BOPBlocks.MAGENTA_FLOWER_PETAL_BLOCK, "magenta_dye", 4);
        this.oneToOneConversionRecipe((ItemLike)Items.PINK_DYE, (ItemLike)BOPBlocks.PINK_FLOWER_PETAL_BLOCK, "pink_dye", 4);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)BOPBlocks.TINY_CACTUS.asItem()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GREEN_DYE, (float)1.0f, (int)200).unlockedBy("has_tiny_cactus", this.has((ItemLike)BOPBlocks.TINY_CACTUS)).save(this.output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Items.GREEN_DYE, (ItemLike)BOPBlocks.TINY_CACTUS));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.MOSSY_COBBLESTONE).requires((ItemLike)Blocks.COBBLESTONE).requires((ItemLike)BOPBlocks.WILLOW_VINE).group("mossy_cobblestone").unlockedBy("has_willow_vine", this.has((ItemLike)BOPBlocks.WILLOW_VINE)).save(this.output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Blocks.MOSSY_COBBLESTONE, (ItemLike)BOPBlocks.WILLOW_VINE));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.MOSSY_STONE_BRICKS).requires((ItemLike)Blocks.STONE_BRICKS).requires((ItemLike)BOPBlocks.WILLOW_VINE).group("mossy_stone_bricks").unlockedBy("has_willow_vine", this.has((ItemLike)BOPBlocks.WILLOW_VINE)).save(this.output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Blocks.MOSSY_STONE_BRICKS, (ItemLike)BOPBlocks.WILLOW_VINE));
        this.shapeless(RecipeCategory.FOOD, (ItemLike)Items.RABBIT_STEW).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.COOKED_RABBIT).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.CARROT).requires((ItemLike)BOPBlocks.TOADSTOOL).group("rabbit_stew").unlockedBy("has_cooked_rabbit", this.has((ItemLike)Items.COOKED_RABBIT)).save(this.output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)Items.RABBIT_STEW, (ItemLike)BOPItems.TOADSTOOL));
        this.shaped(RecipeCategory.REDSTONE, (ItemLike)Blocks.TNT).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{BOPBlocks.WHITE_SAND, BOPBlocks.ORANGE_SAND, BOPBlocks.BLACK_SAND})).define(Character.valueOf('X'), (ItemLike)Items.GUNPOWDER).pattern("X#X").pattern("#X#").pattern("X#X").unlockedBy("has_gunpowder", this.has((ItemLike)Items.GUNPOWDER)).save(this.output, "biomesoplenty:tnt_from_bop_sand");
    }

    protected void generateForEnabledBlockFamiliesBOP(FeatureFlagSet flags) {
        BOPBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> this.generateRecipes((BlockFamily)family, flags));
    }

    protected void planksFromLogs(RecipeOutput output, ItemLike planks, ItemLike log, int count) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, planks, count).requires(log).group("planks").unlockedBy("has_logs", this.has(log)).save(output);
    }

    protected void stonecutterResultFromBase(RecipeOutput output, RecipeCategory category, ItemLike result, ItemLike input) {
        this.stonecutterResultFromBase(category, result, input, 1);
    }

    protected void stonecutterResultFromBase(RecipeOutput output, RecipeCategory category, ItemLike result, ItemLike input, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)input), (RecipeCategory)category, (ItemLike)result, (int)count).unlockedBy(BOPRecipeProvider.getHasName((ItemLike)input), this.has(input)).save(this.output, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)input) + "_stonecutting");
    }

    protected void oneToOneConversionRecipe(RecipeOutput p_299023_, ItemLike p_176553_, ItemLike p_176554_, @Nullable String p_176555_) {
        this.oneToOneConversionRecipe(p_299023_, p_176553_, p_176554_, p_176555_, 1);
    }

    protected void oneToOneConversionRecipe(RecipeOutput p_301230_, ItemLike p_176558_, ItemLike p_176559_, @Nullable String p_176560_, int p_176561_) {
        this.shapeless(RecipeCategory.MISC, p_176558_, p_176561_).requires(p_176559_).group(p_176560_).unlockedBy(BOPRecipeProvider.getHasName((ItemLike)p_176559_), this.has(p_176559_)).save(p_301230_, "biomesoplenty:" + BOPRecipeProvider.getConversionRecipeName((ItemLike)p_176558_, (ItemLike)p_176559_));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput p_365442_, CompletableFuture<HolderLookup.Provider> p_362168_) {
            super(p_365442_, p_362168_);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new BOPRecipeProvider(provider, output);
        }

        public String getName() {
            return "BOP Recipes";
        }
    }
}

