/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.damagesource.BOPDamageTypes;
import biomesoplenty.block.BrambleLeavesBlock;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrambleBlock
extends PipeBlock {
    public static final MapCodec<BrambleBlock> CODEC = BrambleBlock.simpleCodec(BrambleBlock::new);

    public BrambleBlock(BlockBehaviour.Properties builder) {
        super(8.0f, builder);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<BrambleBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.makeConnections((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    public BlockState makeConnections(BlockGetter reader, BlockPos pos) {
        BlockState block = reader.getBlockState(pos.below());
        BlockState block1 = reader.getBlockState(pos.above());
        BlockState block2 = reader.getBlockState(pos.north());
        BlockState block3 = reader.getBlockState(pos.east());
        BlockState block4 = reader.getBlockState(pos.south());
        BlockState block5 = reader.getBlockState(pos.west());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(block.getBlock() == this || block.getBlock() == BOPBlocks.BRAMBLE_LEAVES && block.getValue((Property)BrambleLeavesBlock.FACING) == Direction.DOWN || Block.isShapeFullBlock((VoxelShape)block.getCollisionShape(reader, pos.below()))))).setValue((Property)UP, (Comparable)Boolean.valueOf(block1.getBlock() == this || block1.getBlock() == BOPBlocks.BRAMBLE_LEAVES && block1.getValue((Property)BrambleLeavesBlock.FACING) == Direction.UP || Block.isShapeFullBlock((VoxelShape)block1.getCollisionShape(reader, pos.above()))))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(block2.getBlock() == this || block2.getBlock() == BOPBlocks.BRAMBLE_LEAVES && block2.getValue((Property)BrambleLeavesBlock.FACING) == Direction.NORTH || Block.isShapeFullBlock((VoxelShape)block2.getCollisionShape(reader, pos.north()))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(block3.getBlock() == this || block3.getBlock() == BOPBlocks.BRAMBLE_LEAVES && block3.getValue((Property)BrambleLeavesBlock.FACING) == Direction.EAST || Block.isShapeFullBlock((VoxelShape)block3.getCollisionShape(reader, pos.east()))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(block4.getBlock() == this || block4.getBlock() == BOPBlocks.BRAMBLE_LEAVES && block4.getValue((Property)BrambleLeavesBlock.FACING) == Direction.SOUTH || Block.isShapeFullBlock((VoxelShape)block4.getCollisionShape(reader, pos.south()))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(block5.getBlock() == this || block5.getBlock() == BOPBlocks.BRAMBLE_LEAVES && block5.getValue((Property)BrambleLeavesBlock.FACING) == Direction.WEST || Block.isShapeFullBlock((VoxelShape)block5.getCollisionShape(reader, pos.west()))));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        Block block = facingState.getBlock();
        boolean flag = block == this || block == BOPBlocks.BRAMBLE_LEAVES && facingState.getValue((Property)BrambleLeavesBlock.FACING) == facing || Block.isShapeFullBlock((VoxelShape)facingState.getCollisionShape((BlockGetter)level, facingPos));
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(flag));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean b) {
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            playerEntity.hurt(level.damageSources().source(BOPDamageTypes.BRAMBLE), 1.0f);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }
}

