/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class ThermalCalciteBlock
extends Block {
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)1, (int)5);

    public ThermalCalciteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(5)));
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        if (worldIn.getBlockState(pos.above()).getFluidState().getType() == Fluids.WATER && worldIn.getBlockState(pos.above()).getFluidState().getAmount() == 8) {
            worldIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, (double)pos.getX() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 2.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 2.0, 0.0, 0.0, 0.0);
        }
    }

    public void tick(BlockState p_221369_, ServerLevel p_221370_, BlockPos p_221371_, RandomSource p_221372_) {
        p_221370_.setBlock(p_221371_, ThermalCalciteBlock.updateDistance(p_221369_, (LevelAccessor)p_221370_, p_221371_), 3);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ItemTags.PICKAXES) && state.getBlock() == BOPBlocks.THERMAL_CALCITE) {
            if (!level.isClientSide()) {
                int distance = (Integer)state.getValue((Property)DISTANCE);
                level.playSound((Entity)((Player)null), pos, SoundEvents.CALCITE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, (BlockState)BOPBlocks.THERMAL_CALCITE_VENT.defaultBlockState().setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance)), 11);
                stack.hurtAndBreak(1, (LivingEntity)player, hand);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        int i = ThermalCalciteBlock.getDistanceAt(facingState) + 1;
        if (i != 1 || (Integer)state.getValue((Property)DISTANCE) != i) {
            tickAccess.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistance(BlockState p_54436_, LevelAccessor p_54437_, BlockPos p_54438_) {
        int i = 5;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_54438_, direction);
            i = Math.min(i, ThermalCalciteBlock.getDistanceAt(p_54437_.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)p_54436_.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState p_54464_) {
        return ThermalCalciteBlock.getOptionalDistanceAt(p_54464_).orElse(5);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState p_277868_) {
        if (p_277868_.getFluidState().getType() == Fluids.WATER || p_277868_.getFluidState().getType() == Fluids.LAVA || p_277868_.getBlock() instanceof IceBlock || p_277868_.getBlock() instanceof MagmaBlock) {
            return OptionalInt.of(0);
        }
        return p_277868_.hasProperty((Property)DISTANCE) ? OptionalInt.of((Integer)p_277868_.getValue((Property)DISTANCE)) : OptionalInt.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54447_) {
        p_54447_.add(new Property[]{DISTANCE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_54424_) {
        BlockState blockstate = this.defaultBlockState();
        return ThermalCalciteBlock.updateDistance(blockstate, (LevelAccessor)p_54424_.getLevel(), p_54424_.getClickedPos());
    }
}

