/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.HugeLilyPadBlock;
import biomesoplenty.block.properties.QuarterProperty;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;

public class HugeLilyPadFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> (world.getBlockState(pos).getFluidState().getType() == Fluids.WATER || world.getBlockState(pos).getBlock() instanceof IceBlock) && world.getBlockState(pos.above()).getFluidState().getType() == Fluids.EMPTY;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos) || world.getBlockState(pos).getBlock() == BOPBlocks.WATERGRASS;

    public HugeLilyPadFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(rand);
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinY() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.below();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        if (!this.checkSpace(world, startPos.above(), direction)) {
            return false;
        }
        BlockPos pos = startPos.above();
        this.setBlock(world, pos, (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.defaultBlockState().setValue(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.SOUTH_WEST))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
        this.setBlock(world, pos.relative(direction), (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.defaultBlockState().setValue(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.NORTH_WEST))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
        this.setBlock(world, pos.relative(direction).relative(direction.getClockWise()), (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.defaultBlockState().setValue(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.NORTH_EAST))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
        this.setBlock(world, pos.relative(direction.getClockWise()), (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.defaultBlockState().setValue(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.SOUTH_EAST))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            super.markAboveForPostProcessing(world, pos.below());
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, Direction direction) {
        BlockPos pos1 = pos;
        BlockPos pos2 = pos.relative(direction);
        BlockPos pos3 = pos2.relative(direction.getClockWise());
        BlockPos pos4 = pos.relative(direction.getClockWise());
        return pos1.getY() < 255 && this.replace.matches(world, pos1) && this.placeOn.matches(world, pos1.below()) && pos2.getY() < 255 && this.replace.matches(world, pos2) && this.placeOn.matches(world, pos2.below()) && pos3.getY() < 255 && this.replace.matches(world, pos3) && this.placeOn.matches(world, pos3.below()) && pos4.getY() < 255 && this.replace.matches(world, pos4) && this.placeOn.matches(world, pos4.below());
    }
}

