/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ThinBambooFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).getBlock() == Blocks.COARSE_DIRT;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)pos);
    private static final BlockState BAMBOO_TRUNK = (BlockState)((BlockState)((BlockState)Blocks.BAMBOO.defaultBlockState().setValue((Property)BambooStalkBlock.AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.NONE)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(1));
    private static final BlockState BAMBOO_TOP = (BlockState)BAMBOO_TRUNK.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.SMALL);

    public ThinBambooFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        while (pos.getY() >= world.getMinY() + 1 && this.replace.matches(world, pos)) {
            pos = pos.below();
        }
        if (!this.placeOn.matches(world, pos)) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos((pos = pos.above()).getX(), pos.getY(), pos.getZ());
        if (world.isEmptyBlock((BlockPos)blockpos$mutableblockpos) && Blocks.BAMBOO.defaultBlockState().canSurvive((LevelReader)world, (BlockPos)blockpos$mutableblockpos)) {
            int j = rand.nextInt(3) + 0;
            for (int l1 = 0; l1 < j && world.isEmptyBlock((BlockPos)blockpos$mutableblockpos); ++l1) {
                world.setBlock((BlockPos)blockpos$mutableblockpos, BAMBOO_TRUNK, 2);
                blockpos$mutableblockpos.move(Direction.UP, 1);
            }
            world.setBlock((BlockPos)blockpos$mutableblockpos, BAMBOO_TOP, 2);
        }
        return true;
    }
}

