/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.BrambleBlock;
import biomesoplenty.util.SimpleBlockPredicate;
import biomesoplenty.util.biome.GeneratorUtil;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BrambleFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> {
        BlockState state = world.getBlockState(pos);
        return Blocks.OAK_SAPLING.defaultBlockState().canSurvive((LevelReader)world, pos.above()) || state.getBlock() == Blocks.NETHERRACK;
    };
    protected SimpleBlockPredicate replace = (world, pos) -> world.getBlockState(pos).isAir();

    public BrambleFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        for (int i = 0; i < 128; ++i) {
            BlockPos genPos = startPos.offset(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.placeOn.matches(world, genPos.below()) || !this.replace.matches(world, genPos)) continue;
            int targetLength = GeneratorUtil.nextIntBetween(rand, 15, 30);
            int height = 0;
            int direction = rand.nextInt(4) + 2;
            block5: for (int length = 0; length <= targetLength && this.replace.matches(world, genPos); ++length) {
                world.setBlock(genPos, ((BrambleBlock)BOPBlocks.BRAMBLE).makeConnections((BlockGetter)world, genPos), 2);
                for (Direction face : Direction.values()) {
                    if (world.getBlockState(genPos.relative(face)).getBlock() != BOPBlocks.BRAMBLE) continue;
                    world.setBlock(genPos.relative(face), ((BrambleBlock)BOPBlocks.BRAMBLE).makeConnections((BlockGetter)world, genPos.relative(face)), 2);
                }
                if (rand.nextInt(2) == 0) {
                    direction = rand.nextInt(4) + 2;
                }
                if (rand.nextInt(2) == 0) {
                    int leafDirection = rand.nextInt(6);
                    BlockPos leafPos = genPos.relative(Direction.values()[leafDirection]);
                    if (world.isEmptyBlock(leafPos)) {
                        world.setBlock(leafPos, (BlockState)BOPBlocks.BRAMBLE_LEAVES.defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.values()[leafDirection]), 19);
                        for (Direction face : Direction.values()) {
                            if (world.getBlockState(leafPos.relative(face)).getBlock() != BOPBlocks.BRAMBLE) continue;
                            world.setBlock(leafPos.relative(face), ((BrambleBlock)BOPBlocks.BRAMBLE).makeConnections((BlockGetter)world, leafPos.relative(face)), 2);
                        }
                    }
                }
                switch (rand.nextInt(6)) {
                    case 0: 
                    case 1: {
                        if (height > 8) continue block5;
                        genPos = genPos.above();
                        ++height;
                        continue block5;
                    }
                    case 2: {
                        if (height < 0) continue block5;
                        genPos = genPos.below();
                        --height;
                        continue block5;
                    }
                    default: {
                        genPos = genPos.relative(Direction.values()[direction]);
                    }
                }
            }
        }
        return true;
    }
}

