/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.util.biome.GeneratorUtil;
import biomesoplenty.worldgen.feature.configurations.CypressTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class CypressTreeFeature
extends BOPTreeFeature<CypressTreeConfiguration> {
    public CypressTreeFeature(Codec<CypressTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        int i;
        CypressTreeConfiguration config = (CypressTreeConfiguration)configBase;
        while (startPos.getY() >= world.getMinY() + 1 && world.isEmptyBlock(startPos) || world.getBlockState(startPos).is(BlockTags.LEAVES)) {
            startPos = startPos.below();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        if (height < 4) {
            return false;
        }
        int baseHeight = height / 3;
        if (config.leavesAtBottom) {
            baseHeight = 0;
        }
        int leavesHeight = height - baseHeight;
        BlockPos pos = startPos.above();
        if (!this.checkSpace((LevelAccessor)world, pos, baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.placeLog((LevelAccessor)world, pos, logs, config);
            pos = pos.above();
        }
        for (i = 1; i < leavesHeight - 3; ++i) {
            for (int xx = -1; xx < 2; ++xx) {
                for (int zz = -1; zz < 2; ++zz) {
                    this.placeLeaves((LevelAccessor)world, pos.offset(xx, i, zz), leaves, config);
                }
            }
        }
        for (i = 0; i < leavesHeight; ++i) {
            int radius = this.radius(i, leavesHeight);
            this.generateLeafLayer((LevelAccessor)world, pos, radius, leaves, config);
            if (leavesHeight - i > 2) {
                this.placeLog((LevelAccessor)world, pos, logs, config);
            }
            pos = pos.above();
        }
        return true;
    }

    public int radius(int height, int maxHeight) {
        float x = (float)height / (float)maxHeight;
        float maxRadius = 1.0f + (float)maxHeight * 0.1f;
        float r = maxRadius * 0.6667f * x * (1.0f / (x * x + 0.08173f) - 0.9244f);
        return (int)(r + 0.5f);
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.offset(x, y, z);
                    if (pos1.getY() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(LevelAccessor world, BlockPos pos, int radius, FoliagePlacer.FoliageSetter leaves, CypressTreeConfiguration config) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (radius < 2) {
                    if (x * x + z * z > radius * radius) continue;
                    this.placeLeaves(world, pos.offset(x, 0, z), leaves, config);
                    continue;
                }
                if ((x == -radius || x == radius) && (z == -radius || z == radius)) continue;
                if (x == -radius || x == radius || z == -radius || z == radius) {
                    if (world.getRandom().nextInt(4) == 0) continue;
                    this.placeLeaves(world, pos.offset(x, 0, z), leaves, config);
                    continue;
                }
                this.placeLeaves(world, pos.offset(x, 0, z), leaves, config);
            }
        }
    }
}

