/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaAntiLag.mixin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.TreeOfSelf.PandaAntiLag.AntiLagSettings;
import me.TreeOfSelf.PandaAntiLag.LagPos;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1676.class})
public abstract class ProjectileEntityMixin
extends class_1297 {
    @Unique
    private static final Map<LagPos, Map<class_1299<?>, Integer>> projectileCounts = new HashMap();
    @Unique
    private static long lastProjectileCheck = 0L;

    public ProjectileEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    private static <T extends class_1676> void handleProjectileSpawn(T projectile, class_3218 world) {
        class_1299 projectileType;
        Map regionCounts;
        int count;
        LagPos lagPos = LagPos.fromChunkPos(projectile.method_31476());
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastProjectileCheck > 1000L) {
            projectileCounts.clear();
            lastProjectileCheck = currentTime;
        }
        if ((count = (regionCounts = projectileCounts.computeIfAbsent(lagPos, k -> new HashMap())).computeIfAbsent(projectileType = projectile.method_5864(), type -> world.method_18198(class_5575.method_31795(class_1676.class), entity -> {
            LagPos thisLagPos = LagPos.fromChunkPos(entity.method_31476());
            return Math.abs(thisLagPos.x - lagPos.x) <= AntiLagSettings.regionBuffer && Math.abs(thisLagPos.z - lagPos.z) <= AntiLagSettings.regionBuffer && entity.method_5864() == type;
        }).size()).intValue()) >= AntiLagSettings.projectileMax) {
            List nearbyEntities = world.method_18198(class_5575.method_31795(class_1676.class), entity -> {
                LagPos thisLagPos = LagPos.fromChunkPos(entity.method_31476());
                return Math.abs(thisLagPos.x - lagPos.x) <= AntiLagSettings.regionBuffer && Math.abs(thisLagPos.z - lagPos.z) <= AntiLagSettings.regionBuffer && entity.method_5864() == projectileType;
            });
            int over = nearbyEntities.size() - AntiLagSettings.projectileMax;
            for (int index = 0; index <= over; ++index) {
                ((class_1676)nearbyEntities.getFirst()).method_5650(class_1297.class_5529.field_26998);
            }
            regionCounts.put(projectileType, AntiLagSettings.projectileMax);
        } else {
            regionCounts.put(projectileType, count + 1);
        }
    }

    @Inject(method={"spawn(Lnet/minecraft/entity/projectile/ProjectileEntity;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/entity/projectile/ProjectileEntity;"}, at={@At(value="TAIL")})
    private static <T extends class_1676> void spawn(T projectile, class_3218 world, class_1799 projectileStack, CallbackInfoReturnable<T> cir) {
        ProjectileEntityMixin.handleProjectileSpawn(projectile, world);
    }

    @Inject(method={"spawn(Lnet/minecraft/entity/projectile/ProjectileEntity;Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/item/ItemStack;Ljava/util/function/Consumer;)Lnet/minecraft/entity/projectile/ProjectileEntity;"}, at={@At(value="TAIL")})
    private static <T extends class_1676> void spawn(T projectile, class_3218 world, class_1799 projectileStack, Consumer<T> beforeSpawn, CallbackInfoReturnable<T> cir) {
        ProjectileEntityMixin.handleProjectileSpawn(projectile, world);
    }
}

