/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaAntiLag.mixin;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import me.TreeOfSelf.PandaAntiLag.AntiLagSettings;
import me.TreeOfSelf.PandaAntiLag.ChunkEntityData;
import me.TreeOfSelf.PandaAntiLag.LagPos;
import me.TreeOfSelf.PandaAntiLag.mixin.accessor.ArmadilloEntityAccessor;
import me.TreeOfSelf.PandaAntiLag.mixin.accessor.BeeEntityAccessor;
import me.TreeOfSelf.PandaAntiLag.mixin.accessor.SheepEntityAccessor;
import me.TreeOfSelf.PandaAntiLag.mixin.accessor.TadpoleEntityAccessor;
import me.TreeOfSelf.PandaAntiLag.mixin.accessor.TurtleEntityAccessor;
import me.TreeOfSelf.PandaAntiLag.mixin.accessor.VillagerEntityAccessor;
import net.minecraft.class_10209;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1345;
import net.minecraft.class_1428;
import net.minecraft.class_1472;
import net.minecraft.class_1481;
import net.minecraft.class_1510;
import net.minecraft.class_1646;
import net.minecraft.class_1923;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.class_3989;
import net.minecraft.class_4466;
import net.minecraft.class_5574;
import net.minecraft.class_5575;
import net.minecraft.class_7110;
import net.minecraft.class_8836;
import net.minecraft.class_8921;
import net.minecraft.class_9069;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class ServerLevelMixin {
    @Unique
    private double tickCount = 0.0;
    @Shadow
    @Final
    private class_3215 field_24624;
    @Shadow
    @Final
    private static Logger field_13952;
    @Unique
    private final HashMap<LagPos, ChunkEntityData> chunkEntityDataMap = new HashMap();
    @Unique
    private class_3695 profiler;
    @Unique
    private final Map<class_1299<?>, Integer> entityTypeCache = new HashMap();

    @Shadow
    public abstract class_8921 method_54719();

    @Shadow
    public abstract void method_18762(class_1297 var1);

    @Shadow
    public abstract boolean method_67504(class_1923 var1);

    @Unique
    public int getEntityType(class_1297 entity) {
        if (entity instanceof class_8836) {
            return 3;
        }
        if (!(entity instanceof class_1309)) {
            return 0;
        }
        if (entity instanceof class_1510) {
            return 0;
        }
        if (entity instanceof class_1646) {
            return 2;
        }
        if (entity instanceof class_3989) {
            return 2;
        }
        return this.entityTypeCache.computeIfAbsent(entity.method_5864(), type -> {
            class_1311 group = type.method_5891();
            if (group == class_1311.field_6302) {
                return 1;
            }
            if (group == class_1311.field_6294 || group == class_1311.field_34447 || group == class_1311.field_30092 || group == class_1311.field_6303 || group == class_1311.field_24460 || group == class_1311.field_17715 || group == class_1311.field_6300) {
                return 2;
            }
            return 0;
        });
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTickStart(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        this.profiler = class_10209.method_64146();
    }

    @Unique
    public void updateEntityCounts(ChunkEntityData chunkEntityData, class_3218 serverWorld, LagPos lagPos) {
        int[] counts = new int[4];
        serverWorld.method_18198(class_5575.method_31795(class_1297.class), foundEntity -> {
            int entityType;
            LagPos entityLagPos = LagPos.fromChunkPos(foundEntity.method_31476());
            if (Math.abs(entityLagPos.x - lagPos.x) < AntiLagSettings.regionBuffer && Math.abs(entityLagPos.z - lagPos.z) < AntiLagSettings.regionBuffer && (entityType = this.getEntityType((class_1297)foundEntity)) != 0) {
                int n = entityType;
                counts[n] = counts[n] + 1;
            }
            return false;
        });
        float tickTimes = serverWorld.method_8503().method_54832();
        for (int type = 1; type < 4; ++type) {
            int staggerLenience;
            int minimumRegion;
            int entityCount = counts[type];
            if (type == 3) {
                minimumRegion = AntiLagSettings.minimumRegionVehicle;
                staggerLenience = AntiLagSettings.vehicleStaggerLenience;
            } else {
                minimumRegion = AntiLagSettings.minimumRegionMobs;
                staggerLenience = AntiLagSettings.mobStaggerLenience;
            }
            if (entityCount > minimumRegion) {
                if ((entityCount = (int)((float)entityCount / (float)staggerLenience + tickTimes / (float)AntiLagSettings.tickTimeLenience)) <= 0) {
                    entityCount = 1;
                }
            } else {
                entityCount = 1;
            }
            chunkEntityData.setNearbyCount(type, entityCount);
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/EntityList;forEach(Ljava/util/function/Consumer;)V", ordinal=0))
    private <T> void redirectEntityTick(class_5574 instance, Consumer<class_1297> action) {
        this.tickCount += 1.0;
        class_3218 serverWorld = (class_3218)this;
        long currentTime = System.currentTimeMillis();
        instance.method_31791(entity -> {
            boolean skip;
            LagPos lagPos = LagPos.fromChunkPos(entity.method_31476());
            ChunkEntityData chunkEntityData = this.chunkEntityDataMap.computeIfAbsent(lagPos, k -> new ChunkEntityData());
            if (chunkEntityData.lastCheck == 0L || currentTime > chunkEntityData.lastCheck) {
                chunkEntityData.lastCheck = currentTime + AntiLagSettings.updateInterval;
                this.updateEntityCounts(chunkEntityData, serverWorld, lagPos);
            }
            boolean bl = skip = (this.tickCount + (double)entity.method_5628()) % (double)chunkEntityData.getNearbyCount(this.getEntityType((class_1297)entity)) != 0.0;
            if (!(entity.method_31481() || skip && entity.method_5864() != class_1299.field_6097 && !entity.method_42148())) {
                if (!this.method_54719().method_54746(entity)) {
                    this.profiler.method_15396("checkDespawn");
                    entity.method_5982();
                    this.profiler.method_15407();
                    if (entity instanceof class_3222 || this.field_24624.field_17254.method_17263().method_38630(entity.method_31476().method_8324())) {
                        class_1297 entity2 = entity.method_5854();
                        if (entity2 != null) {
                            if (!entity2.method_31481() && entity2.method_5626(entity)) {
                                return;
                            }
                            entity.method_5848();
                        }
                        this.profiler.method_15396("tick");
                        this.method_18762((class_1297)entity);
                        this.profiler.method_15407();
                    }
                }
            } else if (skip) {
                ++entity.field_6012;
                if (entity instanceof class_1296) {
                    class_1296 passiveEntity = (class_1296)entity;
                    int i = passiveEntity.method_5618();
                    if (i < 0) {
                        passiveEntity.method_5614(++i);
                    } else if (i > 0) {
                        passiveEntity.method_5614(--i);
                    }
                }
                class_1297 class_12972 = entity;
                Objects.requireNonNull(class_12972);
                class_1297 selector0$temp = class_12972;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1472.class, class_9069.class, class_1428.class, class_7110.class, class_1481.class, class_1646.class, class_4466.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        class_1472 sheepEntity = (class_1472)selector0$temp;
                        class_1345 eatGrassGoal = ((SheepEntityAccessor)sheepEntity).getEatGrassGoal();
                        if (eatGrassGoal == null) break;
                        if (eatGrassGoal.method_6266()) {
                            eatGrassGoal.method_6268();
                            break;
                        }
                        if (!eatGrassGoal.method_6264()) break;
                        eatGrassGoal.method_6269();
                        break;
                    }
                    case 1: {
                        class_9069 armadilloEntity = (class_9069)selector0$temp;
                        int cooldown = ((ArmadilloEntityAccessor)armadilloEntity).getNextScuteShedCooldown();
                        if (cooldown <= 0) break;
                        ((ArmadilloEntityAccessor)armadilloEntity).setNextScuteShedCooldown(cooldown - 1);
                        break;
                    }
                    case 2: {
                        class_1428 chickenEntity = (class_1428)selector0$temp;
                        --chickenEntity.field_6739;
                        break;
                    }
                    case 3: {
                        class_7110 tadpoleEntity = (class_7110)selector0$temp;
                        int tadPoleAge = ((TadpoleEntityAccessor)tadpoleEntity).getTadpoleAge();
                        ((TadpoleEntityAccessor)tadpoleEntity).setTadpoleAge(tadPoleAge + 1);
                        break;
                    }
                    case 4: {
                        class_1481 turtleEntity = (class_1481)selector0$temp;
                        if (!turtleEntity.method_6695()) break;
                        int sandDiggingCounter = ((TurtleEntityAccessor)turtleEntity).getSandDiggingCounter();
                        ((TurtleEntityAccessor)turtleEntity).setSandDiggingCounter(sandDiggingCounter + 1);
                        break;
                    }
                    case 5: {
                        int levelUpTimer;
                        class_1646 villagerEntity = (class_1646)selector0$temp;
                        if (villagerEntity.method_18009() || (levelUpTimer = ((VillagerEntityAccessor)villagerEntity).getLevelUpTimer()) <= 0) break;
                        ((VillagerEntityAccessor)villagerEntity).setLevelUpTimer(levelUpTimer - 1);
                        break;
                    }
                    case 6: {
                        int ticksUntilCanPollinate;
                        int ticksLeftToFindHive;
                        int cannotEnterHiveTicks;
                        class_4466 beeEntity = (class_4466)selector0$temp;
                        if (beeEntity.method_21785()) {
                            int ticksSinceSting = ((BeeEntityAccessor)beeEntity).getTicksSinceSting();
                            ((BeeEntityAccessor)beeEntity).setTicksSinceSting(ticksSinceSting + 1);
                        }
                        if (!beeEntity.method_21784()) {
                            int ticksSincePollination = ((BeeEntityAccessor)beeEntity).getTicksSincePollination();
                            ((BeeEntityAccessor)beeEntity).setTicksSincePollination(ticksSincePollination + 1);
                        }
                        if ((cannotEnterHiveTicks = ((BeeEntityAccessor)beeEntity).getCannotEnterHiveTicks()) > 0) {
                            ((BeeEntityAccessor)beeEntity).setCannotEnterHiveTicks(cannotEnterHiveTicks - 1);
                        }
                        if ((ticksLeftToFindHive = ((BeeEntityAccessor)beeEntity).getTicksLeftToFindHive()) > 0) {
                            ((BeeEntityAccessor)beeEntity).setTicksLeftToFindHive(ticksLeftToFindHive - 1);
                        }
                        if ((ticksUntilCanPollinate = ((BeeEntityAccessor)beeEntity).getTicksUntilCanPollinate()) <= 0) break;
                        ((BeeEntityAccessor)beeEntity).setTicksUntilCanPollinate(ticksUntilCanPollinate - 1);
                        break;
                    }
                }
            }
        });
    }
}

