/*
 * Decompiled with CFR 0.152.
 */
package dev.wolfieboy09.tfmgjs.recipes.schemas;

import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ComponentValueMap;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.wolfieboy09.tfmgjs.recipes.schemas.TFMGRecipeSchema;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TFMGRecipeFactory {
    @Nullable
    RecipeKey<InputFluid[]> FLUID_INGREDIENTS = null;
    @Nullable
    RecipeKey<OutputFluid[]> FLUID_RESULTS = null;
    @Nullable
    RecipeKey<InputItem[]> ITEM_INGREDIENTS = null;
    @Nullable
    RecipeKey<OutputItem[]> ITEM_RESULTS = null;
    @Nullable
    RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS = null;
    @Nullable
    RecipeKey<Either<OutputFluid, OutputItem>[]> RESULTS = null;
    boolean hasProcessingTime = false;
    boolean usesEnergy = false;
    private int maxItemOutputs = 1;
    private int maxFluidOutputs = 1;
    private int maxItemInputs = 1;
    private int maxFluidInputs = 1;
    RecipeConstructor.Factory factory = (recipe, schemaType, keys, from) -> {
        this.keyCheck();
        if (this.ITEM_RESULTS != null) {
            recipe.setValue(this.ITEM_RESULTS, (Object)((OutputItem[])from.getValue(recipe, this.ITEM_RESULTS)));
        }
        if (this.FLUID_RESULTS != null) {
            recipe.setValue(this.FLUID_RESULTS, (Object)((OutputFluid[])from.getValue(recipe, this.FLUID_RESULTS)));
        }
        if (this.RESULTS != null) {
            recipe.setValue(this.RESULTS, (Object)((Either[])from.getValue(recipe, this.RESULTS)));
        }
        if (this.ITEM_INGREDIENTS != null) {
            this.handleItemIngredients(recipe, from);
        }
        if (this.FLUID_INGREDIENTS != null) {
            this.handleFluidIngredients(recipe, from);
        }
        if (this.INGREDIENTS != null) {
            this.handlePairedIngredients(recipe, from);
        }
        if (this.hasProcessingTime) {
            recipe.setValue(TFMGRecipeSchema.PROCESSING_TIME, (Object)((Long)from.getValue(recipe, TFMGRecipeSchema.PROCESSING_TIME)));
        }
        if (this.usesEnergy) {
            recipe.setValue(TFMGRecipeSchema.ENERGY, (Object)((Integer)from.getValue(recipe, TFMGRecipeSchema.ENERGY)));
        }
        if (this.ITEM_RESULTS != null) {
            this.handleItemResults(recipe, from);
        }
        if (this.FLUID_RESULTS != null) {
            this.handleFluidResults(recipe, from);
        }
        if (this.RESULTS != null) {
            this.handlePairedResults(recipe, from);
        }
    };

    TFMGRecipeFactory() {
    }

    public TFMGRecipeFactory create(RecipeKey<InputFluid[]> fluidIngredients, RecipeKey<OutputFluid[]> fluidResults, RecipeKey<InputItem[]> itemIngredients, RecipeKey<OutputItem[]> itemResults) {
        this.FLUID_INGREDIENTS = fluidIngredients;
        this.FLUID_RESULTS = fluidResults;
        this.ITEM_INGREDIENTS = itemIngredients;
        this.ITEM_RESULTS = itemResults;
        return this;
    }

    public TFMGRecipeFactory hasTime() {
        this.hasProcessingTime = true;
        return this;
    }

    public TFMGRecipeFactory usesEnergy() {
        this.usesEnergy = true;
        return this;
    }

    public TFMGRecipeFactory itemOutputs(RecipeKey<OutputItem[]> itemResults, int maxItemOutputs) {
        this.ITEM_RESULTS = itemResults;
        this.maxItemOutputs = maxItemOutputs;
        return this;
    }

    public TFMGRecipeFactory fluidOutputs(RecipeKey<OutputFluid[]> fluidResults, int maxFluidOutputs) {
        this.FLUID_RESULTS = fluidResults;
        this.maxFluidOutputs = maxFluidOutputs;
        return this;
    }

    public TFMGRecipeFactory itemInputs(RecipeKey<InputItem[]> itemIngredients, int maxItemInputs) {
        this.ITEM_INGREDIENTS = itemIngredients;
        this.maxItemInputs = maxItemInputs;
        return this;
    }

    public TFMGRecipeFactory fluidInputs(RecipeKey<InputFluid[]> fluidIngredients, int maxFluidInputs) {
        this.FLUID_INGREDIENTS = fluidIngredients;
        this.maxFluidInputs = maxFluidInputs;
        return this;
    }

    public TFMGRecipeFactory ingredients(RecipeKey<Either<InputFluid, InputItem>[]> ingredients, int maxItemInputs, int maxFluidInputs) {
        this.INGREDIENTS = ingredients;
        this.maxItemInputs = maxItemInputs;
        this.maxFluidInputs = maxFluidInputs;
        return this;
    }

    public TFMGRecipeFactory results(RecipeKey<Either<OutputFluid, OutputItem>[]> results, int maxItemOutputs, int maxFluidOutputs) {
        this.RESULTS = results;
        this.maxItemOutputs = maxItemOutputs;
        this.maxFluidOutputs = maxFluidOutputs;
        return this;
    }

    private void keyCheck() {
        if (this.FLUID_INGREDIENTS == null && this.ITEM_INGREDIENTS == null && this.INGREDIENTS == null) {
            throw new RecipeExceptionJS("Recipe must have at least one ingredient type defined");
        }
        if (this.FLUID_RESULTS == null && this.ITEM_RESULTS == null && this.RESULTS == null) {
            throw new RecipeExceptionJS("Recipe must have at least one result type defined");
        }
        if (this.INGREDIENTS != null && (this.ITEM_INGREDIENTS != null || this.FLUID_INGREDIENTS != null)) {
            throw new RecipeExceptionJS("Recipe cannot have both paired ingredients and separate item/fluid ingredients defined");
        }
        if (this.RESULTS != null && (this.ITEM_RESULTS != null || this.FLUID_RESULTS != null)) {
            throw new RecipeExceptionJS("Recipe cannot have both paired results and separate item/fluid results defined");
        }
    }

    private void handleFluidIngredients(RecipeJS recipe, @NotNull ComponentValueMap from) {
        InputFluid[] ingredients = (InputFluid[])from.getValue(recipe, this.FLUID_INGREDIENTS);
        if (ingredients.length > this.maxFluidInputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxFluidInputs + " fluid ingredients");
        }
        recipe.setValue(this.FLUID_INGREDIENTS, (Object)ingredients);
    }

    private void handleItemIngredients(RecipeJS recipe, @NotNull ComponentValueMap from) {
        InputItem[] ingredients = (InputItem[])from.getValue(recipe, this.ITEM_INGREDIENTS);
        if (ingredients.length > this.maxItemInputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxItemInputs + " item ingredients");
        }
        recipe.setValue(this.ITEM_INGREDIENTS, (Object)ingredients);
    }

    private void handlePairedIngredients(RecipeJS recipe, @NotNull ComponentValueMap from) {
        Either[] ingredients = (Either[])from.getValue(recipe, this.INGREDIENTS);
        ArrayList<InputFluid> fluidIngredients = new ArrayList<InputFluid>();
        ArrayList<InputItem> itemIngredients = new ArrayList<InputItem>();
        for (Either ingredient : ingredients) {
            if (ingredient.left().isPresent()) {
                fluidIngredients.add((InputFluid)ingredient.left().get());
            }
            if (!ingredient.right().isPresent()) continue;
            itemIngredients.add((InputItem)ingredient.right().get());
        }
        if (fluidIngredients.size() > this.maxFluidInputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxFluidInputs + " fluid ingredients");
        }
        if (itemIngredients.size() > this.maxItemInputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxItemInputs + " item ingredients");
        }
        recipe.setValue(this.INGREDIENTS, (Object)ingredients);
    }

    private void handleFluidResults(RecipeJS recipe, @NotNull ComponentValueMap from) {
        OutputFluid[] results = (OutputFluid[])from.getValue(recipe, this.FLUID_RESULTS);
        if (results.length > this.maxFluidOutputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxFluidOutputs + " fluid results");
        }
        recipe.setValue(this.FLUID_RESULTS, (Object)results);
    }

    private void handleItemResults(RecipeJS recipe, @NotNull ComponentValueMap from) {
        OutputItem[] results = (OutputItem[])from.getValue(recipe, this.ITEM_RESULTS);
        if (results.length > this.maxItemOutputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxItemOutputs + " item results");
        }
        recipe.setValue(this.ITEM_RESULTS, (Object)results);
    }

    private void handlePairedResults(RecipeJS recipe, @NotNull ComponentValueMap from) {
        Either[] results = (Either[])from.getValue(recipe, this.RESULTS);
        ArrayList<OutputFluid> fluidResults = new ArrayList<OutputFluid>();
        ArrayList<OutputItem> itemResults = new ArrayList<OutputItem>();
        for (Either result : results) {
            if (result.left().isPresent()) {
                fluidResults.add((OutputFluid)result.left().get());
            }
            if (!result.right().isPresent()) continue;
            itemResults.add((OutputItem)result.right().get());
        }
        if (fluidResults.size() > this.maxFluidOutputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxFluidOutputs + " fluid results");
        }
        if (itemResults.size() > this.maxItemOutputs) {
            throw new RecipeExceptionJS("Recipe can only a max of " + this.maxItemOutputs + " item results");
        }
        recipe.setValue(this.RESULTS, (Object)results);
    }
}

