/*
 * Decompiled with CFR 0.152.
 */
package dev.wolfieboy09.tfmgjs.recipes.schemas;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.BlockTagIngredient;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.TagContext;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.wolfieboy09.tfmgjs.recipes.helpers.CreateInputFluid;
import dev.wolfieboy09.tfmgjs.recipes.helpers.FluidIngredientHelper;
import dev.wolfieboy09.tfmgjs.recipes.schemas.TFMGRecipeFactory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public interface TFMGRecipeSchema {
    public static final RecipeKey<Either<OutputFluid, OutputItem>[]> RESULTS = FluidComponents.OUTPUT_OR_ITEM_ARRAY.key("results");
    public static final RecipeKey<OutputFluid[]> FLUID_RESULTS = FluidComponents.OUTPUT_ARRAY.key("results");
    public static final RecipeKey<OutputItem[]> ITEM_RESULTS = ItemComponents.OUTPUT_ARRAY.key("results");
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS = FluidComponents.INPUT_OR_ITEM_ARRAY.key("ingredients");
    public static final RecipeKey<InputFluid[]> FLUID_INGREDIENTS = FluidComponents.INPUT_ARRAY.key("ingredients");
    public static final RecipeKey<InputItem[]> ITEM_INGREDIENTS = ItemComponents.INPUT_ARRAY.key("ingredients");
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS_UNWRAPPED = new RecipeComponentWithParent<Either<InputFluid, InputItem>[]>(){

        public RecipeComponent<Either<InputFluid, InputItem>[]> parentComponent() {
            return TFMGRecipeSchema.INGREDIENTS.component;
        }

        public JsonElement write(RecipeJS recipe, Either<InputFluid, InputItem>[] value) {
            JsonArray json = new JsonArray();
            for (Either<InputFluid, InputItem> either : value) {
                either.ifLeft(fluid -> json.add(FluidComponents.INPUT.write(recipe, fluid))).ifRight(item -> {
                    for (InputItem unwrapped : item.unwrap()) {
                        json.add(ItemComponents.INPUT.write(recipe, (Object)unwrapped));
                    }
                });
            }
            return json;
        }
    }.key("ingredients");
    public static final RecipeKey<InputFluid[]> FLUID_INGREDIENT_UNWRAPPED = new RecipeComponentWithParent<InputFluid[]>(){

        public RecipeComponent<InputFluid[]> parentComponent() {
            return TFMGRecipeSchema.FLUID_INGREDIENTS.component;
        }

        public JsonElement write(RecipeJS recipe, InputFluid[] values) {
            JsonArray json = new JsonArray();
            for (InputFluid unwrapped : values) {
                json.add(FluidComponents.INPUT.write(recipe, (Object)unwrapped));
            }
            return json;
        }
    }.key("ingredients");
    public static final RecipeKey<InputItem[]> ITEM_INGREDIENT_UNWRAPPED = new RecipeComponentWithParent<InputItem[]>(){

        public RecipeComponent<InputItem[]> parentComponent() {
            return TFMGRecipeSchema.ITEM_INGREDIENTS.component;
        }

        public JsonElement write(RecipeJS recipe, InputItem[] value) {
            JsonArray json = new JsonArray();
            for (InputItem item : value) {
                for (InputItem unwrapped : item.unwrap()) {
                    json.add(ItemComponents.INPUT.write(recipe, (Object)unwrapped));
                }
            }
            return json;
        }
    }.key("ingredients");
    public static final RecipeKey<Long> PROCESSING_TIME = TimeComponent.TICKS.key("processingTime").optional((Object)100L);
    public static final RecipeKey<Long> PROCESSING_TIME_REQUIRED = TimeComponent.TICKS.key("processingTime").optional((Object)100L).alwaysWrite();
    public static final RecipeKey<Integer> ENERGY = NumberComponent.INT.key("energy");
    public static final RecipeKey<Integer> RPM_MAX = NumberComponent.INT.key("rpm_max").optional((Object)1);
    public static final RecipeKey<Integer> RPM_MIN = NumberComponent.INT.key("rpm_min").optional((Object)1);
    public static final RecipeKey<Float> POWER = NumberComponent.FLOAT.key("power").optional((Object)Float.valueOf(1.0f));
    public static final RecipeKey<String> HEAT_REQUIREMENT = new StringComponent("not a valid heat condition!", s -> {
        for (HeatCondition h : HeatCondition.values()) {
            if (!h.name().equalsIgnoreCase((String)s)) continue;
            return true;
        }
        return false;
    }).key("heatRequirement").defaultOptional().allowEmpty();
    public static final RecipeKey<Boolean> KEEP_HELD_ITEM = BooleanComponent.BOOLEAN.key("keepHeldItem").optional((Object)false);
    public static final RecipeSchema PROCESSING_DEFAULT = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, PROCESSING_TIME, HEAT_REQUIREMENT});
    public static final RecipeSchema PROCESSING_WITH_TIME = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, PROCESSING_TIME_REQUIRED, HEAT_REQUIREMENT});
    public static final RecipeSchema PROCESSING_WITH_ENERGY = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, ENERGY, PROCESSING_TIME, HEAT_REQUIREMENT});
    public static final RecipeSchema PROCESSING_UNWRAPPED = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS_UNWRAPPED, PROCESSING_TIME, HEAT_REQUIREMENT});
    public static final RecipeSchema ITEM_APPLICATION = new RecipeSchema(ItemApplicationRecipeJS.class, ItemApplicationRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, PROCESSING_TIME, HEAT_REQUIREMENT, KEEP_HELD_ITEM});
    public static final RecipeSchema COKING = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{ITEM_INGREDIENTS, RESULTS, PROCESSING_TIME}).constructor(new TFMGRecipeFactory().itemInputs(TFMGRecipeSchema.ITEM_INGREDIENTS, (int)1).results(TFMGRecipeSchema.RESULTS, (int)1, (int)2).hasTime().factory, new RecipeKey[]{ITEM_INGREDIENTS, RESULTS, PROCESSING_TIME});
    public static final RecipeSchema DISTILLATION = new RecipeSchema(new RecipeKey[]{FLUID_INGREDIENTS, FLUID_RESULTS}).constructor(new TFMGRecipeFactory().fluidInputs(TFMGRecipeSchema.FLUID_INGREDIENTS, (int)1).fluidOutputs(TFMGRecipeSchema.FLUID_RESULTS, (int)6).factory, new RecipeKey[]{FLUID_INGREDIENTS, FLUID_RESULTS});
    public static final RecipeSchema INDUSTRIAL_BLASTING = new RecipeSchema(new RecipeKey[]{ITEM_INGREDIENTS, FLUID_RESULTS, PROCESSING_TIME}).constructor(new TFMGRecipeFactory().itemInputs(TFMGRecipeSchema.ITEM_INGREDIENTS, (int)2).fluidOutputs(TFMGRecipeSchema.FLUID_RESULTS, (int)3).hasTime().factory, new RecipeKey[]{ITEM_INGREDIENTS, FLUID_RESULTS, PROCESSING_TIME});
    public static final RecipeSchema POLARIZING = new RecipeSchema(new RecipeKey[]{ITEM_INGREDIENTS, ITEM_RESULTS, ENERGY}).constructor(new TFMGRecipeFactory().itemInputs(TFMGRecipeSchema.ITEM_INGREDIENTS, (int)1).itemOutputs(TFMGRecipeSchema.ITEM_RESULTS, (int)1).usesEnergy().factory, new RecipeKey[]{ITEM_INGREDIENTS, ITEM_RESULTS, ENERGY});
    public static final RecipeSchema WINDING = new RecipeSchema(new RecipeKey[]{ITEM_INGREDIENTS, ITEM_RESULTS, PROCESSING_TIME}).constructor(new TFMGRecipeFactory().itemInputs(TFMGRecipeSchema.ITEM_INGREDIENTS, (int)2).itemOutputs(TFMGRecipeSchema.ITEM_RESULTS, (int)1).hasTime().factory, new RecipeKey[]{ITEM_INGREDIENTS, ITEM_RESULTS, PROCESSING_TIME});
    public static final RecipeSchema HOT_BLASTING = new RecipeSchema(new RecipeKey[]{FLUID_INGREDIENTS, FLUID_RESULTS, PROCESSING_TIME}).constructor(new TFMGRecipeFactory().fluidInputs(TFMGRecipeSchema.FLUID_INGREDIENTS, (int)2).fluidOutputs(TFMGRecipeSchema.FLUID_RESULTS, (int)2).hasTime().factory, new RecipeKey[]{FLUID_INGREDIENTS, FLUID_RESULTS, PROCESSING_TIME});

    public static class ProcessingRecipeJS
    extends RecipeJS {
        public InputFluid readInputFluid(Object from) {
            if (from instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)from;
                return fluid;
            }
            if (from instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)from;
                return new CreateInputFluid(fluid);
            }
            if (from instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)from;
                return new CreateInputFluid(FluidIngredientHelper.toFluidIngredient(fluid));
            }
            if (from instanceof FluidStack) {
                FluidStack fluid = (FluidStack)from;
                return new CreateInputFluid(FluidIngredient.fromFluidStack((FluidStack)fluid));
            }
            JsonObject json = MapJS.json((Object)from);
            if (json != null) {
                return new CreateInputFluid(FluidIngredient.deserialize((JsonElement)json));
            }
            return CreateInputFluid.EMPTY;
        }

        public JsonElement writeInputFluid(InputFluid value) {
            if (value instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)value;
                return fluid.ingredient().serialize();
            }
            if (value instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)value;
                return fluid.serialize();
            }
            if (value instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)value;
                return FluidIngredientHelper.toFluidIngredient(fluid).serialize();
            }
            return FluidIngredient.EMPTY.serialize();
        }

        public boolean inputItemHasPriority(Object from) {
            if (from instanceof InputItem || from instanceof Ingredient || from instanceof ItemStack) {
                return true;
            }
            InputItem input = this.readInputItem(from);
            Ingredient ingredient = input.ingredient;
            if (ingredient instanceof BlockTagIngredient) {
                BlockTagIngredient blockTag = (BlockTagIngredient)ingredient;
                return !((TagContext)TagContext.INSTANCE.getValue()).isEmpty(blockTag.getTag());
            }
            return !input.isEmpty();
        }

        public boolean inputFluidHasPriority(Object from) {
            return from instanceof InputFluid || FluidIngredient.isFluidIngredient((JsonElement)MapJS.json((Object)from));
        }

        public OutputItem readOutputItem(Object from) {
            JsonObject j;
            if (from instanceof ProcessingOutput) {
                ProcessingOutput output = (ProcessingOutput)from;
                return OutputItem.of((ItemStack)output.getStack(), (double)output.getChance());
            }
            OutputItem outputItem = super.readOutputItem(from);
            if (from instanceof JsonObject && (j = (JsonObject)from).has("chance")) {
                return outputItem.withChance((double)j.get("chance").getAsFloat());
            }
            return outputItem;
        }

        public RecipeJS heated() {
            return this.setValue(HEAT_REQUIREMENT, HeatCondition.HEATED.serialize());
        }

        public RecipeJS superheated() {
            return this.setValue(HEAT_REQUIREMENT, HeatCondition.SUPERHEATED.serialize());
        }
    }

    public static class ItemApplicationRecipeJS
    extends ProcessingRecipeJS {
        public RecipeJS keepHeldItem() {
            return this.setValue(KEEP_HELD_ITEM, true);
        }
    }
}

