/*
 * Decompiled with CFR 0.152.
 */
package dev.wolfieboy09.tfmgjs.recipes.schemas.vat;

import com.mojang.datafixers.util.Either;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.component.ComponentValueMap;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.wolfieboy09.tfmgjs.recipes.schemas.vat.VatRecipeSchema;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class VatRecipeFactory {
    RecipeConstructor.Factory factory = (recipe, schemaType, keys, from) -> {
        String[] machines = (String[])from.getValue(recipe, VatRecipeSchema.MACHINES);
        String[] vatTypes = (String[])from.getValue(recipe, VatRecipeSchema.VAT_TYPES);
        int minSize = (Integer)from.getValue(recipe, VatRecipeSchema.MIN_SIZE);
        HeatCondition heatCondition = HeatCondition.deserialize((String)((String)from.getValue(recipe, VatRecipeSchema.HEAT_REQUIREMENT)));
        long processingTime = (Long)from.getValue(recipe, VatRecipeSchema.PROCESSING_TIME_REQUIRED);
        this.handleIngredients(recipe, from);
        this.handleResults(recipe, from);
        recipe.setValue(VatRecipeSchema.MACHINES, (Object)machines);
        recipe.setValue(VatRecipeSchema.VAT_TYPES, (Object)vatTypes);
        if (minSize <= 0) {
            throw new RecipeExceptionJS("Vat Recipe min size must be greater than 0");
        }
        recipe.setValue(VatRecipeSchema.MIN_SIZE, (Object)minSize);
        recipe.setValue(VatRecipeSchema.HEAT_REQUIREMENT, (Object)heatCondition.serialize());
        recipe.setValue(VatRecipeSchema.PROCESSING_TIME_REQUIRED, (Object)processingTime);
    };

    private void handleIngredients(RecipeJS recipe, @NotNull ComponentValueMap from) {
        Either[] ingredients = (Either[])from.getValue(recipe, VatRecipeSchema.INGREDIENTS);
        ArrayList<InputFluid> fluidIngredients = new ArrayList<InputFluid>();
        ArrayList<InputItem> itemIngredients = new ArrayList<InputItem>();
        for (Either ingredient : ingredients) {
            if (ingredient.left().isPresent()) {
                fluidIngredients.add((InputFluid)ingredient.left().get());
            }
            if (!ingredient.right().isPresent()) continue;
            itemIngredients.add((InputItem)ingredient.right().get());
        }
        if (fluidIngredients.size() > 4) {
            throw new RecipeExceptionJS("Vat Recipe can only have a max of 4 fluid ingredients");
        }
        if (itemIngredients.size() > 4) {
            throw new RecipeExceptionJS("Vat Recipe can only have a max of 4 item ingredients");
        }
        recipe.setValue(VatRecipeSchema.INGREDIENTS, (Object)ingredients);
    }

    private void handleResults(RecipeJS recipe, @NotNull ComponentValueMap from) {
        Either[] results = (Either[])from.getValue(recipe, VatRecipeSchema.RESULTS);
        ArrayList<OutputFluid> fluidResults = new ArrayList<OutputFluid>();
        ArrayList<OutputItem> itemResults = new ArrayList<OutputItem>();
        for (Either result : results) {
            if (result.left().isPresent()) {
                fluidResults.add((OutputFluid)result.left().get());
            }
            if (!result.right().isPresent()) continue;
            itemResults.add((OutputItem)result.right().get());
        }
        if (fluidResults.size() > 4) {
            throw new RecipeExceptionJS("Vat Recipe can only have a max of 4 fluid outputs");
        }
        if (itemResults.size() > 4) {
            throw new RecipeExceptionJS("Vat Recipe can only have a max of 4 item outputs");
        }
        recipe.setValue(VatRecipeSchema.RESULTS, (Object)results);
    }
}

