/*
 * Decompiled with CFR 0.152.
 */
package dev.wolfieboy09.tfmgjs.recipes.schemas.vat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.BlockTagIngredient;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.TagContext;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.wolfieboy09.tfmgjs.recipes.helpers.CreateInputFluid;
import dev.wolfieboy09.tfmgjs.recipes.helpers.FluidIngredientHelper;
import dev.wolfieboy09.tfmgjs.recipes.schemas.vat.VatRecipeFactory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public interface VatRecipeSchema {
    public static final RecipeKey<Either<OutputFluid, OutputItem>[]> RESULTS = FluidComponents.OUTPUT_OR_ITEM_ARRAY.key("results");
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS = FluidComponents.INPUT_OR_ITEM_ARRAY.key("ingredients");
    public static final RecipeKey<String[]> MACHINES = StringComponent.ID.asArray().key("machines").defaultOptional().allowEmpty();
    public static final RecipeKey<String[]> VAT_TYPES = StringComponent.ID.asArray().key("allowedVatTypes").defaultOptional().allowEmpty();
    public static final RecipeKey<Integer> MIN_SIZE = NumberComponent.INT.key("minSize").optional((Object)1).allowEmpty();
    public static final RecipeKey<String> HEAT_REQUIREMENT = new StringComponent("not a valid heat condition!", s -> {
        for (HeatCondition h : HeatCondition.values()) {
            if (!h.name().equalsIgnoreCase((String)s)) continue;
            return true;
        }
        return false;
    }).key("heatRequirement").defaultOptional().allowEmpty();
    public static final RecipeKey<Long> PROCESSING_TIME_REQUIRED = TimeComponent.TICKS.key("processingTime").optional((Object)100L).alwaysWrite();
    public static final RecipeSchema VAT = new RecipeSchema(VatRecipeJS.class, VatRecipeJS::new, new RecipeKey[]{INGREDIENTS, RESULTS, MACHINES, VAT_TYPES, MIN_SIZE, PROCESSING_TIME_REQUIRED, HEAT_REQUIREMENT}).constructor(new VatRecipeFactory().factory, new RecipeKey[]{INGREDIENTS, RESULTS, MACHINES, VAT_TYPES, MIN_SIZE, PROCESSING_TIME_REQUIRED, HEAT_REQUIREMENT});

    public static class VatRecipeJS
    extends RecipeJS {
        public InputFluid readInputFluid(Object from) {
            if (from instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)from;
                return fluid;
            }
            if (from instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)from;
                return new CreateInputFluid(fluid);
            }
            if (from instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)from;
                return new CreateInputFluid(FluidIngredientHelper.toFluidIngredient(fluid));
            }
            if (from instanceof FluidStack) {
                FluidStack fluid = (FluidStack)from;
                return new CreateInputFluid(FluidIngredient.fromFluidStack((FluidStack)fluid));
            }
            JsonObject json = MapJS.json((Object)from);
            if (json != null) {
                return new CreateInputFluid(FluidIngredient.deserialize((JsonElement)json));
            }
            return CreateInputFluid.EMPTY;
        }

        public JsonElement writeInputFluid(InputFluid value) {
            if (value instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)value;
                return fluid.ingredient().serialize();
            }
            if (value instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)value;
                return fluid.serialize();
            }
            if (value instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)value;
                return FluidIngredientHelper.toFluidIngredient(fluid).serialize();
            }
            return FluidIngredient.EMPTY.serialize();
        }

        public boolean inputItemHasPriority(Object from) {
            if (from instanceof InputItem || from instanceof Ingredient || from instanceof ItemStack) {
                return true;
            }
            InputItem input = this.readInputItem(from);
            Ingredient ingredient = input.ingredient;
            if (ingredient instanceof BlockTagIngredient) {
                BlockTagIngredient blockTag = (BlockTagIngredient)ingredient;
                return !((TagContext)TagContext.INSTANCE.getValue()).isEmpty(blockTag.getTag());
            }
            return !input.isEmpty();
        }

        public boolean inputFluidHasPriority(Object from) {
            return from instanceof InputFluid || FluidIngredient.isFluidIngredient((JsonElement)MapJS.json((Object)from));
        }

        public OutputItem readOutputItem(Object from) {
            JsonObject j;
            if (from instanceof ProcessingOutput) {
                ProcessingOutput output = (ProcessingOutput)from;
                return OutputItem.of((ItemStack)output.getStack(), (double)output.getChance());
            }
            OutputItem outputItem = super.readOutputItem(from);
            if (from instanceof JsonObject && (j = (JsonObject)from).has("chance")) {
                return outputItem.withChance((double)j.get("chance").getAsFloat());
            }
            return outputItem;
        }

        public RecipeJS heated() {
            return this.setValue(HEAT_REQUIREMENT, HeatCondition.HEATED.serialize());
        }

        public RecipeJS superheated() {
            return this.setValue(HEAT_REQUIREMENT, HeatCondition.SUPERHEATED.serialize());
        }

        public RecipeJS machines(String ... machines) {
            return this.setValue(MACHINES, machines);
        }

        public RecipeJS allowedVatTypes(String ... types) {
            return this.setValue(VAT_TYPES, types);
        }

        public RecipeJS allowAllVatTypes() {
            return this.setValue(VAT_TYPES, new String[]{"tfmg:steel_vat", "tfmg:cast_iron_vat", "tfmg:firebrick_lined_vat"});
        }

        public RecipeJS minSize(int size) {
            return this.setValue(MIN_SIZE, size);
        }

        public RecipeJS processingTime(int time) {
            return this.setValue(PROCESSING_TIME_REQUIRED, time);
        }
    }
}

