package dev.anvilcraft.rg.api.event;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public class ServerPlayerChatEvent extends PlayerEvent {
    private final ServerPlayer player;
    private final Component component;
    private final PlayerChatMessage playerchatmessage;
    private final FilteredText text;

    public ServerPlayerChatEvent(ServerPlayer player, Component component, PlayerChatMessage playerchatmessage, FilteredText text) {
        super(player);
        this.player = player;
        this.component = component;
        this.playerchatmessage = playerchatmessage;
        this.text = text;
    }

    @Override
    @NotNull
    public ServerPlayer getEntity() {
        return this.player;
    }

    public Component getComponent() {
        return this.component;
    }

    public PlayerChatMessage getPlayerchatmessage() {
        return this.playerchatmessage;
    }

    public FilteredText getText() {
        return this.text;
    }
}
