/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.anvilcraft.rg.api.server.ServerRGRuleManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="rolling_gate")
public class RollingGate {
    public static final String MODID = "rolling_gate";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final ServerRGRuleManager SERVER_RULE_MANAGER = new ServerRGRuleManager("rolling_gate");

    public RollingGate(@NotNull IEventBus modEventBus, @NotNull ModContainer modContainer) throws ClassNotFoundException {
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(this::registerCommand);
        SERVER_RULE_MANAGER.compileContent();
        if (FMLEnvironment.dist.isClient()) {
            Class<?> clientClass = RollingGate.class.getClassLoader().loadClass("dev.anvilcraft.rg.client.RollingGateClient");
            try {
                Method setup = clientClass.getMethod("onClientSetup", ModContainer.class);
                setup.invoke(null, modContainer);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(@NotNull ServerStartingEvent event) {
        SERVER_RULE_MANAGER.reInit(event.getServer());
    }

    @SubscribeEvent
    public void registerCommand(@NotNull RegisterCommandsEvent event) {
        SERVER_RULE_MANAGER.generateCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), MODID, "rg");
    }

    @NotNull
    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

