/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api;

import com.google.gson.JsonObject;
import dev.anvilcraft.rg.api.RGRuleException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigUtil {
    @NotNull
    public static JsonObject getOrCreateContent(@NotNull Path path) {
        File file = path.toFile();
        try {
            if (!file.exists() || file.isDirectory()) {
                FileUtils.writeStringToFile((File)file, (String)"{}", (Charset)StandardCharsets.UTF_8);
                return new JsonObject();
            }
            String value = FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8);
            return GsonHelper.parse((String)value);
        }
        catch (IOException e) {
            throw new RGRuleException("Failed to read rolling gate config file", e);
        }
    }

    public static void writeContent(@NotNull Path path, @NotNull String content) {
        try {
            FileUtils.writeStringToFile((File)path.toFile(), (String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RGRuleException("Failed to write rolling gate config file", e);
        }
    }
}

