/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class RGCodec<T>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    private final Class<T> clazz;
    private final Function<String, T> decoder;
    private final Function<T, String> encoder;
    private final boolean isBuiltIn;
    public static final RGCodec<String> STRING = new RGCodec<String>(String.class, String::toString, String::toString, true);
    public static final RGCodec<Boolean> BOOLEAN = new RGCodec<Boolean>(Boolean.class, s -> s.equals("true"), Object::toString, true);
    public static final RGCodec<Byte> BYTE = new RGCodec<Byte>(Byte.class, Byte::parseByte, Object::toString, true);
    public static final RGCodec<Short> SHORT = new RGCodec<Short>(Short.class, Short::parseShort, Object::toString, true);
    public static final RGCodec<Integer> INTEGER = new RGCodec<Integer>(Integer.class, Integer::parseInt, Object::toString, true);
    public static final RGCodec<Long> LONG = new RGCodec<Long>(Long.class, Long::parseLong, Object::toString, true);
    public static final RGCodec<Float> FLOAT = new RGCodec<Float>(Float.class, Float::parseFloat, Object::toString, true);
    public static final RGCodec<Double> DOUBLE = new RGCodec<Double>(Double.class, Double::parseDouble, Object::toString, true);

    private RGCodec(Class<T> clazz, Function<String, T> decoder, Function<T, String> encoder, boolean isBuiltIn) {
        this.clazz = clazz;
        this.decoder = decoder;
        this.encoder = encoder;
        this.isBuiltIn = isBuiltIn;
    }

    @NotNull
    public static <T> RGCodec<T> of(Class<T> clazz, Function<String, T> decoder, Function<T, String> encoder) {
        return new RGCodec<T>(clazz, decoder, encoder, false);
    }

    public Class<T> clazz() {
        return this.clazz;
    }

    public T decode(String str) {
        if (str == null) {
            return null;
        }
        return this.decoder.apply(str);
    }

    public String encode(T value) {
        if (value == null) {
            return null;
        }
        return this.encoder.apply(value);
    }

    public String forceEncode(Object value) {
        if (value == null) {
            return null;
        }
        return this.encoder.apply(value);
    }

    public T deserialize(@NotNull JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.decode(json.getAsString());
    }

    @NotNull
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.encode(src));
    }

    @Generated
    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }
}

