/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api;

import org.jetbrains.annotations.NotNull;

public class RGRuleException
extends RuntimeException {
    public RGRuleException(String msg, Object ... args) {
        super(String.format(msg, args));
    }

    public RGRuleException(String msg, Throwable e) {
        super(msg, e);
    }

    @NotNull
    public static RGRuleException illegalAccess(@NotNull String name) {
        return new RGRuleException("Field %s has illegal access", name);
    }

    @NotNull
    public static RGRuleException notStatic(@NotNull String name) {
        return new RGRuleException("Field %s is not static", name);
    }

    @NotNull
    public static RGRuleException notPublic(@NotNull String name) {
        return new RGRuleException("Field %s is not public", name);
    }

    @NotNull
    public static RGRuleException beFinal(@NotNull String name) {
        return new RGRuleException("Field %s can't be final", name);
    }

    @NotNull
    public static RGRuleException createRuleFailed(@NotNull String name) {
        return new RGRuleException("Failed to create rule for field %s", name);
    }

    @NotNull
    public static RGRuleException unsupportedType(@NotNull String name, @NotNull Class<?> type) {
        return new RGRuleException("Field %s has unsupported type, this type can only be boolean, byte, int, long, float, double, String, but got %s", name, type.getTypeName());
    }
}

