/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.anvilcraft.rg.api.ConfigUtil;
import dev.anvilcraft.rg.api.RGEnvironment;
import dev.anvilcraft.rg.api.RGRule;
import dev.anvilcraft.rg.api.RGRuleException;
import dev.anvilcraft.rg.api.RGRuleManager;
import dev.anvilcraft.rg.api.server.RGServerRules;
import dev.anvilcraft.rg.api.server.TranslationUtil;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class ServerRGRuleManager
extends RGRuleManager {
    private final LevelResource worldConfigPath;
    private final Map<RGRule<?>, Object> worldConfig = new HashMap();
    public static final String ANNOTATION_NAME = "L" + RGServerRules.class.getName().replace(".", "/") + ";";

    public void compileContent() throws ClassNotFoundException {
        ProgressMeter meter = StartupNotificationManager.addProgressBar((String)"Load Server Rules", (int)LoadingModList.get().getModFiles().size());
        for (ModFileInfo modFile : LoadingModList.get().getModFiles()) {
            meter.increment();
            ModFileScanData scanData = modFile.getFile().getScanResult();
            for (ModFileScanData.AnnotationData annotation : scanData.getAnnotations()) {
                String modId;
                if (!annotation.annotationType().getDescriptor().equals(ANNOTATION_NAME) || annotation.targetType() != ElementType.TYPE) continue;
                System.out.println(annotation.annotationData().get("languages"));
                List<String> languages = (List<String>)annotation.annotationData().get("languages");
                if (languages == null) {
                    languages = List.of("en_us");
                }
                if ((modId = (String)annotation.annotationData().get("value")) == null) {
                    modId = "rolling_gate";
                }
                String memberName = annotation.memberName();
                Class<?> clazz = Class.forName(memberName);
                this.register(clazz, modId);
                for (String language : languages) {
                    TranslationUtil.loadLanguage(clazz, modId, language);
                }
            }
        }
        StartupNotificationManager.popBar((ProgressMeter)meter);
    }

    public ServerRGRuleManager(String namespace) {
        super(namespace, RGEnvironment.SERVER);
        this.worldConfigPath = new LevelResource("%s.json".formatted(namespace));
    }

    public <T> void setWorldConfig(@NotNull MinecraftServer server, @NotNull RGRule<T> rule, T value) {
        this.worldConfig.put(rule, value);
        ConfigUtil.writeContent(server.getWorldPath(this.worldConfigPath), GSON.toJson(this.getSerializedConfig(this.worldConfig)));
    }

    public void reInit(@NotNull MinecraftServer server) {
        super.reInit();
        this.worldConfig.clear();
        Map<RGRule<?>, Object> world = this.setSaveRules(ConfigUtil.getOrCreateContent(server.getWorldPath(this.worldConfigPath)));
        for (Map.Entry<RGRule<?>, Object> entry : world.entrySet()) {
            if (entry.getValue().equals(this.globalConfig.get(entry.getKey()))) continue;
            this.worldConfig.put(entry.getKey(), entry.getValue());
        }
    }

    public void generateCommand(CommandDispatcher<CommandSourceStack> dispatcher, @NotNull String literal) {
        this.generateCommand(dispatcher, literal, null);
    }

    public void generateCommand(CommandDispatcher<CommandSourceStack> dispatcher, @NotNull String literal, String redirect) {
        new Command(dispatcher, literal, redirect).generateCommand();
    }

    private class Command {
        @NotNull
        CommandDispatcher<CommandSourceStack> dispatcher;
        @NotNull
        String literal;
        String redirect;

        private Command(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, String literal, String redirect) {
            this.dispatcher = dispatcher;
            this.literal = literal;
            this.redirect = redirect;
        }

        private void generateCommand() {
            LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.literal).requires(this::checkPermission)).executes(this::listCommand)).then(Commands.literal((String)"reload").executes(this::reloadCommand))).then(Commands.literal((String)"category").then(Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).suggests(this::suggestRuleCategories).executes(this::categoryCommand)));
            LiteralArgumentBuilder aDefault = Commands.literal((String)"default");
            this.listCommand((LiteralArgumentBuilder<CommandSourceStack>)aDefault, this::defaultRuleCommand, false);
            this.listCommand((LiteralArgumentBuilder<CommandSourceStack>)root, this::setRuleCommand, true);
            root.then((ArgumentBuilder)aDefault);
            LiteralCommandNode register = this.dispatcher.register(root);
            if (this.redirect != null) {
                this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.redirect).requires(this::checkPermission)).executes(this::listCommand)).redirect((CommandNode)register));
            }
        }

        private boolean checkPermission(@NotNull CommandSourceStack source) {
            if (source.hasPermission(2)) {
                return true;
            }
            if (!source.isPlayer()) {
                return false;
            }
            ServerPlayer player = source.getPlayer();
            if (player == null) {
                return false;
            }
            if (!source.getServer().isSingleplayer()) {
                return false;
            }
            return source.getServer().isSingleplayerOwner(player.getGameProfile());
        }

        @NotNull
        private CompletableFuture<Suggestions> suggestRuleCategories(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.suggest((Iterable)ServerRGRuleManager.this.categories, (SuggestionsBuilder)builder);
        }

        private void listCommand(LiteralArgumentBuilder<CommandSourceStack> builder, TriFunction<CommandContext<CommandSourceStack>, RGRule<?>, String, Integer> execute, boolean list) {
            for (Map.Entry entry : ServerRGRuleManager.this.rules.entrySet()) {
                RGRule rgRule = (RGRule)entry.getValue();
                LiteralArgumentBuilder keyNode = Commands.literal((String)rgRule.name());
                if (list) {
                    keyNode.executes(ctx -> this.ruleInfoCommand((CommandContext<CommandSourceStack>)ctx, rgRule));
                }
                keyNode.then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder1) -> SharedSuggestionProvider.suggest((String[])rgRule.allowed(), (SuggestionsBuilder)builder1)).executes(context -> (Integer)execute.apply((Object)context, (Object)rgRule, (Object)StringArgumentType.getString((CommandContext)context, (String)"value"))));
                builder.then((ArgumentBuilder)keyNode);
            }
        }

        private int reloadCommand(@NotNull CommandContext<CommandSourceStack> context) {
            ServerRGRuleManager.this.reInit(((CommandSourceStack)context.getSource()).getServer());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans("rolling_gate.command.reload.success", new Object[0]).withStyle(ChatFormatting.GREEN), false);
            return 1;
        }

        private int listCommand(@NotNull CommandContext<CommandSourceStack> context) {
            Optional container = ModList.get().getModContainerById(ServerRGRuleManager.this.managerNamespace);
            if (container.isPresent()) {
                IModInfo info = ((ModContainer)container.get()).getModInfo();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)info.getDisplayName()).withStyle(ChatFormatting.DARK_PURPLE), false);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> TranslationUtil.trans("rolling_gate.command.root.version", info.getVersion().toString()).withStyle(ChatFormatting.GRAY), false);
                MutableComponent categoriesComponent = Component.empty();
                for (String category : ServerRGRuleManager.this.categories) {
                    MutableComponent categoryComponent = Component.empty();
                    categoryComponent.append("[");
                    categoryComponent.append((Component)TranslationUtil.trans(ServerRGRuleManager.this.getDescriptionCategoryKey(category), new Object[0]));
                    categoryComponent.append("] ");
                    categoryComponent.withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/%s category %s".formatted(this.literal, category))));
                    categoriesComponent.append((Component)categoryComponent);
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> categoriesComponent, false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TranslationUtil.trans("rolling_gate.command.root.not_found", ServerRGRuleManager.this.managerNamespace).withStyle(ChatFormatting.RED));
            return 0;
        }

        private <T> int ruleInfoCommand(@NotNull CommandContext<CommandSourceStack> context, @NotNull RGRule<T> rule) {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            source.sendSuccess(() -> TranslationUtil.trans(rule.getNameTranslationKey(), new Object[0]), false);
            source.sendSuccess(() -> TranslationUtil.trans(rule.getDescriptionTranslationKey(), new Object[0]), false);
            source.sendSuccess(() -> this.getValues(rule), false);
            return 1;
        }

        @NotNull
        private <T> MutableComponent getValues(@NotNull RGRule<T> rule) {
            MutableComponent result = Component.empty();
            String string1 = rule.getValue().toString();
            boolean flag = false;
            for (String string : rule.allowed()) {
                if (string.equals(string1)) {
                    flag = true;
                }
                if (!string.equals(rule.allowed()[0])) {
                    result.append(" ");
                }
                Object worldDefault = ServerRGRuleManager.this.worldConfig.get(rule);
                Object globalDefault = ServerRGRuleManager.this.globalConfig.get(rule);
                T ruleDefault = rule.defaultValue();
                boolean isGlobalDefault = worldDefault != null ? string.equals(rule.codec().encode(worldDefault)) : (globalDefault != null ? string.equals(rule.codec().encode(globalDefault)) : string.equals(rule.codec().encode(ruleDefault)));
                boolean isSelect = string.equals(rule.codec().encode(rule.getValue()));
                MutableComponent component = Component.literal((String)"[%s]".formatted(string));
                Style style = Style.EMPTY;
                style = isSelect ? style.withColor(ChatFormatting.GREEN) : (isGlobalDefault ? style.withColor(ChatFormatting.BLUE) : style.withColor(ChatFormatting.GRAY));
                if (!isSelect) {
                    style = style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)TranslationUtil.trans("rolling_gate.command.rule.select.hover", new Object[0])));
                    style = style.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/%s %s %s".formatted(this.literal, rule.name(), string)));
                }
                result.append((Component)component.withStyle(style));
            }
            if (!flag) {
                result.append(" ").append((Component)Component.literal((String)"[%s]".formatted(string1)).withStyle(ChatFormatting.GREEN));
            }
            return result;
        }

        private int categoryCommand(@NotNull CommandContext<CommandSourceStack> context) {
            String category = StringArgumentType.getString(context, (String)"category");
            MutableComponent categoryComponent = TranslationUtil.trans(ServerRGRuleManager.this.getDescriptionCategoryKey(category), new Object[0]).append(":");
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> categoryComponent, false);
            for (RGRule rule : ServerRGRuleManager.this.rules.values()) {
                if (Arrays.stream(rule.categories()).noneMatch(s -> s.equals(category))) continue;
                MutableComponent component = Component.literal((String)"- ");
                MutableComponent name = TranslationUtil.trans(rule.getNameTranslationKey(), new Object[0]);
                component.append((Component)name);
                MutableComponent hover = TranslationUtil.trans(rule.getDescriptionTranslationKey(), new Object[0]);
                name.withStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
                MutableComponent values = this.getValues(rule);
                component.append(" ").append((Component)values);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
            }
            return 1;
        }

        private <T> int setRuleCommand(@NotNull CommandContext<CommandSourceStack> context, @NotNull RGRule<T> rule, String value) {
            try {
                rule.setFieldValue(value);
                MutableComponent result = TranslationUtil.trans("rolling_gate.command.rule.set", rule.name(), value).withStyle(ChatFormatting.GRAY);
                MutableComponent setDefault = Component.literal((String)"[").append((Component)TranslationUtil.trans("rolling_gate.command.rule.set.default.button", rule.name(), value)).append("]").withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/%s default %s %s".formatted(this.literal, rule.name(), value))));
                result.append(" ").append((Component)setDefault);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> result, false);
                return 1;
            }
            catch (RGRuleException exception) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)exception.getMessage()).withStyle(ChatFormatting.RED));
                return 0;
            }
        }

        private <T> int defaultRuleCommand(@NotNull CommandContext<CommandSourceStack> context, @NotNull RGRule<T> rule, String value) {
            try {
                ServerRGRuleManager.this.setWorldConfig(((CommandSourceStack)context.getSource()).getServer(), rule, rule.codec().decode(value));
                MutableComponent result = TranslationUtil.trans("rolling_gate.command.rule.set.default", rule.name(), value).withStyle(ChatFormatting.GRAY);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> result, false);
                return 1;
            }
            catch (RGRuleException exception) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)exception.getMessage()).withStyle(ChatFormatting.RED));
                return 0;
            }
        }
    }
}

