/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api.server;

import com.google.gson.Gson;
import dev.anvilcraft.rg.RollingGate;
import dev.anvilcraft.rg.RollingGateServerRules;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class TranslationUtil {
    public static final Gson GSON = new Gson();
    public static final Map<String, Map<String, String>> LANGUAGES = new HashMap<String, Map<String, String>>();

    @NotNull
    public static MutableComponent trans(String key, Object ... args) {
        return Component.translatableWithFallback((String)key, (String)LANGUAGES.getOrDefault(RollingGateServerRules.language, LANGUAGES.getOrDefault("en_us", new HashMap())).getOrDefault(key, key), (Object[])args);
    }

    public static void addLanguage(String language, Map<String, String> translations) {
        Map languages = LANGUAGES.getOrDefault(language, new HashMap());
        languages.putAll(translations);
        LANGUAGES.putIfAbsent(language, languages);
    }

    public static void loadLanguage(Class<?> clazz, String namespace, String language) {
        try (InputStream stream = clazz.getResourceAsStream("/assets/%s/lang/%s.json".formatted(namespace, language));){
            if (stream == null) {
                RollingGate.LOGGER.error("Can't find language {}/{}.", (Object)namespace, (Object)language);
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(stream);){
                TranslationUtil.addLanguage("zh_cn", (Map)GSON.fromJson((Reader)reader, Map.class));
                RollingGate.LOGGER.info("Loaded {} language file.", (Object)language);
            }
        }
        catch (IOException e) {
            RollingGate.LOGGER.error("Failed to load %s language file.".formatted(language), (Throwable)e);
        }
    }
}

