/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.tools.chest.menu.control;

import dev.anvilcraft.rg.api.server.TranslationUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class Button {
    private boolean init = false;
    private boolean flag;
    private final ItemStack onItem;
    private final ItemStack offItem;
    CompoundTag compoundTag = new CompoundTag();
    public static final String RG_CLEAR = "RGClear";
    private final List<Runnable> turnOnRunnableList = new ArrayList<Runnable>();
    private final List<Runnable> turnOffRunnableList = new ArrayList<Runnable>();

    public Button() {
        this(true, Items.BARRIER, Items.STRUCTURE_VOID);
    }

    public Button(boolean defaultState) {
        this(defaultState, Items.BARRIER, Items.STRUCTURE_VOID);
    }

    public Button(boolean defaultState, int itemCount) {
        this(defaultState, Items.BARRIER, Items.STRUCTURE_VOID, itemCount);
    }

    public Button(boolean defaultState, int itemCount, Component onText, Component offText) {
        this(defaultState, Items.BARRIER, Items.STRUCTURE_VOID, itemCount, onText, offText);
    }

    public Button(boolean defaultState, Component onText, Component offText) {
        this(defaultState, Items.BARRIER, Items.STRUCTURE_VOID, 1, onText, offText);
    }

    public Button(boolean defaultState, String key) {
        this(defaultState, Items.BARRIER, Items.STRUCTURE_VOID, 1, (Component)TranslationUtil.trans(key, TranslationUtil.trans("rolling_gate.chest_menu.button.on", new Object[0])).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.GREEN)), (Component)TranslationUtil.trans(key, TranslationUtil.trans("rolling_gate.chest_menu.button.off", new Object[0])).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.RED)));
    }

    public Button(boolean defaultState, Item onItem, Item offItem) {
        this(defaultState, onItem, offItem, 1);
    }

    public Button(boolean defaultState, Item onItem, Item offItem, int itemCount) {
        this(defaultState, onItem, offItem, itemCount, (Component)TranslationUtil.trans("rolling_gate.chest_menu.button.on", new Object[0]).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.GREEN)), (Component)TranslationUtil.trans("rolling_gate.chest_menu.button.off", new Object[0]).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.RED)));
    }

    public Button(boolean defaultState, Item onItem, Item offItem, int itemCount, Component onText, Component offText) {
        this.flag = defaultState;
        this.compoundTag.putBoolean(RG_CLEAR, true);
        ItemStack onItemStack = new ItemStack((ItemLike)onItem, itemCount);
        onItemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.compoundTag));
        onItemStack.set(DataComponents.ITEM_NAME, (Object)onText);
        this.onItem = onItemStack;
        ItemStack offItemStack = new ItemStack((ItemLike)offItem, itemCount);
        offItemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.compoundTag.copy()));
        offItemStack.set(DataComponents.ITEM_NAME, (Object)offText);
        this.offItem = offItemStack;
    }

    public Button(boolean defaultState, @NotNull ItemStack onItem, @NotNull ItemStack offItem) {
        this.flag = defaultState;
        this.compoundTag.putBoolean(RG_CLEAR, true);
        ItemStack onItemStack = onItem.copy();
        onItemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.compoundTag.copy()));
        this.onItem = onItemStack;
        ItemStack offItemStack = offItem.copy();
        offItemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.compoundTag.copy()));
        this.offItem = offItemStack;
    }

    public void checkButton(Container container, int slot) {
        ItemStack item;
        ItemStack onItemStack = this.onItem.copy();
        ItemStack offItemStack = this.offItem.copy();
        if (!this.init) {
            this.updateButton(container, slot, onItemStack, offItemStack);
            this.init = true;
        }
        if ((item = container.getItem(slot)).isEmpty()) {
            boolean bl = this.flag = !this.flag;
            if (this.flag) {
                this.runTurnOnFunction();
            } else {
                this.runTurnOffFunction();
            }
        }
        this.updateButton(container, slot, onItemStack, offItemStack);
    }

    public void updateButton(@NotNull Container container, int slot, @NotNull ItemStack onItemStack, ItemStack offItemStack) {
        if (!(container.getItem(slot).is(onItemStack.getItem()) || container.getItem(slot).is(offItemStack.getItem()) || container.getItem(slot).isEmpty())) {
            return;
        }
        if (this.flag) {
            container.setItem(slot, onItemStack);
        } else {
            container.setItem(slot, offItemStack);
        }
    }

    public Button addTurnOnFunction(Runnable Runnable2) {
        this.turnOnRunnableList.add(Runnable2);
        return this;
    }

    public Button addTurnOffFunction(Runnable Runnable2) {
        this.turnOffRunnableList.add(Runnable2);
        return this;
    }

    public void turnOnWithoutFunction() {
        this.flag = true;
    }

    public void turnOffWithoutFunction() {
        this.flag = false;
    }

    public void turnOn() {
        this.flag = true;
        this.runTurnOnFunction();
    }

    public void turnOff() {
        this.flag = false;
        this.runTurnOffFunction();
    }

    public void runTurnOnFunction() {
        for (Runnable turnOnRunnable : this.turnOnRunnableList) {
            turnOnRunnable.run();
        }
    }

    public void runTurnOffFunction() {
        for (Runnable turnOffRunnable : this.turnOffRunnableList) {
            turnOffRunnable.run();
        }
    }

    public boolean isOn() {
        return this.flag;
    }

    @Generated
    public boolean isInit() {
        return this.init;
    }

    @Generated
    public boolean isFlag() {
        return this.flag;
    }

    @Generated
    public ItemStack getOnItem() {
        return this.onItem;
    }

    @Generated
    public ItemStack getOffItem() {
        return this.offItem;
    }

    @Generated
    public CompoundTag getCompoundTag() {
        return this.compoundTag;
    }

    @Generated
    public List<Runnable> getTurnOnRunnableList() {
        return this.turnOnRunnableList;
    }

    @Generated
    public List<Runnable> getTurnOffRunnableList() {
        return this.turnOffRunnableList;
    }
}

