/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.client;

import dev.anvilcraft.rg.api.client.ClientRGRuleManager;
import dev.anvilcraft.rg.api.event.RGValidatorNotPassedEvent;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT}, modid="rolling_gate")
public class RollingGateClient {
    public static final ClientRGRuleManager CLIENT_RULE_MANAGER = new ClientRGRuleManager("rolling_gate");

    public static void onClientSetup(@NotNull ModContainer modContainer) throws ClassNotFoundException {
        CLIENT_RULE_MANAGER.compileContent();
        Map<String, ModConfigSpec> configSpecs = CLIENT_RULE_MANAGER.getSpecMap();
        for (Map.Entry<String, ModConfigSpec> entry : configSpecs.entrySet()) {
            ModConfigSpec value = entry.getValue();
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)value, "%s-client.toml".formatted(entry.getKey()));
        }
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    public static void onLoad(@NotNull ModConfigEvent event) {
        CLIENT_RULE_MANAGER.reInit();
    }

    @SubscribeEvent
    public static <T> void onLoad(@NotNull RGValidatorNotPassedEvent<T> event) {
        CLIENT_RULE_MANAGER.reInit();
        ModConfigSpec.ConfigValue<?> value = CLIENT_RULE_MANAGER.getConfigValueMap().get(event.getRule());
        value.set(event.getOldValue());
    }
}

