/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import dev.anvilcraft.rg.RollingGate;
import dev.anvilcraft.rg.tools.ChatFormattingSerializer;
import dev.anvilcraft.rg.tools.DimTypeSerializer;
import dev.anvilcraft.rg.tools.ResourceLocationSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

public abstract class FilesUtil {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(ResourceLocation.class, (Object)new ResourceLocationSerializer()).registerTypeHierarchyAdapter(ResourceKey.class, (Object)new DimTypeSerializer()).registerTypeHierarchyAdapter(ChatFormatting.class, (Object)new ChatFormattingSerializer()).create();
    protected Gson gson = GSON;
    public MinecraftServer server = null;
    private final String rgJson;

    public FilesUtil(String jsonPrefix) {
        this.rgJson = "%s.rg.json".formatted(jsonPrefix);
    }

    public void init(@NotNull CommandContext<CommandSourceStack> context) {
        MinecraftServer server1 = ((CommandSourceStack)context.getSource()).getServer();
        this.init(server1);
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public void setGson(@NotNull Consumer<GsonBuilder> gson) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(ResourceLocation.class, (Object)new ResourceLocationSerializer()).registerTypeHierarchyAdapter(ResourceKey.class, (Object)new DimTypeSerializer());
        gson.accept(builder);
        this.gson = builder.create();
    }

    protected abstract void createDefault(@NotNull File var1) throws IOException;

    protected abstract void init(@NotNull BufferedReader var1);

    public void init(@NotNull MinecraftServer server1) {
        if (server1 == this.server) {
            return;
        }
        this.server = server1;
        File file = this.server.getWorldPath(LevelResource.ROOT).resolve(this.rgJson).toFile();
        try {
            if (!file.exists()) {
                this.createDefault(file);
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                this.init(bfr);
            }
        }
        catch (IOException e) {
            RollingGate.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void save(@NotNull BufferedWriter var1);

    public void save() {
        if (this.server == null) {
            return;
        }
        File file = this.server.getWorldPath(LevelResource.ROOT).resolve(this.rgJson).toFile();
        try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.save(bw);
        }
        catch (IOException e) {
            RollingGate.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class ObjFile<T>
    extends FilesUtil {
        public T obj;

        public ObjFile(String jsonPrefix, T defaultObj) {
            super(jsonPrefix);
            this.obj = defaultObj;
        }

        @Override
        protected void createDefault(@NotNull File file) throws IOException {
            try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                this.save(bw);
            }
        }

        @Override
        protected void init(@NotNull BufferedReader bfr) {
            this.obj = this.gson.fromJson((Reader)bfr, this.obj.getClass());
        }

        @Override
        protected void save(@NotNull BufferedWriter bw) {
            this.gson.toJson(this.obj, (Appendable)bw);
        }
    }

    public static class MapFile<K extends Comparable<K>, V>
    extends FilesUtil {
        public final Map<K, V> map = new TreeMap();
        private final Function<String, K> keyCodec;
        private final Class<V> vClass;

        public MapFile(String jsonPrefix, Function<String, K> keyCodec, Class<V> vClass) {
            super(jsonPrefix);
            this.keyCodec = keyCodec;
            this.vClass = vClass;
        }

        @Override
        protected void createDefault(@NotNull File file) throws IOException {
            try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                this.save(bw);
            }
        }

        @Override
        protected void init(@NotNull BufferedReader bfr) {
            this.map.clear();
            for (Map.Entry entry : ((JsonObject)this.gson.fromJson((Reader)bfr, JsonObject.class)).entrySet()) {
                this.map.put((Comparable)this.keyCodec.apply((String)entry.getKey()), this.gson.fromJson((JsonElement)entry.getValue(), this.vClass));
            }
        }

        @Override
        protected void save(@NotNull BufferedWriter bw) {
            this.gson.toJson(this.map, (Appendable)bw);
        }
    }
}

