/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.SCMC.config;

import com.google.common.collect.Sets;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.skellybuilds.SCMC.SCMC;
import com.skellybuilds.SCMC.config.ModMenuConfig;
import com.skellybuilds.SCMC.config.option.BooleanConfigOption;
import com.skellybuilds.SCMC.config.option.ConfigOptionStorage;
import com.skellybuilds.SCMC.config.option.IntConfigOption;
import com.skellybuilds.SCMC.config.option.StringSetConfigOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public class ModMenuConfigManager {
    private static File file;
    private static final List<String> ccList;

    public static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "SCMC.js");
    }

    public static boolean fileExistant() {
        return file.exists();
    }

    public static void convertToJS() {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
        try {
            File fileS = new File(FabricLoader.getInstance().getConfigDir().toFile(), "SCMC.json");
            BufferedReader br = new BufferedReader(new FileReader(fileS));
            JsonObject json = new JsonParser().parse((Reader)br).getAsJsonObject();
            String jsConfig = "module.exports = " + gson.toJson((JsonElement)json);
            try (FileWriter writer = new FileWriter(file);){
                writer.write(jsConfig);
            }
            boolean deleted = fileS.delete();
            if (!deleted) {
                SCMC.LOGGER.error("Unable to delete the previous config file");
            }
            ModMenuConfigManager.load();
            ModMenuConfigManager.save();
        }
        catch (IOException e) {
            SCMC.LOGGER.error("Unable to read previous json");
        }
    }

    public static void initializeConfig() {
        ModMenuConfigManager.load();
    }

    private static void load() {
        block31: {
            ModMenuConfigManager.prepareConfigFile();
            try {
                JsonObject json;
                if (!file.exists()) {
                    if (new File(FabricLoader.getInstance().getConfigDir().toFile(), "SCMC.json").exists()) {
                        ModMenuConfigManager.convertToJS();
                        return;
                    }
                    ModMenuConfigManager.save();
                }
                if (!file.exists()) break block31;
                Gson gson = new Gson();
                StringBuilder cJson = new StringBuilder();
                HashMap<String, String> cJK = new HashMap<String, String>();
                String cVersion = "";
                boolean canUpdateConfig = true;
                boolean restoreCsC = false;
                int lNumber = 0;
                try (BufferedReader br = new BufferedReader(new FileReader(file));){
                    String line;
                    boolean inMultiLineComment = false;
                    boolean isCommentButNoKey = false;
                    StringBuilder multiLineComment = new StringBuilder();
                    String mtlC = "";
                    boolean startStuff = false;
                    while ((line = br.readLine()) != null) {
                        ++lNumber;
                        if (line.contains("EXP-RESTORE-CUSTOM-COMMENTS")) {
                            restoreCsC = true;
                            StringBuilder fullD = new StringBuilder();
                            fullD.append(lNumber).append("|");
                            fullD.append(line.indexOf("EXP-RESTORE-CUSTOM-COMMENTS")).append("|");
                            fullD.append("// " + line.substring(line.indexOf("EXP-RESTORE-CUSTOM-COMMENTS")).trim());
                            ccList.add(fullD.toString());
                        }
                        if (line.contains("DISABLE-CONFIG-UPDATES")) {
                            canUpdateConfig = false;
                        }
                        if (line.contains("Config Version:")) {
                            int lD = line.indexOf(": ");
                            if (lD == -1) continue;
                            if (line.contains("*/")) {
                                line = line.substring(0, line.length() - 2);
                                cVersion = line.substring(lD + 2);
                            } else {
                                cVersion = line.substring(lD + 2);
                            }
                        }
                        int comment1LIndex = line.indexOf("//");
                        if (!startStuff) {
                            if (!line.contains("module.exports = ")) continue;
                            line = line.replace("module.exports = ", "");
                            startStuff = true;
                        }
                        if (comment1LIndex != -1 && !inMultiLineComment) {
                            int beforeKS = line.indexOf(":");
                            if (beforeKS == -1) {
                                if (restoreCsC) {
                                    StringBuilder fullD = new StringBuilder();
                                    fullD.append(lNumber).append("|");
                                    fullD.append(comment1LIndex + 2).append("|");
                                    fullD.append("// " + line.substring(comment1LIndex + 2).trim());
                                    ccList.add(fullD.toString());
                                }
                                line = line.substring(0, comment1LIndex);
                                cJson.append(line);
                                continue;
                            }
                            cJK.put(line.substring(0, beforeKS).replace(" ", "").replaceAll("\"", ""), line.substring(comment1LIndex + 2).trim());
                            line = line.substring(0, comment1LIndex);
                        }
                        int multiLineStartIndex = line.indexOf("/*");
                        int multiLineEndIndex = line.indexOf("*/");
                        if (multiLineStartIndex != -1 && !inMultiLineComment) {
                            int beforeKS = line.indexOf(":");
                            if (beforeKS == -1) {
                                isCommentButNoKey = true;
                                line = line.substring(0, multiLineStartIndex);
                                cJson.append(line);
                                continue;
                            }
                            inMultiLineComment = true;
                            mtlC = line.substring(0, beforeKS);
                            multiLineComment.append(line.substring(multiLineStartIndex + 2).trim()).append("\n");
                            line = line.substring(0, multiLineStartIndex);
                            cJson.append(line);
                            continue;
                        }
                        if (inMultiLineComment || isCommentButNoKey) {
                            if (multiLineEndIndex != -1) {
                                if (isCommentButNoKey) {
                                    isCommentButNoKey = false;
                                    if (line.replaceAll(" ", "").length() <= 2) continue;
                                    line = line.substring(multiLineEndIndex + 2);
                                    cJson.append(line);
                                    continue;
                                }
                                inMultiLineComment = false;
                                multiLineComment.append(line.substring(0, multiLineEndIndex).trim());
                                String fixedMLC = multiLineComment.toString();
                                multiLineComment = new StringBuilder();
                                cJK.put(mtlC.replace(" ", "").replaceAll("\"", ""), fixedMLC);
                                if (line.replaceAll(" ", "").length() <= 2) continue;
                                line = line.substring(multiLineEndIndex + 2);
                                cJson.append(line);
                                continue;
                            }
                            if (isCommentButNoKey) continue;
                            multiLineComment.append(line.trim()).append("\n");
                            continue;
                        }
                        cJson.append(line);
                    }
                }
                if (cJson.isEmpty()) {
                    ModMenuConfigManager.save();
                    ModMenuConfigManager.load();
                    return;
                }
                try {
                    json = (JsonObject)gson.fromJson(cJson.toString(), JsonObject.class);
                }
                catch (JsonSyntaxException e) {
                    SCMC.LOGGER.error("Failed to load Config: Parsed JS to JSON file has failed \n More Details: \n {}\n\n^\n| - Error information related to config \n Don't understand, need help or you believe this is a bug?\n Report to https://github.com/SkellyBuilds/scmc/issues", (Object)e.toString());
                    throw new RuntimeException("Config parsing failed! Scroll to the error");
                }
                for (Field field : ModMenuConfig.class.getDeclaredFields()) {
                    JsonPrimitive jsonPrimitive;
                    Object option;
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                    if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                        option = (StringSetConfigOption)field.get(null);
                        JsonArray jsonArray = json.getAsJsonArray(((StringSetConfigOption)option).getKey());
                        if (jsonArray == null) continue;
                        ConfigOptionStorage.setStringSet(((StringSetConfigOption)option).getKey(), Sets.newHashSet((Iterable)jsonArray).stream().map(JsonElement::getAsString).collect(Collectors.toSet()));
                        if (cJK.get(((StringSetConfigOption)option).getKey()) == null) continue;
                        ConfigOptionStorage.setComment(((StringSetConfigOption)option).getKey(), (String)cJK.get(((StringSetConfigOption)option).getKey()));
                        continue;
                    }
                    if (BooleanConfigOption.class.isAssignableFrom(field.getType())) {
                        option = (BooleanConfigOption)field.get(null);
                        jsonPrimitive = json.getAsJsonPrimitive(((BooleanConfigOption)option).getKey());
                        if (jsonPrimitive == null || !jsonPrimitive.isBoolean()) continue;
                        ConfigOptionStorage.setBoolean(((BooleanConfigOption)option).getKey(), jsonPrimitive.getAsBoolean());
                        if (cJK.get(((BooleanConfigOption)option).getKey()) == null) continue;
                        ConfigOptionStorage.setComment(((BooleanConfigOption)option).getKey(), (String)cJK.get(((BooleanConfigOption)option).getKey()));
                        continue;
                    }
                    if (!IntConfigOption.class.isAssignableFrom(field.getType()) || (jsonPrimitive = json.getAsJsonPrimitive(((IntConfigOption)(option = (IntConfigOption)field.get(null))).getKey())) == null || !jsonPrimitive.isNumber()) continue;
                    ConfigOptionStorage.setInt(((IntConfigOption)option).getKey(), jsonPrimitive.getAsInt());
                    if (cJK.get(((IntConfigOption)option).getKey()) == null) continue;
                    ConfigOptionStorage.setComment(((IntConfigOption)option).getKey(), (String)cJK.get(((IntConfigOption)option).getKey()));
                }
                if (!cVersion.isEmpty() && canUpdateConfig && !cVersion.equals(SCMC.MainModContainer.getMetadata().getCustomValue("configV").getAsString())) {
                    ModMenuConfigManager.save();
                }
            }
            catch (IOException | IllegalAccessException e) {
                System.err.println("Couldn't load Mod Menu configuration file; reverting to defaults");
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        ModMenuConfigManager.prepareConfigFile();
        JsonObject config = new JsonObject();
        HashMap<String, String> cJK = new HashMap<String, String>();
        try {
            for (Field field : ModMenuConfig.class.getDeclaredFields()) {
                Object option;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                if (BooleanConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (BooleanConfigOption)field.get(null);
                    config.addProperty(((BooleanConfigOption)option).getKey(), Boolean.valueOf(ConfigOptionStorage.getBoolean(((BooleanConfigOption)option).getKey())));
                    if (((BooleanConfigOption)option).getComment().isEmpty()) continue;
                    cJK.put(((BooleanConfigOption)option).getKey(), ((BooleanConfigOption)option).getComment());
                    continue;
                }
                if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (StringSetConfigOption)field.get(null);
                    JsonArray array = new JsonArray();
                    ConfigOptionStorage.getStringSet(((StringSetConfigOption)option).getKey()).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                    config.add(((StringSetConfigOption)option).getKey(), (JsonElement)array);
                    if (((StringSetConfigOption)option).getComment().isEmpty()) continue;
                    cJK.put(((StringSetConfigOption)option).getKey(), ((StringSetConfigOption)option).getComment());
                    continue;
                }
                if (!IntConfigOption.class.isAssignableFrom(field.getType())) continue;
                option = (IntConfigOption)field.get(null);
                config.addProperty(((IntConfigOption)option).getKey(), (Number)ConfigOptionStorage.getInt(((IntConfigOption)option).getKey()));
                if (((IntConfigOption)option).getComment().isEmpty()) continue;
                cJK.put(((IntConfigOption)option).getKey(), ((IntConfigOption)option).getComment());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String cVersion = "";
        cVersion = SCMC.MainModContainer == null ? "Unable to fetch config version. Report this as an issue at https://github.com/SkellyBuilds/scmc/issues" : SCMC.MainModContainer.getMetadata().getCustomValue("configV").getAsString();
        String headerSt = class_2561.method_43469((String)"scmc.config.intro", (Object[])new Object[]{class_2561.method_43471((String)"scmc.header"), cVersion}).getString();
        Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
        Object jsonString = "/*" + headerSt + "*/\n\n module.exports = " + GSON.toJson((JsonElement)config);
        if (!cJK.isEmpty()) {
            StringBuilder jsonStringC = new StringBuilder();
            jsonStringC.append((String)jsonString);
            String[] finalJsonString = new String[]{jsonString};
            cJK.forEach((Key, Comment) -> {
                if (Comment.contains("\n")) {
                    String fKey = "\"" + Key + "\":";
                    int keyI = finalJsonString[0].indexOf(fKey);
                    if (keyI != -1) {
                        int beforeNL = finalJsonString[0].indexOf(10, keyI);
                        jsonStringC.insert(beforeNL, " /*" + Comment + "*/\n");
                        finalJsonString[0] = jsonStringC.toString();
                    }
                } else {
                    String fKey = "\"" + Key + "\":";
                    int keyI = finalJsonString[0].indexOf(fKey);
                    if (keyI != -1) {
                        int beforeNL = finalJsonString[0].indexOf(10, keyI);
                        jsonStringC.insert(beforeNL, " //" + Comment);
                        finalJsonString[0] = jsonStringC.toString();
                    }
                }
            });
            if (!ccList.isEmpty()) {
                jsonStringC.append("/*Here are your restored comments: \n");
                ccList.forEach(ccData -> {
                    String[] parts = ccData.split("\\|", 3);
                    jsonStringC.append(parts[2] + "\n");
                });
                jsonStringC.append("Since this is an experimental feature & I like having a good sleep schedule. This will do for now! You can put them where you want them to be*/");
            }
            jsonString = jsonStringC.toString();
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write((String)jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Mod Menu configuration file");
            e.printStackTrace();
        }
    }

    public static void saveAsJSON() {
        ModMenuConfigManager.prepareConfigFile();
        JsonObject config = new JsonObject();
        try {
            for (Field field : ModMenuConfig.class.getDeclaredFields()) {
                Object option;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                if (BooleanConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (BooleanConfigOption)field.get(null);
                    config.addProperty(field.getName().toLowerCase(Locale.ROOT), Boolean.valueOf(ConfigOptionStorage.getBoolean(((BooleanConfigOption)option).getKey())));
                    continue;
                }
                if (!StringSetConfigOption.class.isAssignableFrom(field.getType())) continue;
                option = (StringSetConfigOption)field.get(null);
                JsonArray array = new JsonArray();
                ConfigOptionStorage.getStringSet(((StringSetConfigOption)option).getKey()).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                config.add(field.getName().toLowerCase(Locale.ROOT), (JsonElement)array);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
        String jsonString = GSON.toJson((JsonElement)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Mod Menu configuration file");
            e.printStackTrace();
        }
    }

    static {
        ccList = new ArrayList<String>();
    }
}

