/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.SCMC;

import com.skellybuilds.SCMC.config.ModMenuConfig;
import com.skellybuilds.SCMC.config.ModMenuConfigManager;
import com.skellybuilds.SCMC.db.Player;
import com.skellybuilds.SCMC.events.ServerJoinProcessing;
import com.skellybuilds.SCMC.events.ServerLoginProcessing;
import com.skellybuilds.SCMC.server.servercmd;
import com.skellybuilds.SCMC.utils.Locales;
import com.skellybuilds.SCMC.utils.Network;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.SERVER)
public class SCMC
implements ModInitializer {
    public static final String MOD_ID = "SCMC";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SCMC [Server Client Mods Checker]");
    public static Network svr = new Network(27752);
    public Network.ServerCommands cmds = new Network.ServerCommands();
    public static final Map<String, Player> PLAYERS = new HashMap<String, Player>();
    public static final ModContainer MainModContainer = FabricLoader.getInstance().getModContainer("scmc").orElse(null);
    private boolean registerd = false;
    public static MinecraftServer serverD = null;
    private String prevLoc = "";

    public static String getCrash(Exception error, boolean writeCR) {
        class_128 crashReport = new class_128("SCMC has well crashed :( *add dramatic car crash sounds* \n\n", (Throwable)new RuntimeException(error.getMessage()));
        class_129 section = crashReport.method_562("Main suspect");
        section.method_585("Stack trace", error.fillInStackTrace());
        if (writeCR) {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH:mm:ss.SSS");
            File dafile = new File("./crash-reports/SCMC-CRASH-" + now.format(formatter) + ".txt");
            crashReport.method_569(dafile);
            String fullpath = "UNABLE TO GET PATH! SEARCH IN CRASH REPORTS FOLDER";
            try {
                fullpath = dafile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error(e.toString());
            }
            LOGGER.info("Crash report has been saved at .{}! \n If you can't manage to solve it, please report it at https://github.com/SkellyBuilds/scmc/issues", (Object)fullpath);
        }
        return "\n" + crashReport.method_568();
    }

    public static void setCrash(Exception error, MinecraftServer server) {
        server.method_43496((class_2561)class_2561.method_43470((String)"A crash occured from SCMC! Show this to any admins"));
        LOGGER.error(SCMC.getCrash(error, true));
        LOGGER.error("Shutting down the server! Read the crash report for more information!");
        server.method_3747(true);
    }

    public void onInitialize() {
        ModMenuConfigManager.prepareConfigFile();
        if (!ModMenuConfigManager.fileExistant()) {
            LOGGER.info(class_2561.method_43469((String)"scmc.console.welcome", (Object[])new Object[]{class_2561.method_43471((String)"scmc.welcome.header"), MainModContainer.getMetadata().getVersion()}).getString());
            ModMenuConfigManager.initializeConfig();
        } else {
            ModMenuConfigManager.initializeConfig();
            LOGGER.info(class_2561.method_43469((String)"scmc.console.initalize", (Object[])new Object[]{class_2561.method_43471((String)"scmc.header"), MainModContainer.getMetadata().getVersion()}).getString());
        }
        svr.setPort(ModMenuConfig.CPORT.getValue());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (!this.registerd) {
                this.registerd = true;
                serverD = server;
                Thread main = new Thread(() -> {
                    Thread connection = new Thread(() -> {
                        try {
                            LOGGER.info("Initalizing - Connection");
                            this.cmds.addCommand("getall", servercmd::getsvrmds);
                            this.cmds.addCommand("hello", servercmd::helloworld);
                            this.cmds.addCommand("download", servercmd::downloadFile);
                            this.cmds.addCommand("getmod", servercmd::getModName);
                            this.cmds.addCommand("addpmods", servercmd::verifyPlayerMods);
                            this.cmds.addCommand("addploc", servercmd::setPlayerLocale);
                            this.cmds.addCommand("getversion", servercmd::getVersion);
                            svr.init(this.cmds);
                            do {
                                if (SCMC.svr.isOnline || !SCMC.svr.crashed) continue;
                                LOGGER.error("NETWORkING HAS CRASHED!");
                                Exception test = new Exception("Critical exception while running connection thread - " + SCMC.svr.howC + "\n \nIf this crash is related to your port, fix your permissions or configuration to a proper setting!");
                                if (ModMenuConfig.ENABLESCMCCRASHES.getValue()) {
                                    SCMC.setCrash(test, server);
                                    break;
                                }
                                LOGGER.error(SCMC.getCrash(test, false));
                                LOGGER.info("SCMC will not stop the server but it's recommanded to take note!");
                                break;
                            } while (!SCMC.svr.isOnline || SCMC.svr.crashed);
                            if (SCMC.svr.isOnline) {
                                LOGGER.info("Connection - Ready");
                            }
                        }
                        catch (Exception error) {
                            LOGGER.error("Exception occured while initalizing connection thread \n {}", (Object)error.getMessage());
                            try {
                                throw new Exception();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    connection.setUncaughtExceptionHandler((thread, error) -> {
                        if (!SCMC.svr.isOnline && ModMenuConfig.ENABLESCMCCRASHES.getValue()) {
                            SCMC.setCrash((Exception)error, server);
                        } else if (!ModMenuConfig.ENABLESCMCCRASHES.getValue() && !SCMC.svr.isOnline) {
                            LOGGER.error("SCMC connection thread has errored & it could not recover! \n This is the error report \n");
                            LOGGER.error(SCMC.getCrash((Exception)error, false));
                        }
                    });
                    connection.setName("Main Thread - Connection - SCMC");
                    connection.setPriority(1);
                    Thread events = new Thread(() -> {
                        LOGGER.info("Initalizing - Events");
                        if (!ModMenuConfig.CANKICKPLAYERSWITHNOMODS.getValue()) {
                            ServerPlayConnectionEvents.JOIN.register(ServerJoinProcessing::onEventRegister);
                        } else {
                            ServerLoginConnectionEvents.QUERY_START.register(ServerLoginProcessing::onEventRegister);
                        }
                        LOGGER.info("Events - Ready");
                    });
                    events.setUncaughtExceptionHandler((thread, error) -> {
                        if (ModMenuConfig.ENABLESCMCCRASHES.getValue()) {
                            SCMC.setCrash((Exception)error, server);
                        } else {
                            LOGGER.error("An error occured to the events register! This is the following error report: \n");
                            LOGGER.error(SCMC.getCrash((Exception)error, false));
                        }
                    });
                    events.setName("Main Thread - Events - SCMC");
                    connection.setPriority(2);
                    connection.start();
                    events.start();
                    boolean isCOMP = false;
                    do {
                        if (connection.getState() == Thread.State.RUNNABLE || events.getState() == Thread.State.RUNNABLE) continue;
                        LOGGER.info("All sub threads have been completed");
                        isCOMP = true;
                    } while (!isCOMP);
                });
                main.setName("Main Thread - index - SCMC");
                main.start();
            }
        });
        LOGGER.info("Testing locale from bclib: \"{}\"", (Object)Locales.fetchTranslatedText("bclib", "title.link.bclib.discord", "en_us").getString());
        LOGGER.info("Testing locale 2 from bclib: \"{}\"", (Object)Locales.fetchTranslatedText("bclib", "title.bclib.modmenu.main", "ru_ru").getString());
    }
}

