/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.SCMC.config.option;

import com.skellybuilds.SCMC.config.option.ConfigOptionStorage;

public class BooleanConfigOption {
    private final String key;
    private final boolean defaultValue;
    private final String defaultComment;

    public BooleanConfigOption(String key, boolean defaultValue, String enabledKey, String disabledKey, String defaultComment) {
        ConfigOptionStorage.setBoolean(key, defaultValue);
        this.key = key;
        this.defaultValue = defaultValue;
        this.defaultComment = defaultComment;
        ConfigOptionStorage.setComment(key, defaultComment);
    }

    public BooleanConfigOption(String key, boolean defaultValue) {
        this(key, defaultValue, "true", "false", "");
    }

    public BooleanConfigOption(String key, boolean defaultValue, String defaultComment) {
        this(key, defaultValue, "true", "false", defaultComment);
    }

    public String getKey() {
        return this.key;
    }

    public boolean getValue() {
        return ConfigOptionStorage.getBoolean(this.key);
    }

    public String getComment() {
        return ConfigOptionStorage.getComment(this.key);
    }

    public void setComment(String comment) {
        ConfigOptionStorage.setComment(this.key, comment);
    }

    public void setValue(boolean value) {
        ConfigOptionStorage.setBoolean(this.key, value);
    }

    public void toggleValue() {
        ConfigOptionStorage.toggleBoolean(this.key);
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultComment() {
        return this.defaultComment;
    }
}

