/*
 * Decompiled with CFR 0.152.
 */
package com.skellybuilds.SCMC.utils;

import com.skellybuilds.SCMC.StringAr;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.slf4j.LoggerFactory;

public class Network {
    int port;
    ServerThread server;
    public boolean crashed;
    public String howC;
    public boolean isOnline = false;

    public Network(int port) {
        this.port = port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void init(ServerCommands cmds) {
        Thread connectionI = new Thread(() -> {
            try {
                ServerSocket serverSocket = new ServerSocket(this.port);
                try {
                    LoggerFactory.getLogger((String)"SCMC [Server Client Mods Checker]").info("Server is listening on port {}", (Object)this.port);
                    while (true) {
                        Socket socket = serverSocket.accept();
                        this.server = new ServerThread(socket, cmds);
                        this.server.start();
                        this.isOnline = true;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"SCMC [Server Client Mods Checker]").error("Unable to start the server? Is the port free & available?");
                this.howC = "Port " + this.port + " is not available to use as the server could not be started";
                this.crashed = true;
                this.isOnline = false;
                return;
            }
        });
        connectionI.setName("Connection Thread - SCMC");
        connectionI.start();
    }

    public static class ServerCommands {
        private final List<Command> Commands = new ArrayList<Command>();

        public void addCommand(String name, BiConsumer<String[], Socket> callback) {
            this.Commands.add(new Command(name, callback));
        }

        public void removeCommand(String name) {
            this.Commands.removeIf(cmd -> Objects.equals(cmd.name, name));
        }

        public void executeCommand(String name, String[] args, Socket out) {
            for (Command cmd : this.Commands) {
                if (!Objects.equals(cmd.name, name)) continue;
                cmd.execute(args, out);
            }
        }

        public boolean doesExist(String name) {
            for (Command cmd : this.Commands) {
                if (!Objects.equals(cmd.name, name)) continue;
                return true;
            }
            return false;
        }

        private static class Command {
            public String name;
            private final BiConsumer<String[], Socket> callback;

            public Command(String name, BiConsumer<String[], Socket> callback) {
                this.name = name;
                this.callback = callback;
            }

            public void execute(String[] args, Socket out) {
                this.callback.accept(args, out);
            }
        }
    }

    static class ServerThread
    extends Thread {
        private final Socket socket;
        private final ServerCommands cmds;

        public ServerThread(Socket socket, ServerCommands cmds) {
            this.socket = socket;
            this.cmds = cmds;
        }

        @Override
        public void run() {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                 PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);){
                String data = in.readLine();
                if (data == null) {
                    out.println(0);
                    return;
                }
                String[] parts = data.split("\\|", 999);
                if (parts.length < 1) {
                    out.println(520);
                }
                String[] arguments = new String[]{};
                if (parts.length > 1) {
                    arguments = StringAr.removeElement(parts, parts[0]);
                }
                parts[0] = parts[0].replace(" ", "");
                if (this.cmds.doesExist(parts[0])) {
                    this.cmds.executeCommand(parts[0], arguments, this.socket);
                } else {
                    out.println(428);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"SCMC [Server Client Mods Checker]").error("Couldn't read the buffers from socket!");
                e.printStackTrace();
            }
        }
    }
}

