/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.factory.fabric;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.injector.ChannelInjector;
import com.github.retrooper.packetevents.manager.InternalPacketListener;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.github.retrooper.packetevents.manager.server.ServerManager;
import com.github.retrooper.packetevents.netty.NettyManager;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.settings.PacketEventsSettings;
import com.github.retrooper.packetevents.util.LogManager;
import io.github.retrooper.packetevents.factory.fabric.FabricChannelInjector;
import io.github.retrooper.packetevents.factory.fabric.FabricLogger;
import io.github.retrooper.packetevents.factory.fabric.FabricPlayerManager;
import io.github.retrooper.packetevents.factory.fabric.FabricProtocolManager;
import io.github.retrooper.packetevents.factory.fabric.FabricServerManager;
import io.github.retrooper.packetevents.impl.netty.NettyManagerImpl;
import io.github.retrooper.packetevents.impl.netty.manager.player.PlayerManagerAbstract;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricPacketEventsAPI
extends PacketEventsAPI<FabricLoader> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PacketEvents");
    private final String modId;
    private final EnvType environment;
    private final PacketEventsSettings settings;
    private final ProtocolManager protocolManager;
    private final ServerManager serverManager;
    private final PlayerManagerAbstract playerManager;
    private final ChannelInjector injector;
    private final NettyManager nettyManager = new NettyManagerImpl();
    private final LogManager logManager = new FabricLogger(LOGGER);
    private boolean loaded;
    private boolean initialized;
    private boolean terminated;

    public FabricPacketEventsAPI(String modId, EnvType environment) {
        this(modId, environment, new PacketEventsSettings());
    }

    public FabricPacketEventsAPI(String modId, EnvType environment, PacketEventsSettings settings) {
        this.modId = modId;
        this.environment = environment;
        this.settings = settings;
        this.protocolManager = new FabricProtocolManager(environment);
        this.serverManager = this.constructServerManager();
        this.playerManager = this.constructPlayerManager();
        this.injector = new FabricChannelInjector(environment);
    }

    protected ServerManager constructServerManager() {
        return new FabricServerManager();
    }

    protected PlayerManagerAbstract constructPlayerManager() {
        return new FabricPlayerManager();
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        String id = (this.environment.name() + "_" + this.modId).toLowerCase(Locale.ROOT);
        PacketEvents.IDENTIFIER = "pe-" + id;
        PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
        PacketEvents.DECODER_NAME = "pe-decoder-" + id;
        PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
        PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
        WrappedBlockState.ensureLoad();
        this.getEventManager().registerListener((PacketListenerCommon)new InternalPacketListener());
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void init() {
        this.load();
        if (this.initialized) {
            return;
        }
        if (this.settings.shouldCheckForUpdates()) {
            this.getUpdateChecker().handleUpdateCheck();
        }
        PacketType.Play.Client.load();
        PacketType.Play.Server.load();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.initialized) {
            return;
        }
        this.getEventManager().unregisterAllListeners();
        this.initialized = false;
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public FabricLoader getPlugin() {
        return FabricLoader.getInstance();
    }

    public ProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public ChannelInjector getInjector() {
        return this.injector;
    }

    public PacketEventsSettings getSettings() {
        return this.settings;
    }

    public NettyManager getNettyManager() {
        return this.nettyManager;
    }
}

