/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.mixin;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketEvent;
import com.github.retrooper.packetevents.event.UserLoginEvent;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.util.FakeChannelUtil;
import io.github.retrooper.packetevents.PacketEventsMod;
import io.netty.channel.Channel;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class PlayerListMixin {
    @Inject(method={"placeNewPlayer"}, at={@At(value="HEAD")})
    private void preNewPlayerPlace(class_2535 connection, class_3222 player, class_8792 cookie, CallbackInfo ci) {
        if (PacketEventsMod.isOurConnection(connection)) {
            PacketEvents.getAPI().getInjector().setPlayer((Object)connection.field_11651, (Object)player);
        }
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V", shift=At.Shift.AFTER)})
    private void onPlayerLogin(class_2535 connection, class_3222 player, class_8792 cookie, CallbackInfo ci) {
        if (!PacketEventsMod.isOurConnection(connection)) {
            return;
        }
        PacketEventsAPI api = PacketEvents.getAPI();
        User user = api.getPlayerManager().getUser((Object)player);
        if (user == null) {
            Object channelObj = api.getPlayerManager().getChannel((Object)player);
            if (!(FakeChannelUtil.isFakeChannel((Object)channelObj) || api.isTerminated() && !api.getSettings().isKickIfTerminated())) {
                player.field_13987.method_52396((class_2561)class_2561.method_43470((String)"PacketEvents failed to inject into a channel."));
            }
            return;
        }
        api.getEventManager().callEvent((PacketEvent)new UserLoginEvent(user, (Object)player));
    }

    @Inject(method={"respawn"}, at={@At(value="RETURN")})
    private void postRespawn(CallbackInfoReturnable<class_3222> cir) {
        class_3222 player = (class_3222)cir.getReturnValue();
        if (PacketEventsMod.isOurConnection(player.field_13987.field_45013)) {
            Channel channel = player.field_13987.field_45013.field_11651;
            PacketEvents.getAPI().getInjector().setPlayer((Object)channel, (Object)player);
        }
    }
}

