/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.item.trimmaterial;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.item.armormaterial.ArmorMaterial;
import com.github.retrooper.packetevents.protocol.item.armormaterial.ArmorMaterials;
import com.github.retrooper.packetevents.protocol.item.trimmaterial.StaticTrimMaterial;
import com.github.retrooper.packetevents.protocol.item.trimmaterial.TrimMaterials;
import com.github.retrooper.packetevents.protocol.item.type.ItemType;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTFloat;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface TrimMaterial
extends MappedEntity,
CopyableEntity<TrimMaterial>,
DeepComparableEntity {
    public static final float FALLBACK_ITEM_MODEL_INDEX = 0.0f;

    public String getAssetName();

    @ApiStatus.Obsolete
    public ItemType getIngredient();

    @ApiStatus.Obsolete
    public float getItemModelIndex();

    @Nullable
    default public String getArmorMaterialOverride(ArmorMaterial armorMaterial) {
        return this.getOverrideArmorMaterials().get(armorMaterial);
    }

    public Map<ArmorMaterial, String> getOverrideArmorMaterials();

    public Component getDescription();

    public static TrimMaterial read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(TrimMaterials.getRegistry(), TrimMaterial::readDirect);
    }

    public static TrimMaterial readDirect(PacketWrapper<?> wrapper) {
        String assetName = wrapper.readString();
        ItemType ingredient = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? null : wrapper.readMappedEntity(ItemTypes::getById);
        float itemModelIndex = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4) ? 0.0f : wrapper.readFloat();
        Map<ArmorMaterial, String> overrideArmorMaterials = wrapper.readMap(ew -> ew.readMappedEntity(ArmorMaterials::getById), PacketWrapper::readString);
        Component description = wrapper.readComponent();
        return new StaticTrimMaterial(assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public static void write(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeMappedEntityOrDirect(material, TrimMaterial::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeString(material.getAssetName());
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_5)) {
            wrapper.writeMappedEntity(material.getIngredient());
        }
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_4)) {
            wrapper.writeFloat(material.getItemModelIndex());
        }
        wrapper.writeMap(material.getOverrideArmorMaterials(), PacketWrapper::writeMappedEntity, PacketWrapper::writeString);
        wrapper.writeComponent(material.getDescription());
    }

    @Deprecated
    public static TrimMaterial decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return TrimMaterial.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static TrimMaterial decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        Map<ArmorMaterial, String> overrideArmorMaterials;
        NBTCompound compound = (NBTCompound)nbt;
        String assetName = compound.getStringTagValueOrThrow("asset_name");
        ItemType ingredient = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? null : ItemTypes.getByName(compound.getStringTagValueOrThrow("ingredient"));
        float itemModelIndex = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4) ? 0.0f : compound.getNumberTagOrThrow("item_model_index").getAsFloat();
        NBTCompound overrideArmorMaterialsTag = compound.getCompoundTagOrNull("override_armor_materials");
        if (overrideArmorMaterialsTag != null) {
            overrideArmorMaterials = new HashMap();
            for (Map.Entry<String, NBT> entry : overrideArmorMaterialsTag.getTags().entrySet()) {
                ArmorMaterial material = ArmorMaterials.getByName(entry.getKey());
                String override = ((NBTString)entry.getValue()).getValue();
                overrideArmorMaterials.put(material, override);
            }
        } else {
            overrideArmorMaterials = Collections.emptyMap();
        }
        Component description = ((NBTCompound)nbt).getOrThrow("description", wrapper.getSerializers(), wrapper);
        return new StaticTrimMaterial(data, assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    @Deprecated
    public static NBT encode(TrimMaterial material, ClientVersion version) {
        return TrimMaterial.encode(PacketWrapper.createDummyWrapper(version), material);
    }

    public static NBT encode(PacketWrapper<?> wrapper, TrimMaterial material) {
        NBTCompound overrideArmorMaterialsTag;
        if (!material.getOverrideArmorMaterials().isEmpty()) {
            overrideArmorMaterialsTag = new NBTCompound();
            for (Map.Entry<ArmorMaterial, String> entry : material.getOverrideArmorMaterials().entrySet()) {
                String materialName = entry.getKey().getName().toString();
                NBTString overrideTag = new NBTString(entry.getValue());
                overrideArmorMaterialsTag.setTag(materialName, overrideTag);
            }
        } else {
            overrideArmorMaterialsTag = null;
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_name", new NBTString(material.getAssetName()));
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_5)) {
            compound.setTag("ingredient", new NBTString(material.getIngredient().getName().toString()));
        }
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_4)) {
            compound.setTag("item_model_index", new NBTFloat(material.getItemModelIndex()));
        }
        if (overrideArmorMaterialsTag != null) {
            compound.setTag("override_armor_materials", overrideArmorMaterialsTag);
        }
        compound.set("description", material.getDescription(), wrapper.getSerializers(), wrapper);
        return compound;
    }
}

