/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.handlers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.util.EventCreationUtil;
import io.github.retrooper.packetevents.injector.ServerConnectionInitializer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    public User user;
    public ProxiedPlayer player;
    public boolean handledCompression;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> output) throws Exception {
        if (this.tryFixCompressorOrder(ctx, byteBuf)) {
            return;
        }
        ByteBuf transformed = ctx.alloc().buffer().writeBytes(byteBuf);
        try {
            int firstReaderIndex = transformed.readerIndex();
            PacketReceiveEvent packetReceiveEvent = EventCreationUtil.createReceiveEvent(ctx.channel(), this.user, this.player, transformed, false);
            int readerIndex = transformed.readerIndex();
            PacketEvents.getAPI().getEventManager().callEvent(packetReceiveEvent, () -> transformed.readerIndex(readerIndex));
            if (!packetReceiveEvent.isCancelled()) {
                if (packetReceiveEvent.getLastUsedWrapper() != null) {
                    ByteBufHelper.clear(packetReceiveEvent.getByteBuf());
                    packetReceiveEvent.getLastUsedWrapper().writeVarInt(packetReceiveEvent.getPacketId());
                    packetReceiveEvent.getLastUsedWrapper().write();
                } else {
                    transformed.readerIndex(firstReaderIndex);
                }
                output.add(transformed.retain());
            }
            if (packetReceiveEvent.hasPostTasks()) {
                for (Runnable task : packetReceiveEvent.getPostTasks()) {
                    task.run();
                }
            }
        }
        finally {
            transformed.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        if (byteBuf.isReadable()) {
            this.read(ctx, byteBuf, out);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        ServerConnectionInitializer.destroyChannel(ctx.channel());
        super.channelInactive(ctx);
    }

    private boolean tryFixCompressorOrder(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.handledCompression) {
            return false;
        }
        ChannelPipeline pipe = ctx.pipeline();
        List pipeNames = pipe.names();
        int decompressorIndex = pipeNames.indexOf("decompress");
        if (decompressorIndex == -1) {
            return false;
        }
        this.handledCompression = true;
        if (!pipeNames.contains("frame-prepender-compress")) {
            return false;
        }
        if (decompressorIndex <= pipeNames.indexOf(PacketEvents.DECODER_NAME)) {
            return false;
        }
        PacketEventsDecoder decoder = (PacketEventsDecoder)pipe.remove(PacketEvents.DECODER_NAME);
        pipe.addAfter("decompress", PacketEvents.DECODER_NAME, (ChannelHandler)decoder);
        ChannelHandlerContext frameDecoderCtx = pipe.context("frame-decoder");
        frameDecoderCtx.fireChannelRead((Object)buffer.retain());
        return true;
    }
}

