/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.handlers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.util.EventCreationUtil;
import io.github.retrooper.packetevents.handlers.PacketEventsDecoder;
import io.github.retrooper.packetevents.injector.CustomPipelineUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.md_5.bungee.api.connection.ProxiedPlayer;

@ChannelHandler.Sharable
public class PacketEventsEncoder
extends ChannelOutboundHandlerAdapter {
    public ProxiedPlayer player;
    public User user;
    public boolean handledCompression;

    public PacketEventsEncoder(User user) {
        this.user = user;
    }

    public void read(ChannelHandlerContext originalCtx, ByteBuf buffer, ChannelPromise promise) {
        ChannelHandlerContext ctx = this.tryFixCompressorOrder(originalCtx, buffer);
        int firstReaderIndex = buffer.readerIndex();
        PacketSendEvent packetSendEvent = EventCreationUtil.createSendEvent(ctx.channel(), this.user, this.player, buffer, false);
        int readerIndex = buffer.readerIndex();
        PacketEvents.getAPI().getEventManager().callEvent(packetSendEvent, () -> buffer.readerIndex(readerIndex));
        if (!packetSendEvent.isCancelled()) {
            if (packetSendEvent.getLastUsedWrapper() != null) {
                ByteBuf newBuffer;
                if (buffer.maxCapacity() != Integer.MAX_VALUE) {
                    newBuffer = buffer.alloc().buffer(buffer.capacity());
                    packetSendEvent.setByteBuf(newBuffer);
                    packetSendEvent.getLastUsedWrapper().buffer = newBuffer;
                    buffer.release();
                } else {
                    newBuffer = buffer.clear();
                }
                packetSendEvent.getLastUsedWrapper().writeVarInt(packetSendEvent.getPacketId());
                packetSendEvent.getLastUsedWrapper().write();
                ctx.write((Object)newBuffer, promise);
            } else {
                buffer.readerIndex(firstReaderIndex);
                ctx.write((Object)buffer, promise);
            }
        } else {
            ReferenceCountUtil.release((Object)packetSendEvent.getByteBuf());
        }
        if (packetSendEvent.hasPostTasks()) {
            for (Runnable task : packetSendEvent.getPostTasks()) {
                task.run();
            }
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            super.write(ctx, msg, promise);
            return;
        }
        ByteBuf buf = (ByteBuf)msg;
        if (!buf.isReadable()) {
            buf.release();
        } else {
            this.read(ctx, buf, promise);
        }
    }

    private ChannelHandlerContext tryFixCompressorOrder(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.handledCompression) {
            return ctx;
        }
        ChannelPipeline pipe = ctx.pipeline();
        List pipeNames = pipe.names();
        if (pipeNames.contains("frame-prepender-compress")) {
            this.handledCompression = true;
            return ctx;
        }
        int compressorIndex = pipeNames.indexOf("compress");
        if (compressorIndex == -1) {
            return ctx;
        }
        this.handledCompression = true;
        if (compressorIndex <= pipeNames.indexOf(PacketEvents.ENCODER_NAME)) {
            return ctx;
        }
        PacketEventsDecoder decoder = (PacketEventsDecoder)pipe.remove(PacketEvents.DECODER_NAME);
        PacketEventsEncoder encoder = (PacketEventsEncoder)pipe.remove(PacketEvents.ENCODER_NAME);
        pipe.addAfter("decompress", PacketEvents.DECODER_NAME, (ChannelHandler)decoder);
        pipe.addAfter("compress", PacketEvents.ENCODER_NAME, (ChannelHandler)encoder);
        this.decompress(pipe, buffer);
        return pipe.context(PacketEvents.ENCODER_NAME);
    }

    private void decompress(ChannelPipeline pipe, ByteBuf buffer) {
        ChannelHandler decompressor = pipe.get("decompress");
        ChannelHandlerContext decompressorCtx = pipe.context("decompress");
        ByteBuf decompressed = null;
        try {
            decompressed = (ByteBuf)CustomPipelineUtil.callPacketDecodeByteBuf(decompressor, decompressorCtx, buffer).get(0);
            if (buffer != decompressed) {
                buffer.clear().writeBytes(decompressed);
            }
        }
        catch (InvocationTargetException exception) {
            try {
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release(decompressed);
                throw throwable;
            }
        }
        ReferenceCountUtil.release((Object)decompressed);
    }
}

