/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.injector;

import com.github.retrooper.packetevents.protocol.ConnectionState;
import io.github.retrooper.packetevents.injector.ServerConnectionInitializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public class BungeeChannelInitializer
extends ChannelInitializer<Channel> {
    private static final Method INIT_CHANNEL_METHOD;
    private final Object oldInitializer;

    public BungeeChannelInitializer(Object oldInitializer) {
        this.oldInitializer = oldInitializer;
    }

    protected void initChannel(@NotNull Channel channel) throws Exception {
        if (!channel.isActive()) {
            return;
        }
        INIT_CHANNEL_METHOD.invoke(this.oldInitializer, channel);
        if (channel.pipeline().get("packet-decoder") == null) {
            return;
        }
        if (channel.pipeline().get("packet-encoder") == null) {
            return;
        }
        ServerConnectionInitializer.initChannel(channel, ConnectionState.HANDSHAKING);
    }

    static {
        try {
            INIT_CHANNEL_METHOD = ChannelInitializer.class.getDeclaredMethod("initChannel", Channel.class);
            INIT_CHANNEL_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

