/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.processor;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.UserLoginEvent;
import com.github.retrooper.packetevents.protocol.player.User;
import java.lang.reflect.Field;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class InternalBungeeProcessor
implements Listener {
    private static final Field CHANNEL_WRAPPER;
    private static final Field CHANNEL;

    @EventHandler
    public void onPostLogin(PostLoginEvent event) {
        Object channel;
        ProxiedPlayer player = event.getPlayer();
        try {
            channel = CHANNEL.get(CHANNEL_WRAPPER.get(player));
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Error looking up channel from " + player, exception);
        }
        PacketEvents.getAPI().getProtocolManager().setChannel(player.getUniqueId(), channel);
        PacketEvents.getAPI().getInjector().setPlayer(channel, player);
        User user = PacketEvents.getAPI().getPlayerManager().getUser(event.getPlayer());
        if (user == null) {
            return;
        }
        UserLoginEvent loginEvent = new UserLoginEvent(user, player);
        PacketEvents.getAPI().getEventManager().callEvent(loginEvent);
    }

    static {
        try {
            CHANNEL_WRAPPER = Class.forName("net.md_5.bungee.UserConnection").getDeclaredField("ch");
            CHANNEL_WRAPPER.setAccessible(true);
            CHANNEL = Class.forName("net.md_5.bungee.netty.ChannelWrapper").getDeclaredField("ch");
            CHANNEL.setAccessible(true);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Error looking up channel fields", exception);
        }
    }
}

