/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.chunk.reader.impl;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.github.retrooper.packetevents.protocol.world.chunk.impl.v_1_18.Chunk_v1_18;
import com.github.retrooper.packetevents.protocol.world.chunk.reader.ChunkReader;
import com.github.retrooper.packetevents.protocol.world.chunk.storage.BaseStorage;
import com.github.retrooper.packetevents.protocol.world.dimension.DimensionType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.BitSet;
import org.jetbrains.annotations.ApiStatus;

public class ChunkReader_v1_18
implements ChunkReader {
    @ApiStatus.Internal
    public static int getMojangZeroByteSuffixLength(BaseChunk[] chunks) {
        int mojangPleaseFixThisZeroByteSuffixLength = 0;
        for (BaseChunk chunk : chunks) {
            BaseStorage chunkStorage = ((Chunk_v1_18)chunk).getChunkData().storage;
            int chunkStorageLen = ByteBufHelper.getByteSize(chunkStorage != null ? chunkStorage.getData().length : 0);
            BaseStorage biomeStorage = ((Chunk_v1_18)chunk).getBiomeData().storage;
            int biomeStorageLen = ByteBufHelper.getByteSize(biomeStorage != null ? biomeStorage.getData().length : 0);
            mojangPleaseFixThisZeroByteSuffixLength += chunkStorageLen + biomeStorageLen;
        }
        return mojangPleaseFixThisZeroByteSuffixLength;
    }

    @Override
    public BaseChunk[] read(DimensionType dimensionType, BitSet chunkMask, BitSet secondaryChunkMask, boolean fullChunk, boolean hasBlockLight, boolean hasSkyLight, int chunkSize, int arrayLength, PacketWrapper<?> wrapper) {
        int ri = ByteBufHelper.readerIndex(wrapper.buffer);
        BaseChunk[] chunks = new BaseChunk[chunkSize];
        for (int i = 0; i < chunkSize; ++i) {
            chunks[i] = Chunk_v1_18.read(wrapper);
        }
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_6) && wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) && ByteBufHelper.readerIndex(wrapper.buffer) - ri < arrayLength) {
            ByteBufHelper.skipBytes(wrapper.buffer, ChunkReader_v1_18.getMojangZeroByteSuffixLength(chunks));
        }
        return chunks;
    }
}

