/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.chunk.reader.impl;

import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.world.chunk.BaseChunk;
import com.github.retrooper.packetevents.protocol.world.chunk.ByteArray3d;
import com.github.retrooper.packetevents.protocol.world.chunk.NetworkChunkData;
import com.github.retrooper.packetevents.protocol.world.chunk.NibbleArray3d;
import com.github.retrooper.packetevents.protocol.world.chunk.impl.v1_7.Chunk_v1_7;
import com.github.retrooper.packetevents.protocol.world.chunk.reader.ChunkReader;
import com.github.retrooper.packetevents.protocol.world.dimension.DimensionType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.BitSet;

public class ChunkReader_v1_7
implements ChunkReader {
    @Override
    public BaseChunk[] read(DimensionType dimensionType, BitSet chunkMask, BitSet secondaryChunkMask, boolean fullChunk, boolean hasBlockLight, boolean hasSkyLight, int chunkSize, int arrayLength, PacketWrapper<?> wrapper) {
        byte[] data = wrapper.readByteArrayOfSize(arrayLength);
        BaseChunk[] chunks = new Chunk_v1_7[16];
        int pos = 0;
        int expected = 0;
        boolean sky = false;
        for (int pass = 0; pass < 5; ++pass) {
            for (int ind = 0; ind < 16; ++ind) {
                if (!chunkMask.get(ind)) continue;
                if (pass == 0) {
                    expected += 10240;
                    if (secondaryChunkMask.get(ind)) {
                        expected += 2048;
                    }
                }
                if (pass == 1) {
                    chunks[ind] = new Chunk_v1_7(sky, secondaryChunkMask.get(ind));
                    ByteArray3d blocks = ((Chunk_v1_7)chunks[ind]).getBlocks();
                    System.arraycopy(data, pos, blocks.getData(), 0, blocks.getData().length);
                    pos += blocks.getData().length;
                }
                if (pass == 2) {
                    NibbleArray3d metadata = ((Chunk_v1_7)chunks[ind]).getMetadata();
                    System.arraycopy(data, pos, metadata.getData(), 0, metadata.getData().length);
                    pos += metadata.getData().length;
                }
                if (pass == 3) {
                    NibbleArray3d blocklight = ((Chunk_v1_7)chunks[ind]).getBlockLight();
                    System.arraycopy(data, pos, blocklight.getData(), 0, blocklight.getData().length);
                    pos += blocklight.getData().length;
                }
                if (pass != 4 || !sky) continue;
                NibbleArray3d skylight = ((Chunk_v1_7)chunks[ind]).getSkyLight();
                System.arraycopy(data, pos, skylight.getData(), 0, skylight.getData().length);
                pos += skylight.getData().length;
            }
            if (pass != 0 || data.length < expected) continue;
            sky = true;
        }
        int ri = ByteBufHelper.readerIndex(wrapper.buffer);
        ByteBufHelper.readerIndex(wrapper.buffer, ri - (arrayLength - pos));
        return chunks;
    }

    public static NetworkChunkData chunksToData(Chunk_v1_7[] chunks, byte[] biomes) {
        int chunkMask = 0;
        int extendedChunkMask = 0;
        boolean fullChunk = biomes != null;
        boolean sky = false;
        int length = fullChunk ? biomes.length : 0;
        byte[] data = null;
        int pos = 0;
        for (int pass = 0; pass < 6; ++pass) {
            for (int ind = 0; ind < chunks.length; ++ind) {
                Chunk_v1_7 chunk = chunks[ind];
                if (chunk == null || fullChunk && chunk.isEmpty()) continue;
                if (pass == 0) {
                    chunkMask |= 1 << ind;
                    if (chunk.getExtendedBlocks() != null) {
                        extendedChunkMask |= 1 << ind;
                    }
                    length += chunk.getBlocks().getData().length;
                    length += chunk.getMetadata().getData().length;
                    length += chunk.getBlockLight().getData().length;
                    if (chunk.getSkyLight() != null) {
                        length += chunk.getSkyLight().getData().length;
                    }
                    if (chunk.getExtendedBlocks() != null) {
                        length += chunk.getExtendedBlocks().getData().length;
                    }
                }
                if (pass == 1) {
                    ByteArray3d blocks = chunk.getBlocks();
                    System.arraycopy(blocks.getData(), 0, data, pos, blocks.getData().length);
                    pos += blocks.getData().length;
                }
                if (pass == 2) {
                    byte[] meta = chunk.getMetadata().getData();
                    System.arraycopy(meta, 0, data, pos, meta.length);
                    pos += meta.length;
                }
                if (pass == 3) {
                    byte[] blocklight = chunk.getBlockLight().getData();
                    System.arraycopy(blocklight, 0, data, pos, blocklight.length);
                    pos += blocklight.length;
                }
                if (pass == 4 && chunk.getSkyLight() != null) {
                    byte[] skylight = chunk.getSkyLight().getData();
                    System.arraycopy(skylight, 0, data, pos, skylight.length);
                    pos += skylight.length;
                    sky = true;
                }
                if (pass != 5 || chunk.getExtendedBlocks() == null) continue;
                byte[] extended = chunk.getExtendedBlocks().getData();
                System.arraycopy(extended, 0, data, pos, extended.length);
                pos += extended.length;
            }
            if (pass != 0) continue;
            data = new byte[length];
        }
        if (fullChunk) {
            System.arraycopy(biomes, 0, data, pos, biomes.length);
            pos += biomes.length;
        }
        return new NetworkChunkData(chunkMask, extendedChunkMask, fullChunk, sky, data);
    }
}

