/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.dimension;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.world.dimension.DimensionType;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.mappings.IRegistry;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerJoinGame;
import org.jetbrains.annotations.Nullable;

public interface DimensionTypeRef {
    public DimensionType resolve(IRegistry<DimensionType> var1, ClientVersion var2);

    default public ResourceLocation getName() {
        throw new UnsupportedOperationException();
    }

    default public int getId() {
        throw new UnsupportedOperationException();
    }

    default public NBT getData() {
        throw new UnsupportedOperationException();
    }

    public static DimensionTypeRef read(PacketWrapper<?> wrapper) {
        ServerVersion version = wrapper.getServerVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            return new IdRef(wrapper.readVarInt());
        }
        boolean v1162 = version.isNewerThanOrEquals(ServerVersion.V_1_16_2);
        if (version.isNewerThanOrEquals(ServerVersion.V_1_19) || !v1162 && version.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            return new NameRef(wrapper.readIdentifier());
        }
        if (v1162) {
            return new DataRef(wrapper.readNBTRaw());
        }
        return new IdRef(wrapper instanceof WrapperPlayServerJoinGame && version.isOlderThan(ServerVersion.V_1_9_2) ? (int)wrapper.readByte() : wrapper.readInt());
    }

    public static void write(PacketWrapper<?> wrapper, DimensionTypeRef ref) {
        ServerVersion version = wrapper.getServerVersion();
        if (version.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeVarInt(ref.getId());
            return;
        }
        boolean v1162 = version.isNewerThanOrEquals(ServerVersion.V_1_16_2);
        if (version.isNewerThanOrEquals(ServerVersion.V_1_19) || !v1162 && version.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            wrapper.writeIdentifier(ref.getName());
        } else if (v1162) {
            wrapper.writeNBTRaw(ref.getData());
        } else if (wrapper instanceof WrapperPlayServerJoinGame && version.isOlderThan(ServerVersion.V_1_9_2)) {
            wrapper.writeByte(ref.getId());
        } else {
            wrapper.writeInt(ref.getId());
        }
    }

    public static final class IdRef
    implements DimensionTypeRef {
        private final int id;

        public IdRef(int id) {
            this.id = id;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, ClientVersion version) {
            return registry.getById(version, this.id);
        }

        @Override
        public int getId() {
            return this.id;
        }
    }

    public static final class NameRef
    implements DimensionTypeRef {
        private final ResourceLocation name;

        public NameRef(ResourceLocation name) {
            this.name = name;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, ClientVersion version) {
            return registry.getByName(this.name);
        }

        @Override
        public ResourceLocation getName() {
            return this.name;
        }
    }

    public static final class DataRef
    implements DimensionTypeRef {
        private final NBT data;

        public DataRef(NBT data) {
            this.data = data;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, ClientVersion version) {
            DimensionType dimensionType;
            ResourceLocation name = this.getNullableName();
            if (name != null && (dimensionType = registry.getByName(name)) != null) {
                return dimensionType;
            }
            return DimensionType.decode(this.data, version, null);
        }

        @Nullable
        public ResourceLocation getNullableName() {
            String effectsName;
            if (this.data instanceof NBTCompound && (effectsName = ((NBTCompound)this.data).getStringTagValueOrNull("effects")) != null) {
                return new ResourceLocation(effectsName);
            }
            return null;
        }

        @Override
        public ResourceLocation getName() {
            ResourceLocation name = this.getNullableName();
            return name != null ? name : DimensionTypeRef.super.getName();
        }

        @Override
        public NBT getData() {
            return this.data;
        }
    }

    public static final class DirectRef
    implements DimensionTypeRef {
        private final DimensionType dimensionType;
        private final ClientVersion version;

        public DirectRef(DimensionType dimensionType, ClientVersion version) {
            this.dimensionType = dimensionType;
            this.version = version;
        }

        @Override
        public DimensionType resolve(IRegistry<DimensionType> registry, ClientVersion version) {
            if (this.version != version) {
                throw new IllegalArgumentException("Expected version " + (Object)((Object)this.version) + ", received " + (Object)((Object)version) + " for direct dimension type ref " + this.dimensionType);
            }
            return this.dimensionType;
        }

        @Override
        public ResourceLocation getName() {
            return this.dimensionType.getName();
        }

        @Override
        public int getId() {
            return this.dimensionType.getId(this.version);
        }

        @Override
        public NBT getData() {
            return DimensionType.encode(this.dimensionType, this.version);
        }

        public DimensionType getDimensionType() {
            return this.dimensionType;
        }

        public ClientVersion getVersion() {
            return this.version;
        }
    }
}

