/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.adventure.serializer.json.legacyimpl;

import io.github.retrooper.packetevents.adventure.serializer.gson.BackwardCompatUtil;
import io.github.retrooper.packetevents.adventure.serializer.json.LegacyHoverEventSerializer;
import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.util.Codec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NBTLegacyHoverEventSerializerImpl
implements LegacyHoverEventSerializer {
    static final NBTLegacyHoverEventSerializerImpl INSTANCE = new NBTLegacyHoverEventSerializerImpl();
    private static final TagStringIO SNBT_IO = TagStringIO.get();
    private static final Codec<CompoundBinaryTag, String, IOException, IOException> SNBT_CODEC = BackwardCompatUtil.createCodec(arg_0 -> ((TagStringIO)SNBT_IO).asCompound(arg_0), arg_0 -> ((TagStringIO)SNBT_IO).asString(arg_0));
    static final String ITEM_TYPE = "id";
    static final String ITEM_COUNT = "Count";
    static final String ITEM_TAG = "tag";
    static final String ENTITY_NAME = "name";
    static final String ENTITY_TYPE = "type";
    static final String ENTITY_ID = "id";

    private NBTLegacyHoverEventSerializerImpl() {
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowItem deserializeShowItem(@NotNull Component input) throws IOException {
        NBTLegacyHoverEventSerializerImpl.assertTextComponent(input);
        CompoundBinaryTag contents = (CompoundBinaryTag)SNBT_CODEC.decode((Object)((TextComponent)input).content());
        CompoundBinaryTag tag = contents.getCompound(ITEM_TAG);
        return BackwardCompatUtil.createShowItem(Key.key((String)contents.getString("id")), contents.getByte(ITEM_COUNT, (byte)1), tag == CompoundBinaryTag.empty() ? null : BinaryTagHolder.encode((Object)tag, SNBT_CODEC));
    }

    @Override
    @NotNull
    public Component serializeShowItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowItem input) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.item().asString())).putByte(ITEM_COUNT, (byte)input.count());
        @Nullable BinaryTagHolder nbt = input.nbt();
        if (nbt != null) {
            builder.put(ITEM_TAG, (BinaryTag)nbt.get(SNBT_CODEC));
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)builder.build())));
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowEntity deserializeShowEntity(@NotNull Component input, Codec.Decoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        NBTLegacyHoverEventSerializerImpl.assertTextComponent(input);
        CompoundBinaryTag contents = (CompoundBinaryTag)SNBT_CODEC.decode((Object)((TextComponent)input).content());
        return BackwardCompatUtil.createShowEntity(Key.key((String)contents.getString(ENTITY_TYPE)), UUID.fromString(contents.getString("id")), (Component)componentCodec.decode((Object)contents.getString(ENTITY_NAME)));
    }

    @Override
    @NotNull
    public Component serializeShowEntity(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HoverEvent.ShowEntity input, Codec.Encoder<Component, String, ? extends RuntimeException> componentCodec) throws IOException {
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", input.id().toString())).putString(ENTITY_TYPE, input.type().asString());
        @Nullable Component name = input.name();
        if (name != null) {
            builder.putString(ENTITY_NAME, (String)componentCodec.encode((Object)name));
        }
        return Component.text((String)((String)SNBT_CODEC.encode((Object)builder.build())));
    }

    private static void assertTextComponent(Component component) {
        if (!(component instanceof TextComponent) || !component.children().isEmpty()) {
            throw new IllegalArgumentException("Legacy events must be single Component instances");
        }
    }
}

