/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.injector;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.UserConnectEvent;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.util.PacketEventsImplHelper;
import io.github.retrooper.packetevents.handlers.PacketEventsDecoder;
import io.github.retrooper.packetevents.handlers.PacketEventsEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;

public class ServerConnectionInitializer {
    public static void addChannelHandlers(Channel channel, PacketEventsDecoder decoder, PacketEventsEncoder encoder) {
        channel.pipeline().addBefore("minecraft-decoder", PacketEvents.DECODER_NAME, (ChannelHandler)decoder);
        channel.pipeline().addBefore("minecraft-encoder", PacketEvents.ENCODER_NAME, (ChannelHandler)encoder);
    }

    public static void initChannel(Channel channel, ConnectionState state) {
        User user = new User(channel, state, null, new UserProfile(null, null));
        UserConnectEvent connectEvent = new UserConnectEvent(user);
        PacketEvents.getAPI().getEventManager().callEvent(connectEvent);
        if (connectEvent.isCancelled()) {
            channel.unsafe().closeForcibly();
            return;
        }
        PacketEventsDecoder decoder = new PacketEventsDecoder(user);
        PacketEventsEncoder encoder = new PacketEventsEncoder(user);
        ServerConnectionInitializer.addChannelHandlers(channel, decoder, encoder);
        channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> PacketEventsImplHelper.handleDisconnection(user.getChannel(), user.getUUID())));
        PacketEvents.getAPI().getProtocolManager().setUser(channel, user);
    }

    public static void destroyChannel(Channel channel) {
        channel.pipeline().remove(PacketEvents.DECODER_NAME);
        channel.pipeline().remove(PacketEvents.ENCODER_NAME);
    }

    public static void reloadChannel(Channel channel) {
        PacketEventsDecoder decoder = (PacketEventsDecoder)channel.pipeline().remove(PacketEvents.DECODER_NAME);
        PacketEventsEncoder encoder = (PacketEventsEncoder)channel.pipeline().remove(PacketEvents.ENCODER_NAME);
        ServerConnectionInitializer.addChannelHandlers(channel, decoder, encoder);
    }
}

