/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.factory.fabric;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.injector.ChannelInjector;
import com.github.retrooper.packetevents.protocol.PacketSide;
import com.github.retrooper.packetevents.protocol.player.User;
import io.github.retrooper.packetevents.handler.PacketDecoder;
import io.github.retrooper.packetevents.handler.PacketEncoder;
import io.netty.channel.Channel;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;

public class FabricChannelInjector
implements ChannelInjector {
    private final PacketSide packetSide;

    public FabricChannelInjector(EnvType environment) {
        this.packetSide = switch (environment) {
            default -> throw new IncompatibleClassChangeError();
            case EnvType.SERVER -> PacketSide.SERVER;
            case EnvType.CLIENT -> PacketSide.CLIENT;
        };
    }

    public void inject() {
    }

    public void uninject() {
    }

    public boolean isPlayerSet(Object ch) {
        if (ch == null) {
            return false;
        }
        Channel channel = (Channel)ch;
        PacketEncoder encoder = (PacketEncoder)channel.pipeline().get(PacketEvents.ENCODER_NAME);
        if (encoder.player != null) {
            return true;
        }
        PacketDecoder decoder = (PacketDecoder)channel.pipeline().get(PacketEvents.DECODER_NAME);
        return decoder.player != null;
    }

    public void updateUser(Object channel, User user) {
        if (!PacketEvents.getAPI().getProtocolManager().hasChannel(channel)) {
            return;
        }
        Channel ch = (Channel)channel;
        ((PacketDecoder)ch.pipeline().get((String)PacketEvents.DECODER_NAME)).user = user;
        ((PacketEncoder)ch.pipeline().get((String)PacketEvents.ENCODER_NAME)).user = user;
    }

    public void setPlayer(Object channel, Object player) {
        if (!PacketEvents.getAPI().getProtocolManager().hasChannel(channel)) {
            return;
        }
        Channel ch = (Channel)channel;
        ((PacketDecoder)ch.pipeline().get((String)PacketEvents.DECODER_NAME)).player = (class_1657)player;
        ((PacketEncoder)ch.pipeline().get((String)PacketEvents.ENCODER_NAME)).player = (class_1657)player;
    }

    public boolean isProxy() {
        return false;
    }

    public PacketSide getPacketSide() {
        return this.packetSide;
    }
}

