/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.mixin;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketEvent;
import com.github.retrooper.packetevents.event.UserConnectEvent;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.PacketSide;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.util.PacketEventsImplHelper;
import io.github.retrooper.packetevents.PacketEventsMod;
import io.github.retrooper.packetevents.handler.PacketDecoder;
import io.github.retrooper.packetevents.handler.PacketEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.UUID;
import net.minecraft.class_155;
import net.minecraft.class_2535;
import net.minecraft.class_2598;
import net.minecraft.class_8762;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2535.class})
public class ConnectionMixin {
    @Unique
    private static final ClientVersion CLIENT_VERSION = ClientVersion.getById((int)class_155.method_31372());

    @Inject(method={"configureSerialization"}, at={@At(value="TAIL")})
    private static void configureSerialization(ChannelPipeline pipeline, class_2598 flow, boolean memoryOnly, class_8762 bandwithDebugMonitor, CallbackInfo ci) {
        if (!PacketEventsMod.isOurConnection(flow)) {
            PacketEvents.getAPI().getLogManager().debug("Skipped pipeline injection on " + String.valueOf(flow));
            return;
        }
        PacketEvents.getAPI().getLogManager().debug("Game connected!");
        Channel channel = pipeline.channel();
        User user = new User((Object)channel, ConnectionState.HANDSHAKING, CLIENT_VERSION, new UserProfile(null, null));
        PacketEvents.getAPI().getProtocolManager().setUser((Object)channel, user);
        UserConnectEvent connectEvent = new UserConnectEvent(user);
        PacketEvents.getAPI().getEventManager().callEvent((PacketEvent)connectEvent);
        if (connectEvent.isCancelled()) {
            channel.unsafe().closeForcibly();
            return;
        }
        PacketSide apiSide = PacketEvents.getAPI().getInjector().getPacketSide();
        channel.pipeline().addAfter("splitter", PacketEvents.DECODER_NAME, (ChannelHandler)new PacketDecoder(apiSide, user));
        channel.pipeline().addAfter("prepender", PacketEvents.ENCODER_NAME, (ChannelHandler)new PacketEncoder(apiSide, user));
        channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> PacketEventsImplHelper.handleDisconnection((Object)user.getChannel(), (UUID)user.getUUID())));
    }
}

