/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.sponge.manager.player;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import io.github.retrooper.packetevents.sponge.util.SpongeReflectionUtil;
import io.github.retrooper.packetevents.sponge.util.viaversion.ViaVersionUtil;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.ServerConnectionState;
import org.spongepowered.api.network.ServerSideConnection;

public class PlayerManagerImpl
implements PlayerManager {
    @Override
    public int getPing(@NotNull Object player) {
        ServerSideConnection connection = ((ServerPlayer)player).connection();
        return connection.state().map(state -> {
            if (state instanceof ServerConnectionState.Game) {
                ServerConnectionState.Game game = (ServerConnectionState.Game)state;
                return game.latency();
            }
            return -1;
        }).orElse(-1);
    }

    @Override
    @NotNull
    public ClientVersion getClientVersion(@NotNull Object p) {
        ServerPlayer player = (ServerPlayer)p;
        User user = this.getUser(player);
        if (user == null) {
            return ClientVersion.UNKNOWN;
        }
        if (user.getClientVersion() == null) {
            int protocolVersion;
            if (ViaVersionUtil.isAvailable()) {
                protocolVersion = ViaVersionUtil.getProtocolVersion(player);
                PacketEvents.getAPI().getLogManager().debug("Requested ViaVersion for " + player.name() + "'s protocol version. Protocol version: " + protocolVersion);
            } else {
                protocolVersion = PacketEvents.getAPI().getServerManager().getVersion().getProtocolVersion();
                PacketEvents.getAPI().getLogManager().debug("No protocol translation plugins are available. We will assume " + user.getName() + "'s protocol version is the same as the server's protocol version. Protocol version: " + protocolVersion);
            }
            ClientVersion version = ClientVersion.getById(protocolVersion);
            user.setClientVersion(version);
        }
        return user.getClientVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getChannel(@NotNull Object player) {
        UUID uuid = ((ServerPlayer)player).uniqueId();
        ProtocolManager protocolManager = PacketEvents.getAPI().getProtocolManager();
        Object channel = protocolManager.getChannel(uuid);
        if (channel == null && (channel = SpongeReflectionUtil.getChannel((ServerPlayer)player)) != null) {
            Object object = channel;
            synchronized (object) {
                if (ChannelHelper.isOpen(channel)) {
                    protocolManager.setChannel(uuid, channel);
                }
            }
        }
        return channel;
    }

    @Override
    public User getUser(@NotNull Object player) {
        ServerPlayer p = (ServerPlayer)player;
        Object channel = this.getChannel(p);
        if (channel == null) {
            return null;
        }
        return PacketEvents.getAPI().getProtocolManager().getUser(channel);
    }
}

