/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.sponge.util;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.util.LogManager;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;

public class SpongeLogManager
extends LogManager {
    private static final Component PREFIX = Component.text((String)"[packetevents]", (TextColor)NamedTextColor.AQUA).append((Component)Component.text((String)" ", (TextColor)NamedTextColor.WHITE));

    @Override
    protected void log(Level level, @Nullable NamedTextColor color, String message) {
        Sponge.systemSubject().sendMessage(PREFIX.append((Component)Component.text((String)message, (TextColor)color)));
    }

    @Override
    public void info(String message) {
        this.log(Level.INFO, NamedTextColor.WHITE, message);
    }

    @Override
    public void warn(String message) {
        this.log(Level.WARNING, NamedTextColor.YELLOW, message);
    }

    @Override
    public void severe(String message) {
        this.log(Level.SEVERE, NamedTextColor.RED, message);
    }

    @Override
    public void debug(String message) {
        if (PacketEvents.getAPI().getSettings().isDebugEnabled()) {
            this.log(Level.FINE, NamedTextColor.GRAY, message);
        }
    }
}

