/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.states.defaulttags;

import com.github.retrooper.packetevents.protocol.component.ComponentTypes;
import com.github.retrooper.packetevents.protocol.item.type.ItemType;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.world.states.defaulttags.BlockTags;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;

public class ItemTags {
    private static final HashMap<String, ItemTags> byName = new HashMap();
    public static final ItemTags WOOL = ItemTags.bind("wool");
    public static final ItemTags PLANKS = ItemTags.bind("planks");
    public static final ItemTags STONE_BRICKS = ItemTags.bind("stone_bricks");
    public static final ItemTags WOODEN_BUTTONS = ItemTags.bind("wooden_buttons");
    public static final ItemTags STONE_BUTTONS = ItemTags.bind("stone_buttons");
    public static final ItemTags BUTTONS = ItemTags.bind("buttons");
    public static final ItemTags WOOL_CARPETS = ItemTags.bind("carpets");
    public static final ItemTags WOODEN_DOORS = ItemTags.bind("wooden_doors");
    public static final ItemTags WOODEN_STAIRS = ItemTags.bind("wooden_stairs");
    public static final ItemTags WOODEN_SLABS = ItemTags.bind("wooden_slabs");
    public static final ItemTags WOODEN_FENCES = ItemTags.bind("wooden_fences");
    public static final ItemTags FENCE_GATES = ItemTags.bind("fence_gates");
    public static final ItemTags WOODEN_PRESSURE_PLATES = ItemTags.bind("wooden_pressure_plates");
    public static final ItemTags WOODEN_TRAPDOORS = ItemTags.bind("wooden_trapdoors");
    public static final ItemTags DOORS = ItemTags.bind("doors");
    public static final ItemTags SAPLINGS = ItemTags.bind("saplings");
    public static final ItemTags LOGS_THAT_BURN = ItemTags.bind("logs_that_burn");
    public static final ItemTags LOGS = ItemTags.bind("logs");
    public static final ItemTags DARK_OAK_LOGS = ItemTags.bind("dark_oak_logs");
    public static final ItemTags OAK_LOGS = ItemTags.bind("oak_logs");
    public static final ItemTags BIRCH_LOGS = ItemTags.bind("birch_logs");
    public static final ItemTags ACACIA_LOGS = ItemTags.bind("acacia_logs");
    public static final ItemTags CHERRY_LOGS = ItemTags.bind("cherry_logs");
    public static final ItemTags JUNGLE_LOGS = ItemTags.bind("jungle_logs");
    public static final ItemTags SPRUCE_LOGS = ItemTags.bind("spruce_logs");
    public static final ItemTags MANGROVE_LOGS = ItemTags.bind("mangrove_logs");
    public static final ItemTags CRIMSON_STEMS = ItemTags.bind("crimson_stems");
    public static final ItemTags WARPED_STEMS = ItemTags.bind("warped_stems");
    public static final ItemTags BAMBOO_BLOCKS = ItemTags.bind("bamboo_blocks");
    public static final ItemTags WART_BLOCKS = ItemTags.bind("wart_blocks");
    public static final ItemTags BANNERS = ItemTags.bind("banners");
    public static final ItemTags SAND = ItemTags.bind("sand");
    public static final ItemTags SMELTS_TO_GLASS = ItemTags.bind("smelts_to_glass");
    public static final ItemTags STAIRS = ItemTags.bind("stairs");
    public static final ItemTags SLABS = ItemTags.bind("slabs");
    public static final ItemTags WALLS = ItemTags.bind("walls");
    public static final ItemTags ANVIL = ItemTags.bind("anvil");
    public static final ItemTags RAILS = ItemTags.bind("rails");
    public static final ItemTags LEAVES = ItemTags.bind("leaves");
    public static final ItemTags TRAPDOORS = ItemTags.bind("trapdoors");
    public static final ItemTags SMALL_FLOWERS = ItemTags.bind("small_flowers");
    public static final ItemTags BEDS = ItemTags.bind("beds");
    public static final ItemTags FENCES = ItemTags.bind("fences");
    @Deprecated
    public static final ItemTags TALL_FLOWERS = ItemTags.bind("tall_flowers");
    public static final ItemTags FLOWERS = ItemTags.bind("flowers");
    public static final ItemTags PIGLIN_REPELLENTS = ItemTags.bind("piglin_repellents");
    public static final ItemTags PIGLIN_LOVED = ItemTags.bind("piglin_loved");
    public static final ItemTags IGNORED_BY_PIGLIN_BABIES = ItemTags.bind("ignored_by_piglin_babies");
    public static final ItemTags PIGLIN_FOOD = ItemTags.bind("piglin_food");
    public static final ItemTags FOX_FOOD = ItemTags.bind("fox_food");
    public static final ItemTags GOLD_ORES = ItemTags.bind("gold_ores");
    public static final ItemTags IRON_ORES = ItemTags.bind("iron_ores");
    public static final ItemTags DIAMOND_ORES = ItemTags.bind("diamond_ores");
    public static final ItemTags REDSTONE_ORES = ItemTags.bind("redstone_ores");
    public static final ItemTags LAPIS_ORES = ItemTags.bind("lapis_ores");
    public static final ItemTags COAL_ORES = ItemTags.bind("coal_ores");
    public static final ItemTags EMERALD_ORES = ItemTags.bind("emerald_ores");
    public static final ItemTags COPPER_ORES = ItemTags.bind("copper_ores");
    public static final ItemTags NON_FLAMMABLE_WOOD = ItemTags.bind("non_flammable_wood");
    public static final ItemTags SOUL_FIRE_BASE_BLOCKS = ItemTags.bind("soul_fire_base_blocks");
    public static final ItemTags CANDLES = ItemTags.bind("candles");
    public static final ItemTags DIRT = ItemTags.bind("dirt");
    public static final ItemTags TERRACOTTA = ItemTags.bind("terracotta");
    public static final ItemTags COMPLETES_FIND_TREE_TUTORIAL = ItemTags.bind("completes_find_tree_tutorial");
    public static final ItemTags BOATS = ItemTags.bind("boats");
    public static final ItemTags CHEST_BOATS = ItemTags.bind("chest_boats");
    public static final ItemTags FISHES = ItemTags.bind("fishes");
    public static final ItemTags SIGNS = ItemTags.bind("signs");
    @Deprecated
    public static final ItemTags MUSIC_DISCS = ItemTags.bind("music_discs");
    public static final ItemTags CREEPER_DROP_MUSIC_DISCS = ItemTags.bind("creeper_drop_music_discs");
    public static final ItemTags COALS = ItemTags.bind("coals");
    public static final ItemTags ARROWS = ItemTags.bind("arrows");
    public static final ItemTags LECTERN_BOOKS = ItemTags.bind("lectern_books");
    public static final ItemTags BOOKSHELF_BOOKS = ItemTags.bind("bookshelf_books");
    public static final ItemTags BEACON_PAYMENT_ITEMS = ItemTags.bind("beacon_payment_items");
    public static final ItemTags STONE_TOOL_MATERIALS = ItemTags.bind("stone_tool_materials");
    public static final ItemTags STONE_CRAFTING_MATERIALS = ItemTags.bind("stone_crafting_materials");
    public static final ItemTags FREEZE_IMMUNE_WEARABLES = ItemTags.bind("freeze_immune_wearables");
    public static final ItemTags DAMPENS_VIBRATIONS = ItemTags.bind("dampens_vibrations");
    public static final ItemTags CLUSTER_MAX_HARVESTABLES = ItemTags.bind("cluster_max_harvestables");
    public static final ItemTags COMPASSES = ItemTags.bind("compasses");
    public static final ItemTags HANGING_SIGNS = ItemTags.bind("hanging_signs");
    public static final ItemTags CREEPER_IGNITERS = ItemTags.bind("creeper_igniters");
    public static final ItemTags NOTEBLOCK_TOP_INSTRUMENTS = ItemTags.bind("noteblock_top_instruments");
    public static final ItemTags TRIMMABLE_ARMOR = ItemTags.bind("trimmable_armor");
    public static final ItemTags TRIM_MATERIALS = ItemTags.bind("trim_materials");
    @Deprecated
    public static final ItemTags TRIM_TEMPLATES = ItemTags.bind("trim_templates");
    public static final ItemTags SNIFFER_FOOD = ItemTags.bind("sniffer_food");
    public static final ItemTags DECORATED_POT_SHERDS = ItemTags.bind("decorated_pot_sherds");
    public static final ItemTags DECORATED_POT_INGREDIENTS = ItemTags.bind("decorated_pot_ingredients");
    public static final ItemTags SWORDS = ItemTags.bind("swords");
    public static final ItemTags AXES = ItemTags.bind("axes");
    public static final ItemTags HOES = ItemTags.bind("hoes");
    public static final ItemTags PICKAXES = ItemTags.bind("pickaxes");
    public static final ItemTags SHOVELS = ItemTags.bind("shovels");
    public static final ItemTags BREAKS_DECORATED_POTS;
    @Deprecated
    public static final ItemTags TOOLS;
    public static final ItemTags VILLAGER_PLANTABLE_SEEDS;
    public static final ItemTags ARMADILLO_FOOD;
    public static final ItemTags AXOLOTL_FOOD;
    @Deprecated
    public static final ItemTags AXOLOTL_TEMPT_ITEMS;
    public static final ItemTags BEE_FOOD;
    public static final ItemTags CAMEL_FOOD;
    public static final ItemTags CAT_FOOD;
    public static final ItemTags CHEST_ARMOR;
    public static final ItemTags CHICKEN_FOOD;
    public static final ItemTags COW_FOOD;
    public static final ItemTags DYEABLE;
    public static final ItemTags ENCHANTABLE_ARMOR;
    public static final ItemTags ENCHANTABLE_BOW;
    public static final ItemTags ENCHANTABLE_CHEST_ARMOR;
    public static final ItemTags ENCHANTABLE_CROSSBOW;
    public static final ItemTags ENCHANTABLE_DURABILITY;
    public static final ItemTags ENCHANTABLE_EQUIPPABLE;
    public static final ItemTags ENCHANTABLE_FIRE_ASPECT;
    public static final ItemTags ENCHANTABLE_FISHING;
    public static final ItemTags ENCHANTABLE_FOOT_ARMOR;
    public static final ItemTags ENCHANTABLE_HEAD_ARMOR;
    public static final ItemTags ENCHANTABLE_LEG_ARMOR;
    public static final ItemTags ENCHANTABLE_MACE;
    public static final ItemTags ENCHANTABLE_MINING;
    public static final ItemTags ENCHANTABLE_MINING_LOOT;
    public static final ItemTags ENCHANTABLE_SHARP_WEAPON;
    public static final ItemTags ENCHANTABLE_SWORD;
    public static final ItemTags ENCHANTABLE_TRIDENT;
    public static final ItemTags ENCHANTABLE_VANISHING;
    public static final ItemTags ENCHANTABLE_WEAPON;
    public static final ItemTags FOOT_ARMOR;
    public static final ItemTags FROG_FOOD;
    public static final ItemTags GOAT_FOOD;
    public static final ItemTags HEAD_ARMOR;
    public static final ItemTags HOGLIN_FOOD;
    public static final ItemTags HORSE_FOOD;
    public static final ItemTags HORSE_TEMPT_ITEMS;
    public static final ItemTags LEG_ARMOR;
    public static final ItemTags LLAMA_FOOD;
    public static final ItemTags LLAMA_TEMPT_ITEMS;
    public static final ItemTags MEAT;
    public static final ItemTags OCELOT_FOOD;
    public static final ItemTags PANDA_FOOD;
    public static final ItemTags PARROT_FOOD;
    public static final ItemTags PARROT_POISONOUS_FOOD;
    public static final ItemTags PIG_FOOD;
    public static final ItemTags RABBIT_FOOD;
    public static final ItemTags SHEEP_FOOD;
    public static final ItemTags SKULLS;
    public static final ItemTags STRIDER_FOOD;
    public static final ItemTags STRIDER_TEMPT_ITEMS;
    public static final ItemTags TURTLE_FOOD;
    public static final ItemTags WOLF_FOOD;
    public static final ItemTags PALE_OAK_LOGS;
    public static final ItemTags PIGLIN_SAFE_ARMOR;
    public static final ItemTags DUPLICATES_ALLAYS;
    public static final ItemTags BREWING_FUEL;
    public static final ItemTags SHULKER_BOXES;
    public static final ItemTags IRON_TOOL_MATERIALS;
    public static final ItemTags GOLD_TOOL_MATERIALS;
    public static final ItemTags DIAMOND_TOOL_MATERIALS;
    public static final ItemTags NETHERITE_TOOL_MATERIALS;
    public static final ItemTags REPAIRS_LEATHER_ARMOR;
    public static final ItemTags REPAIRS_CHAIN_ARMOR;
    public static final ItemTags REPAIRS_IRON_ARMOR;
    public static final ItemTags REPAIRS_GOLD_ARMOR;
    public static final ItemTags REPAIRS_DIAMOND_ARMOR;
    public static final ItemTags REPAIRS_NETHERITE_ARMOR;
    public static final ItemTags REPAIRS_TURTLE_HELMET;
    public static final ItemTags REPAIRS_WOLF_ARMOR;
    public static final ItemTags FURNACE_MINECART_FUEL;
    public static final ItemTags BUNDLES;
    public static final ItemTags MAP_INVISIBILITY_EQUIPMENT;
    public static final ItemTags GAZE_DISGUISE_EQUIPMENT;
    public static final ItemTags PANDA_EATS_FROM_GROUND;
    public static final ItemTags WOODEN_TOOL_MATERIALS;
    public static final ItemTags VILLAGER_PICKS_UP;
    public static final ItemTags SKELETON_PREFERRED_WEAPONS;
    public static final ItemTags DROWNED_PREFERRED_WEAPONS;
    public static final ItemTags PIGLIN_PREFERRED_WEAPONS;
    public static final ItemTags PILLAGER_PREFERRED_WEAPONS;
    public static final ItemTags WITHER_SKELETON_DISLIKED_WEAPONS;
    public static final ItemTags EGGS;
    public static final ItemTags BOOK_CLONING_TARGET;
    public static final ItemTags HARNESSES;
    public static final ItemTags HAPPY_GHAST_FOOD;
    public static final ItemTags HAPPY_GHAST_TEMPT_ITEMS;
    public static final ItemTags WOODEN_SHELVES;
    public static final ItemTags COPPER_CHESTS;
    public static final ItemTags LIGHTNING_RODS;
    public static final ItemTags COPPER_GOLEM_STATUES;
    public static final ItemTags COPPER;
    public static final ItemTags CHAINS;
    public static final ItemTags LANTERNS;
    public static final ItemTags BARS;
    public static final ItemTags COPPER_TOOL_MATERIALS;
    public static final ItemTags REPAIRS_COPPER_ARMOR;
    public static final ItemTags SHEARABLE_FROM_COPPER_GOLEM;
    String name;
    Set<ItemType> states = new HashSet<ItemType>();
    boolean reallyEmpty;

    public ItemTags(String name) {
        byName.put(name, this);
        this.name = name;
    }

    private static ItemTags bind(String s) {
        return new ItemTags(s);
    }

    private static void copy(ItemTags src, ItemTags dst) {
        dst.states.addAll(src.states);
    }

    private static void copy(BlockTags tag, ItemTags itemTag) {
        for (StateType state : tag.getStates()) {
            itemTag.states.add(ItemTypes.getTypePlacingState(state));
        }
        itemTag.states.remove(null);
    }

    private ItemTags add(ItemType ... state) {
        Collections.addAll(this.states, state);
        return this;
    }

    private ItemTags addTag(ItemTags tags) {
        if (tags.states.isEmpty()) {
            throw new IllegalArgumentException("Tag " + tags.name + " is empty when adding to " + this.name + ", you (packetevents updater) probably messed up the item tags order!!");
        }
        this.states.addAll(tags.states);
        return this;
    }

    public boolean contains(ItemType state) {
        return this.states.contains(state);
    }

    public String getName() {
        return this.name;
    }

    public ItemTags getByName(String name) {
        return byName.get(name);
    }

    public Set<ItemType> getStates() {
        return this.states;
    }

    @VisibleForTesting
    public boolean isReallyEmpty() {
        return this.reallyEmpty;
    }

    static {
        TOOLS = BREAKS_DECORATED_POTS = ItemTags.bind("breaks_decorated_pots");
        VILLAGER_PLANTABLE_SEEDS = ItemTags.bind("villager_plantable_seeds");
        ARMADILLO_FOOD = ItemTags.bind("armadillo_food");
        AXOLOTL_TEMPT_ITEMS = AXOLOTL_FOOD = ItemTags.bind("axolotl_food");
        BEE_FOOD = ItemTags.bind("bee_food");
        CAMEL_FOOD = ItemTags.bind("camel_food");
        CAT_FOOD = ItemTags.bind("cat_food");
        CHEST_ARMOR = ItemTags.bind("chest_armor");
        CHICKEN_FOOD = ItemTags.bind("chicken_food");
        COW_FOOD = ItemTags.bind("cow_food");
        DYEABLE = ItemTags.bind("dyeable");
        ENCHANTABLE_ARMOR = ItemTags.bind("enchantable/armor");
        ENCHANTABLE_BOW = ItemTags.bind("enchantable/bow");
        ENCHANTABLE_CHEST_ARMOR = ItemTags.bind("enchantable/chest_armor");
        ENCHANTABLE_CROSSBOW = ItemTags.bind("enchantable/crossbow");
        ENCHANTABLE_DURABILITY = ItemTags.bind("enchantable/durability");
        ENCHANTABLE_EQUIPPABLE = ItemTags.bind("enchantable/equippable");
        ENCHANTABLE_FIRE_ASPECT = ItemTags.bind("enchantable/fire_aspect");
        ENCHANTABLE_FISHING = ItemTags.bind("enchantable/fishing");
        ENCHANTABLE_FOOT_ARMOR = ItemTags.bind("enchantable/foot_armor");
        ENCHANTABLE_HEAD_ARMOR = ItemTags.bind("enchantable/head_armor");
        ENCHANTABLE_LEG_ARMOR = ItemTags.bind("enchantable/leg_armor");
        ENCHANTABLE_MACE = ItemTags.bind("enchantable/mace");
        ENCHANTABLE_MINING = ItemTags.bind("enchantable/mining");
        ENCHANTABLE_MINING_LOOT = ItemTags.bind("enchantable/mining_loot");
        ENCHANTABLE_SHARP_WEAPON = ItemTags.bind("enchantable/sharp_weapon");
        ENCHANTABLE_SWORD = ItemTags.bind("enchantable/sword");
        ENCHANTABLE_TRIDENT = ItemTags.bind("enchantable/trident");
        ENCHANTABLE_VANISHING = ItemTags.bind("enchantable/vanishing");
        ENCHANTABLE_WEAPON = ItemTags.bind("enchantable/weapon");
        FOOT_ARMOR = ItemTags.bind("foot_armor");
        FROG_FOOD = ItemTags.bind("frog_food");
        GOAT_FOOD = ItemTags.bind("goat_food");
        HEAD_ARMOR = ItemTags.bind("head_armor");
        HOGLIN_FOOD = ItemTags.bind("hoglin_food");
        HORSE_FOOD = ItemTags.bind("horse_food");
        HORSE_TEMPT_ITEMS = ItemTags.bind("horse_tempt_items");
        LEG_ARMOR = ItemTags.bind("leg_armor");
        LLAMA_FOOD = ItemTags.bind("llama_food");
        LLAMA_TEMPT_ITEMS = ItemTags.bind("llama_tempt_items");
        MEAT = ItemTags.bind("meat");
        OCELOT_FOOD = ItemTags.bind("ocelot_food");
        PANDA_FOOD = ItemTags.bind("panda_food");
        PARROT_FOOD = ItemTags.bind("parrot_food");
        PARROT_POISONOUS_FOOD = ItemTags.bind("parrot_poisonous_food");
        PIG_FOOD = ItemTags.bind("pig_food");
        RABBIT_FOOD = ItemTags.bind("rabbit_food");
        SHEEP_FOOD = ItemTags.bind("sheep_food");
        SKULLS = ItemTags.bind("skulls");
        STRIDER_FOOD = ItemTags.bind("strider_food");
        STRIDER_TEMPT_ITEMS = ItemTags.bind("strider_tempt_items");
        TURTLE_FOOD = ItemTags.bind("turtle_food");
        WOLF_FOOD = ItemTags.bind("wolf_food");
        PALE_OAK_LOGS = ItemTags.bind("pale_oak_logs");
        PIGLIN_SAFE_ARMOR = ItemTags.bind("piglin_safe_armor");
        DUPLICATES_ALLAYS = ItemTags.bind("duplicates_allays");
        BREWING_FUEL = ItemTags.bind("brewing_fuel");
        SHULKER_BOXES = ItemTags.bind("shulker_boxes");
        IRON_TOOL_MATERIALS = ItemTags.bind("iron_tool_materials");
        GOLD_TOOL_MATERIALS = ItemTags.bind("gold_tool_materials");
        DIAMOND_TOOL_MATERIALS = ItemTags.bind("diamond_tool_materials");
        NETHERITE_TOOL_MATERIALS = ItemTags.bind("netherite_tool_materials");
        REPAIRS_LEATHER_ARMOR = ItemTags.bind("repairs_leather_armor");
        REPAIRS_CHAIN_ARMOR = ItemTags.bind("repairs_chain_armor");
        REPAIRS_IRON_ARMOR = ItemTags.bind("repairs_iron_armor");
        REPAIRS_GOLD_ARMOR = ItemTags.bind("repairs_gold_armor");
        REPAIRS_DIAMOND_ARMOR = ItemTags.bind("repairs_diamond_armor");
        REPAIRS_NETHERITE_ARMOR = ItemTags.bind("repairs_netherite_armor");
        REPAIRS_TURTLE_HELMET = ItemTags.bind("repairs_turtle_helmet");
        REPAIRS_WOLF_ARMOR = ItemTags.bind("repairs_wolf_armor");
        FURNACE_MINECART_FUEL = ItemTags.bind("furnace_minecart_fuel");
        BUNDLES = ItemTags.bind("bundles");
        MAP_INVISIBILITY_EQUIPMENT = ItemTags.bind("map_invisibility_equipment");
        GAZE_DISGUISE_EQUIPMENT = ItemTags.bind("gaze_disguise_equipment");
        PANDA_EATS_FROM_GROUND = ItemTags.bind("panda_eats_from_ground");
        WOODEN_TOOL_MATERIALS = ItemTags.bind("wooden_tool_materials");
        VILLAGER_PICKS_UP = ItemTags.bind("villager_picks_up");
        SKELETON_PREFERRED_WEAPONS = ItemTags.bind("skeleton_preferred_weapons");
        DROWNED_PREFERRED_WEAPONS = ItemTags.bind("drowned_preferred_weapons");
        PIGLIN_PREFERRED_WEAPONS = ItemTags.bind("piglin_preferred_weapons");
        PILLAGER_PREFERRED_WEAPONS = ItemTags.bind("pillager_preferred_weapons");
        WITHER_SKELETON_DISLIKED_WEAPONS = ItemTags.bind("wither_skeleton_disliked_weapons");
        EGGS = ItemTags.bind("eggs");
        BOOK_CLONING_TARGET = ItemTags.bind("book_cloning_target");
        HARNESSES = ItemTags.bind("harnesses");
        HAPPY_GHAST_FOOD = ItemTags.bind("happy_ghast_food");
        HAPPY_GHAST_TEMPT_ITEMS = ItemTags.bind("happy_ghast_tempt_items");
        WOODEN_SHELVES = ItemTags.bind("wooden_shelves");
        COPPER_CHESTS = ItemTags.bind("copper_chests");
        LIGHTNING_RODS = ItemTags.bind("lightning_rods");
        COPPER_GOLEM_STATUES = ItemTags.bind("copper_golem_statues");
        COPPER = ItemTags.bind("copper");
        CHAINS = ItemTags.bind("chains");
        LANTERNS = ItemTags.bind("lanterns");
        BARS = ItemTags.bind("bars");
        COPPER_TOOL_MATERIALS = ItemTags.bind("copper_tool_materials");
        REPAIRS_COPPER_ARMOR = ItemTags.bind("repairs_copper_armor");
        SHEARABLE_FROM_COPPER_GOLEM = ItemTags.bind("shearable_from_copper_golem");
        ItemTags.copy(BlockTags.WOOL, WOOL);
        ItemTags.copy(BlockTags.PLANKS, PLANKS);
        ItemTags.copy(BlockTags.STONE_BRICKS, STONE_BRICKS);
        ItemTags.copy(BlockTags.WOODEN_BUTTONS, WOODEN_BUTTONS);
        ItemTags.copy(BlockTags.STONE_BUTTONS, STONE_BUTTONS);
        ItemTags.copy(BlockTags.WOOL_CARPETS, WOOL_CARPETS);
        ItemTags.copy(BlockTags.WOODEN_DOORS, WOODEN_DOORS);
        ItemTags.copy(BlockTags.WOODEN_STAIRS, WOODEN_STAIRS);
        ItemTags.copy(BlockTags.WOODEN_SLABS, WOODEN_SLABS);
        ItemTags.copy(BlockTags.WOODEN_FENCES, WOODEN_FENCES);
        ItemTags.copy(BlockTags.FENCE_GATES, FENCE_GATES);
        ItemTags.copy(BlockTags.WOODEN_PRESSURE_PLATES, WOODEN_PRESSURE_PLATES);
        ItemTags.copy(BlockTags.WOODEN_SHELVES, WOODEN_SHELVES);
        ItemTags.copy(BlockTags.SAPLINGS, SAPLINGS);
        ItemTags.copy(BlockTags.BAMBOO_BLOCKS, BAMBOO_BLOCKS);
        ItemTags.copy(BlockTags.OAK_LOGS, OAK_LOGS);
        ItemTags.copy(BlockTags.DARK_OAK_LOGS, DARK_OAK_LOGS);
        ItemTags.copy(BlockTags.PALE_OAK_LOGS, PALE_OAK_LOGS);
        ItemTags.copy(BlockTags.BIRCH_LOGS, BIRCH_LOGS);
        ItemTags.copy(BlockTags.ACACIA_LOGS, ACACIA_LOGS);
        ItemTags.copy(BlockTags.SPRUCE_LOGS, SPRUCE_LOGS);
        ItemTags.copy(BlockTags.MANGROVE_LOGS, MANGROVE_LOGS);
        ItemTags.copy(BlockTags.JUNGLE_LOGS, JUNGLE_LOGS);
        ItemTags.copy(BlockTags.CHERRY_LOGS, CHERRY_LOGS);
        ItemTags.copy(BlockTags.CRIMSON_STEMS, CRIMSON_STEMS);
        ItemTags.copy(BlockTags.WARPED_STEMS, WARPED_STEMS);
        ItemTags.copy(BlockTags.WART_BLOCKS, WART_BLOCKS);
        ItemTags.copy(BlockTags.SAND, SAND);
        ItemTags.copy(BlockTags.SMELTS_TO_GLASS, SMELTS_TO_GLASS);
        ItemTags.copy(BlockTags.WALLS, WALLS);
        ItemTags.copy(BlockTags.ANVIL, ANVIL);
        ItemTags.copy(BlockTags.RAILS, RAILS);
        ItemTags.copy(BlockTags.LEAVES, LEAVES);
        ItemTags.copy(BlockTags.WOODEN_TRAPDOORS, WOODEN_TRAPDOORS);
        ItemTags.copy(BlockTags.SMALL_FLOWERS, SMALL_FLOWERS);
        ItemTags.copy(BlockTags.BEDS, BEDS);
        ItemTags.copy(BlockTags.SOUL_FIRE_BASE_BLOCKS, SOUL_FIRE_BASE_BLOCKS);
        ItemTags.copy(BlockTags.CANDLES, CANDLES);
        ItemTags.copy(BlockTags.GOLD_ORES, GOLD_ORES);
        ItemTags.copy(BlockTags.IRON_ORES, IRON_ORES);
        ItemTags.copy(BlockTags.DIAMOND_ORES, DIAMOND_ORES);
        ItemTags.copy(BlockTags.REDSTONE_ORES, REDSTONE_ORES);
        ItemTags.copy(BlockTags.LAPIS_ORES, LAPIS_ORES);
        ItemTags.copy(BlockTags.COAL_ORES, COAL_ORES);
        ItemTags.copy(BlockTags.EMERALD_ORES, EMERALD_ORES);
        ItemTags.copy(BlockTags.COPPER_ORES, COPPER_ORES);
        ItemTags.copy(BlockTags.DIRT, DIRT);
        ItemTags.copy(BlockTags.TERRACOTTA, TERRACOTTA);
        ItemTags.copy(BlockTags.SHULKER_BOXES, SHULKER_BOXES);
        ItemTags.copy(BlockTags.COPPER_CHESTS, COPPER_CHESTS);
        ItemTags.copy(BlockTags.LIGHTNING_RODS, LIGHTNING_RODS);
        ItemTags.copy(BlockTags.COPPER_GOLEM_STATUES, COPPER_GOLEM_STATUES);
        ItemTags.copy(BlockTags.COPPER, COPPER);
        ItemTags.copy(BlockTags.CHAINS, CHAINS);
        ItemTags.copy(BlockTags.LANTERNS, LANTERNS);
        ItemTags.copy(BlockTags.BARS, BARS);
        ItemTags.copy(BlockTags.STANDING_SIGNS, SIGNS);
        ItemTags.copy(BlockTags.CEILING_HANGING_SIGNS, HANGING_SIGNS);
        ItemTags.copy(BlockTags.BEE_ATTRACTIVE, BEE_FOOD);
        BANNERS.add(ItemTypes.WHITE_BANNER, ItemTypes.ORANGE_BANNER, ItemTypes.MAGENTA_BANNER, ItemTypes.LIGHT_BLUE_BANNER, ItemTypes.YELLOW_BANNER, ItemTypes.LIME_BANNER, ItemTypes.PINK_BANNER, ItemTypes.GRAY_BANNER, ItemTypes.LIGHT_GRAY_BANNER, ItemTypes.CYAN_BANNER, ItemTypes.PURPLE_BANNER, ItemTypes.BLUE_BANNER, ItemTypes.BROWN_BANNER, ItemTypes.GREEN_BANNER, ItemTypes.RED_BANNER, ItemTypes.BLACK_BANNER);
        PIGLIN_REPELLENTS.add(ItemTypes.SOUL_TORCH, ItemTypes.SOUL_LANTERN, ItemTypes.SOUL_CAMPFIRE);
        IGNORED_BY_PIGLIN_BABIES.add(ItemTypes.LEATHER);
        PIGLIN_SAFE_ARMOR.add(ItemTypes.GOLDEN_HELMET, ItemTypes.GOLDEN_CHESTPLATE, ItemTypes.GOLDEN_LEGGINGS, ItemTypes.GOLDEN_BOOTS);
        DUPLICATES_ALLAYS.add(ItemTypes.AMETHYST_SHARD);
        BREWING_FUEL.add(ItemTypes.BLAZE_POWDER);
        EGGS.add(ItemTypes.EGG, ItemTypes.BLUE_EGG, ItemTypes.BROWN_EGG);
        MEAT.add(ItemTypes.BEEF, ItemTypes.CHICKEN, ItemTypes.COOKED_BEEF, ItemTypes.COOKED_CHICKEN, ItemTypes.COOKED_MUTTON, ItemTypes.COOKED_PORKCHOP, ItemTypes.COOKED_RABBIT, ItemTypes.MUTTON, ItemTypes.PORKCHOP, ItemTypes.RABBIT, ItemTypes.ROTTEN_FLESH);
        SNIFFER_FOOD.add(ItemTypes.TORCHFLOWER_SEEDS);
        PIGLIN_FOOD.add(ItemTypes.PORKCHOP, ItemTypes.COOKED_PORKCHOP);
        FOX_FOOD.add(ItemTypes.SWEET_BERRIES, ItemTypes.GLOW_BERRIES);
        COW_FOOD.add(ItemTypes.WHEAT);
        ItemTags.copy(COW_FOOD, GOAT_FOOD);
        ItemTags.copy(COW_FOOD, SHEEP_FOOD);
        CAT_FOOD.add(ItemTypes.COD, ItemTypes.SALMON);
        HORSE_FOOD.add(ItemTypes.WHEAT, ItemTypes.SUGAR, ItemTypes.HAY_BLOCK, ItemTypes.APPLE, ItemTypes.CARROT, ItemTypes.GOLDEN_CARROT, ItemTypes.GOLDEN_APPLE, ItemTypes.ENCHANTED_GOLDEN_APPLE);
        HORSE_TEMPT_ITEMS.add(ItemTypes.GOLDEN_CARROT, ItemTypes.GOLDEN_APPLE, ItemTypes.ENCHANTED_GOLDEN_APPLE);
        HARNESSES.add(ItemTypes.WHITE_HARNESS, ItemTypes.ORANGE_HARNESS, ItemTypes.MAGENTA_HARNESS, ItemTypes.LIGHT_BLUE_HARNESS, ItemTypes.YELLOW_HARNESS, ItemTypes.LIME_HARNESS, ItemTypes.PINK_HARNESS, ItemTypes.GRAY_HARNESS, ItemTypes.LIGHT_GRAY_HARNESS, ItemTypes.CYAN_HARNESS, ItemTypes.PURPLE_HARNESS, ItemTypes.BLUE_HARNESS, ItemTypes.BROWN_HARNESS, ItemTypes.GREEN_HARNESS, ItemTypes.RED_HARNESS, ItemTypes.BLACK_HARNESS);
        HAPPY_GHAST_FOOD.add(ItemTypes.SNOWBALL);
        CAMEL_FOOD.add(ItemTypes.CACTUS);
        ARMADILLO_FOOD.add(ItemTypes.SPIDER_EYE);
        CHICKEN_FOOD.add(ItemTypes.WHEAT_SEEDS, ItemTypes.MELON_SEEDS, ItemTypes.PUMPKIN_SEEDS, ItemTypes.BEETROOT_SEEDS, ItemTypes.TORCHFLOWER_SEEDS, ItemTypes.PITCHER_POD);
        FROG_FOOD.add(ItemTypes.SLIME_BALL);
        HOGLIN_FOOD.add(ItemTypes.CRIMSON_FUNGUS);
        LLAMA_FOOD.add(ItemTypes.WHEAT, ItemTypes.HAY_BLOCK);
        LLAMA_TEMPT_ITEMS.add(ItemTypes.HAY_BLOCK);
        ItemTags.copy(CAT_FOOD, OCELOT_FOOD);
        PANDA_FOOD.add(ItemTypes.BAMBOO);
        PIG_FOOD.add(ItemTypes.CARROT, ItemTypes.POTATO, ItemTypes.BEETROOT);
        RABBIT_FOOD.add(ItemTypes.CARROT, ItemTypes.GOLDEN_CARROT, ItemTypes.DANDELION);
        STRIDER_FOOD.add(ItemTypes.WARPED_FUNGUS);
        TURTLE_FOOD.add(ItemTypes.SEAGRASS);
        ItemTags.copy(CHICKEN_FOOD, PARROT_FOOD);
        PARROT_POISONOUS_FOOD.add(ItemTypes.COOKIE);
        AXOLOTL_FOOD.add(ItemTypes.TROPICAL_FISH_BUCKET);
        NON_FLAMMABLE_WOOD.add(ItemTypes.WARPED_STEM, ItemTypes.STRIPPED_WARPED_STEM, ItemTypes.WARPED_HYPHAE, ItemTypes.STRIPPED_WARPED_HYPHAE, ItemTypes.CRIMSON_STEM, ItemTypes.STRIPPED_CRIMSON_STEM, ItemTypes.CRIMSON_HYPHAE, ItemTypes.STRIPPED_CRIMSON_HYPHAE, ItemTypes.CRIMSON_PLANKS, ItemTypes.WARPED_PLANKS, ItemTypes.CRIMSON_SLAB, ItemTypes.WARPED_SLAB, ItemTypes.CRIMSON_PRESSURE_PLATE, ItemTypes.WARPED_PRESSURE_PLATE, ItemTypes.CRIMSON_FENCE, ItemTypes.WARPED_FENCE, ItemTypes.CRIMSON_TRAPDOOR, ItemTypes.WARPED_TRAPDOOR, ItemTypes.CRIMSON_FENCE_GATE, ItemTypes.WARPED_FENCE_GATE, ItemTypes.CRIMSON_STAIRS, ItemTypes.WARPED_STAIRS, ItemTypes.CRIMSON_BUTTON, ItemTypes.WARPED_BUTTON, ItemTypes.CRIMSON_DOOR, ItemTypes.WARPED_DOOR, ItemTypes.CRIMSON_SIGN, ItemTypes.WARPED_SIGN, ItemTypes.WARPED_HANGING_SIGN, ItemTypes.CRIMSON_HANGING_SIGN, ItemTypes.WARPED_SHELF, ItemTypes.CRIMSON_SHELF);
        CHEST_BOATS.add(ItemTypes.OAK_CHEST_BOAT, ItemTypes.SPRUCE_CHEST_BOAT, ItemTypes.BIRCH_CHEST_BOAT, ItemTypes.JUNGLE_CHEST_BOAT, ItemTypes.ACACIA_CHEST_BOAT, ItemTypes.DARK_OAK_CHEST_BOAT, ItemTypes.PALE_OAK_CHEST_BOAT, ItemTypes.MANGROVE_CHEST_BOAT, ItemTypes.BAMBOO_CHEST_RAFT, ItemTypes.CHERRY_CHEST_BOAT);
        FISHES.add(ItemTypes.COD, ItemTypes.COOKED_COD, ItemTypes.SALMON, ItemTypes.COOKED_SALMON, ItemTypes.PUFFERFISH, ItemTypes.TROPICAL_FISH);
        CREEPER_DROP_MUSIC_DISCS.add(ItemTypes.MUSIC_DISC_13, ItemTypes.MUSIC_DISC_CAT, ItemTypes.MUSIC_DISC_BLOCKS, ItemTypes.MUSIC_DISC_CHIRP, ItemTypes.MUSIC_DISC_FAR, ItemTypes.MUSIC_DISC_MALL, ItemTypes.MUSIC_DISC_MELLOHI, ItemTypes.MUSIC_DISC_STAL, ItemTypes.MUSIC_DISC_STRAD, ItemTypes.MUSIC_DISC_WARD, ItemTypes.MUSIC_DISC_11, ItemTypes.MUSIC_DISC_WAIT);
        COALS.add(ItemTypes.COAL, ItemTypes.CHARCOAL);
        ARROWS.add(ItemTypes.ARROW, ItemTypes.TIPPED_ARROW, ItemTypes.SPECTRAL_ARROW);
        LECTERN_BOOKS.add(ItemTypes.WRITTEN_BOOK, ItemTypes.WRITABLE_BOOK);
        BOOKSHELF_BOOKS.add(ItemTypes.BOOK, ItemTypes.WRITTEN_BOOK, ItemTypes.ENCHANTED_BOOK, ItemTypes.WRITABLE_BOOK, ItemTypes.KNOWLEDGE_BOOK);
        BEACON_PAYMENT_ITEMS.add(ItemTypes.NETHERITE_INGOT, ItemTypes.EMERALD, ItemTypes.DIAMOND, ItemTypes.GOLD_INGOT, ItemTypes.IRON_INGOT);
        STONE_TOOL_MATERIALS.add(ItemTypes.COBBLESTONE, ItemTypes.BLACKSTONE, ItemTypes.COBBLED_DEEPSLATE);
        COPPER_TOOL_MATERIALS.add(ItemTypes.COPPER_INGOT);
        IRON_TOOL_MATERIALS.add(ItemTypes.IRON_INGOT);
        GOLD_TOOL_MATERIALS.add(ItemTypes.GOLD_INGOT);
        DIAMOND_TOOL_MATERIALS.add(ItemTypes.DIAMOND);
        NETHERITE_TOOL_MATERIALS.add(ItemTypes.NETHERITE_INGOT);
        ItemTags.copy(IGNORED_BY_PIGLIN_BABIES, REPAIRS_LEATHER_ARMOR);
        ItemTags.copy(COPPER_TOOL_MATERIALS, REPAIRS_COPPER_ARMOR);
        ItemTags.copy(IRON_TOOL_MATERIALS, REPAIRS_CHAIN_ARMOR);
        ItemTags.copy(IRON_TOOL_MATERIALS, REPAIRS_IRON_ARMOR);
        ItemTags.copy(GOLD_TOOL_MATERIALS, REPAIRS_GOLD_ARMOR);
        ItemTags.copy(DIAMOND_TOOL_MATERIALS, REPAIRS_DIAMOND_ARMOR);
        ItemTags.copy(NETHERITE_TOOL_MATERIALS, REPAIRS_NETHERITE_ARMOR);
        REPAIRS_TURTLE_HELMET.add(ItemTypes.TURTLE_SCUTE);
        REPAIRS_WOLF_ARMOR.add(ItemTypes.ARMADILLO_SCUTE);
        ItemTags.copy(STONE_TOOL_MATERIALS, STONE_CRAFTING_MATERIALS);
        FREEZE_IMMUNE_WEARABLES.add(ItemTypes.LEATHER_BOOTS, ItemTypes.LEATHER_LEGGINGS, ItemTypes.LEATHER_CHESTPLATE, ItemTypes.LEATHER_HELMET, ItemTypes.LEATHER_HORSE_ARMOR);
        CLUSTER_MAX_HARVESTABLES.add(ItemTypes.DIAMOND_PICKAXE, ItemTypes.GOLDEN_PICKAXE, ItemTypes.IRON_PICKAXE, ItemTypes.NETHERITE_PICKAXE, ItemTypes.STONE_PICKAXE, ItemTypes.WOODEN_PICKAXE, ItemTypes.COPPER_PICKAXE);
        COMPASSES.add(ItemTypes.COMPASS, ItemTypes.RECOVERY_COMPASS);
        CREEPER_IGNITERS.add(ItemTypes.FLINT_AND_STEEL, ItemTypes.FIRE_CHARGE);
        NOTEBLOCK_TOP_INSTRUMENTS.add(ItemTypes.ZOMBIE_HEAD, ItemTypes.SKELETON_SKULL, ItemTypes.CREEPER_HEAD, ItemTypes.DRAGON_HEAD, ItemTypes.WITHER_SKELETON_SKULL, ItemTypes.PIGLIN_HEAD, ItemTypes.PLAYER_HEAD);
        FOOT_ARMOR.add(ItemTypes.LEATHER_BOOTS, ItemTypes.COPPER_BOOTS, ItemTypes.CHAINMAIL_BOOTS, ItemTypes.GOLDEN_BOOTS, ItemTypes.IRON_BOOTS, ItemTypes.DIAMOND_BOOTS, ItemTypes.NETHERITE_BOOTS);
        LEG_ARMOR.add(ItemTypes.LEATHER_LEGGINGS, ItemTypes.COPPER_LEGGINGS, ItemTypes.CHAINMAIL_LEGGINGS, ItemTypes.GOLDEN_LEGGINGS, ItemTypes.IRON_LEGGINGS, ItemTypes.DIAMOND_LEGGINGS, ItemTypes.NETHERITE_LEGGINGS);
        CHEST_ARMOR.add(ItemTypes.LEATHER_CHESTPLATE, ItemTypes.COPPER_CHESTPLATE, ItemTypes.CHAINMAIL_CHESTPLATE, ItemTypes.GOLDEN_CHESTPLATE, ItemTypes.IRON_CHESTPLATE, ItemTypes.DIAMOND_CHESTPLATE, ItemTypes.NETHERITE_CHESTPLATE);
        HEAD_ARMOR.add(ItemTypes.LEATHER_HELMET, ItemTypes.COPPER_HELMET, ItemTypes.CHAINMAIL_HELMET, ItemTypes.GOLDEN_HELMET, ItemTypes.IRON_HELMET, ItemTypes.DIAMOND_HELMET, ItemTypes.NETHERITE_HELMET, ItemTypes.TURTLE_HELMET);
        SKULLS.add(ItemTypes.PLAYER_HEAD, ItemTypes.CREEPER_HEAD, ItemTypes.ZOMBIE_HEAD, ItemTypes.SKELETON_SKULL, ItemTypes.WITHER_SKELETON_SKULL, ItemTypes.DRAGON_HEAD, ItemTypes.PIGLIN_HEAD);
        TRIM_MATERIALS.add(ItemTypes.AMETHYST_SHARD, ItemTypes.COPPER_INGOT, ItemTypes.DIAMOND, ItemTypes.EMERALD, ItemTypes.GOLD_INGOT, ItemTypes.IRON_INGOT, ItemTypes.LAPIS_LAZULI, ItemTypes.NETHERITE_INGOT, ItemTypes.QUARTZ, ItemTypes.REDSTONE, ItemTypes.RESIN_BRICK);
        DECORATED_POT_SHERDS.add(ItemTypes.ANGLER_POTTERY_SHERD, ItemTypes.ARCHER_POTTERY_SHERD, ItemTypes.ARMS_UP_POTTERY_SHERD, ItemTypes.BLADE_POTTERY_SHERD, ItemTypes.BREWER_POTTERY_SHERD, ItemTypes.BURN_POTTERY_SHERD, ItemTypes.DANGER_POTTERY_SHERD, ItemTypes.EXPLORER_POTTERY_SHERD, ItemTypes.FRIEND_POTTERY_SHERD, ItemTypes.HEART_POTTERY_SHERD, ItemTypes.HEARTBREAK_POTTERY_SHERD, ItemTypes.HOWL_POTTERY_SHERD, ItemTypes.MINER_POTTERY_SHERD, ItemTypes.MOURNER_POTTERY_SHERD, ItemTypes.PLENTY_POTTERY_SHERD, ItemTypes.PRIZE_POTTERY_SHERD, ItemTypes.SHEAF_POTTERY_SHERD, ItemTypes.SHELTER_POTTERY_SHERD, ItemTypes.SKULL_POTTERY_SHERD, ItemTypes.SNORT_POTTERY_SHERD, ItemTypes.FLOW_POTTERY_SHERD, ItemTypes.GUSTER_POTTERY_SHERD, ItemTypes.SCRAPE_POTTERY_SHERD);
        SWORDS.add(ItemTypes.DIAMOND_SWORD, ItemTypes.STONE_SWORD, ItemTypes.GOLDEN_SWORD, ItemTypes.NETHERITE_SWORD, ItemTypes.WOODEN_SWORD, ItemTypes.IRON_SWORD, ItemTypes.COPPER_SWORD);
        AXES.add(ItemTypes.DIAMOND_AXE, ItemTypes.STONE_AXE, ItemTypes.GOLDEN_AXE, ItemTypes.NETHERITE_AXE, ItemTypes.WOODEN_AXE, ItemTypes.IRON_AXE, ItemTypes.COPPER_AXE);
        HOES.add(ItemTypes.DIAMOND_HOE, ItemTypes.STONE_HOE, ItemTypes.GOLDEN_HOE, ItemTypes.NETHERITE_HOE, ItemTypes.WOODEN_HOE, ItemTypes.IRON_HOE, ItemTypes.COPPER_HOE);
        PICKAXES.add(ItemTypes.DIAMOND_PICKAXE, ItemTypes.STONE_PICKAXE, ItemTypes.GOLDEN_PICKAXE, ItemTypes.NETHERITE_PICKAXE, ItemTypes.WOODEN_PICKAXE, ItemTypes.IRON_PICKAXE, ItemTypes.COPPER_PICKAXE);
        SHOVELS.add(ItemTypes.DIAMOND_SHOVEL, ItemTypes.STONE_SHOVEL, ItemTypes.GOLDEN_SHOVEL, ItemTypes.NETHERITE_SHOVEL, ItemTypes.WOODEN_SHOVEL, ItemTypes.IRON_SHOVEL, ItemTypes.COPPER_SHOVEL);
        VILLAGER_PLANTABLE_SEEDS.add(ItemTypes.WHEAT_SEEDS, ItemTypes.POTATO, ItemTypes.CARROT, ItemTypes.BEETROOT_SEEDS, ItemTypes.TORCHFLOWER_SEEDS, ItemTypes.PITCHER_POD);
        DYEABLE.add(ItemTypes.LEATHER_HELMET, ItemTypes.LEATHER_CHESTPLATE, ItemTypes.LEATHER_LEGGINGS, ItemTypes.LEATHER_BOOTS, ItemTypes.LEATHER_HORSE_ARMOR, ItemTypes.WOLF_ARMOR);
        ItemTags.copy(COALS, FURNACE_MINECART_FUEL);
        BUNDLES.add(ItemTypes.BUNDLE, ItemTypes.BLACK_BUNDLE, ItemTypes.BLUE_BUNDLE, ItemTypes.BROWN_BUNDLE, ItemTypes.CYAN_BUNDLE, ItemTypes.GRAY_BUNDLE, ItemTypes.GREEN_BUNDLE, ItemTypes.LIGHT_BLUE_BUNDLE, ItemTypes.LIGHT_GRAY_BUNDLE, ItemTypes.LIME_BUNDLE, ItemTypes.MAGENTA_BUNDLE, ItemTypes.ORANGE_BUNDLE, ItemTypes.PINK_BUNDLE, ItemTypes.PURPLE_BUNDLE, ItemTypes.RED_BUNDLE, ItemTypes.YELLOW_BUNDLE, ItemTypes.WHITE_BUNDLE);
        BOOK_CLONING_TARGET.add(ItemTypes.WRITABLE_BOOK);
        SKELETON_PREFERRED_WEAPONS.add(ItemTypes.BOW);
        DROWNED_PREFERRED_WEAPONS.add(ItemTypes.TRIDENT);
        PIGLIN_PREFERRED_WEAPONS.add(ItemTypes.CROSSBOW);
        ItemTags.copy(PIGLIN_PREFERRED_WEAPONS, PILLAGER_PREFERRED_WEAPONS);
        WITHER_SKELETON_DISLIKED_WEAPONS.add(ItemTypes.BOW, ItemTypes.CROSSBOW);
        SHEARABLE_FROM_COPPER_GOLEM.add(ItemTypes.POPPY);
        ENCHANTABLE_FISHING.add(ItemTypes.FISHING_ROD);
        ItemTags.copy(DROWNED_PREFERRED_WEAPONS, ENCHANTABLE_TRIDENT);
        ItemTags.copy(SKELETON_PREFERRED_WEAPONS, ENCHANTABLE_BOW);
        ItemTags.copy(PIGLIN_PREFERRED_WEAPONS, ENCHANTABLE_CROSSBOW);
        ENCHANTABLE_MACE.add(ItemTypes.MACE);
        MAP_INVISIBILITY_EQUIPMENT.add(ItemTypes.CARVED_PUMPKIN);
        ItemTags.copy(MAP_INVISIBILITY_EQUIPMENT, GAZE_DISGUISE_EQUIPMENT);
        ItemTags.copy(BlockTags.BUTTONS, BUTTONS);
        ItemTags.copy(BlockTags.DOORS, DOORS);
        ItemTags.copy(BlockTags.LOGS_THAT_BURN, LOGS_THAT_BURN);
        ItemTags.copy(BlockTags.SLABS, SLABS);
        ItemTags.copy(BlockTags.STAIRS, STAIRS);
        ItemTags.copy(BlockTags.TRAPDOORS, TRAPDOORS);
        ItemTags.copy(BlockTags.FLOWERS, FLOWERS);
        ItemTags.copy(BlockTags.FENCES, FENCES);
        ItemTags.copy(BlockTags.DAMPENS_VIBRATIONS, DAMPENS_VIBRATIONS);
        PIGLIN_LOVED.addTag(GOLD_ORES).add(ItemTypes.GOLD_BLOCK, ItemTypes.GILDED_BLACKSTONE, ItemTypes.LIGHT_WEIGHTED_PRESSURE_PLATE, ItemTypes.GOLD_INGOT, ItemTypes.BELL, ItemTypes.CLOCK, ItemTypes.GOLDEN_CARROT, ItemTypes.GLISTERING_MELON_SLICE, ItemTypes.GOLDEN_APPLE, ItemTypes.ENCHANTED_GOLDEN_APPLE, ItemTypes.GOLDEN_HELMET, ItemTypes.GOLDEN_CHESTPLATE, ItemTypes.GOLDEN_LEGGINGS, ItemTypes.GOLDEN_BOOTS, ItemTypes.GOLDEN_HORSE_ARMOR, ItemTypes.GOLDEN_SWORD, ItemTypes.GOLDEN_PICKAXE, ItemTypes.GOLDEN_SHOVEL, ItemTypes.GOLDEN_AXE, ItemTypes.GOLDEN_HOE, ItemTypes.RAW_GOLD, ItemTypes.RAW_GOLD_BLOCK);
        WOLF_FOOD.addTag(MEAT).add(ItemTypes.COD, ItemTypes.COOKED_COD, ItemTypes.SALMON, ItemTypes.COOKED_SALMON, ItemTypes.TROPICAL_FISH, ItemTypes.PUFFERFISH, ItemTypes.RABBIT_STEW);
        HAPPY_GHAST_TEMPT_ITEMS.addTag(HAPPY_GHAST_FOOD).addTag(HARNESSES);
        PANDA_EATS_FROM_GROUND.addTag(PANDA_FOOD).add(ItemTypes.CAKE);
        STRIDER_TEMPT_ITEMS.addTag(STRIDER_FOOD).add(ItemTypes.WARPED_FUNGUS_ON_A_STICK);
        BOATS.addTag(CHEST_BOATS).add(ItemTypes.OAK_BOAT, ItemTypes.SPRUCE_BOAT, ItemTypes.BIRCH_BOAT, ItemTypes.JUNGLE_BOAT, ItemTypes.ACACIA_BOAT, ItemTypes.DARK_OAK_BOAT, ItemTypes.PALE_OAK_BOAT, ItemTypes.MANGROVE_BOAT, ItemTypes.BAMBOO_RAFT, ItemTypes.CHERRY_BOAT);
        WOODEN_TOOL_MATERIALS.addTag(PLANKS);
        TRIMMABLE_ARMOR.addTag(FOOT_ARMOR).addTag(LEG_ARMOR).addTag(CHEST_ARMOR).addTag(HEAD_ARMOR);
        DECORATED_POT_INGREDIENTS.addTag(DECORATED_POT_SHERDS).add(ItemTypes.BRICK);
        BREAKS_DECORATED_POTS.addTag(SWORDS).addTag(AXES).addTag(PICKAXES).addTag(SHOVELS).addTag(HOES).add(ItemTypes.TRIDENT, ItemTypes.MACE);
        VILLAGER_PICKS_UP.addTag(VILLAGER_PLANTABLE_SEEDS).add(ItemTypes.BREAD, ItemTypes.WHEAT, ItemTypes.BEETROOT);
        ENCHANTABLE_FOOT_ARMOR.addTag(FOOT_ARMOR);
        ENCHANTABLE_LEG_ARMOR.addTag(LEG_ARMOR);
        ENCHANTABLE_CHEST_ARMOR.addTag(CHEST_ARMOR);
        ENCHANTABLE_HEAD_ARMOR.addTag(HEAD_ARMOR);
        ENCHANTABLE_SWORD.addTag(SWORDS);
        ENCHANTABLE_SHARP_WEAPON.addTag(SWORDS).addTag(AXES);
        ENCHANTABLE_MINING.addTag(AXES).addTag(PICKAXES).addTag(SHOVELS).addTag(HOES).add(ItemTypes.SHEARS);
        ENCHANTABLE_MINING_LOOT.addTag(AXES).addTag(PICKAXES).addTag(SHOVELS).addTag(HOES);
        ENCHANTABLE_DURABILITY.addTag(FOOT_ARMOR).addTag(LEG_ARMOR).addTag(CHEST_ARMOR).addTag(HEAD_ARMOR).addTag(SWORDS).addTag(AXES).addTag(PICKAXES).addTag(SHOVELS).addTag(HOES).add(ItemTypes.ELYTRA, ItemTypes.SHIELD, ItemTypes.BOW, ItemTypes.CROSSBOW, ItemTypes.TRIDENT, ItemTypes.FLINT_AND_STEEL, ItemTypes.SHEARS, ItemTypes.BRUSH, ItemTypes.FISHING_ROD, ItemTypes.CARROT_ON_A_STICK, ItemTypes.WARPED_FUNGUS_ON_A_STICK, ItemTypes.MACE);
        ENCHANTABLE_EQUIPPABLE.addTag(FOOT_ARMOR).addTag(LEG_ARMOR).addTag(CHEST_ARMOR).addTag(HEAD_ARMOR).addTag(SKULLS).add(ItemTypes.ELYTRA, ItemTypes.CARVED_PUMPKIN);
        ItemTags.copy(BlockTags.LOGS, LOGS);
        ENCHANTABLE_ARMOR.addTag(ENCHANTABLE_FOOT_ARMOR).addTag(ENCHANTABLE_LEG_ARMOR).addTag(ENCHANTABLE_CHEST_ARMOR).addTag(ENCHANTABLE_HEAD_ARMOR);
        ENCHANTABLE_FIRE_ASPECT.addTag(ENCHANTABLE_SWORD).add(ItemTypes.MACE);
        ENCHANTABLE_WEAPON.addTag(ENCHANTABLE_SHARP_WEAPON).add(ItemTypes.MACE);
        ENCHANTABLE_VANISHING.addTag(ENCHANTABLE_DURABILITY).addTag(SKULLS).add(ItemTypes.COMPASS, ItemTypes.CARVED_PUMPKIN);
        ItemTags.copy(BlockTags.COMPLETES_FIND_TREE_TUTORIAL, COMPLETES_FIND_TREE_TUTORIAL);
        for (ItemType type : ItemTypes.getRegistry().getEntries()) {
            if (!type.getComponents().has(ComponentTypes.JUKEBOX_PLAYABLE)) continue;
            MUSIC_DISCS.add(type);
        }
        ItemTags.copy(BlockTags.TALL_FLOWERS, TALL_FLOWERS);
        ItemTags.copy(BlockTags.FLOWERS, FLOWERS);
        TRIM_TEMPLATES.add(ItemTypes.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE, ItemTypes.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE);
    }
}

