/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.sponge;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.UserConnectEvent;
import com.github.retrooper.packetevents.event.UserDisconnectEvent;
import com.github.retrooper.packetevents.event.UserLoginEvent;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.TimeStampMode;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import com.google.inject.Inject;
import io.github.retrooper.packetevents.bstats.charts.SimplePie;
import io.github.retrooper.packetevents.bstats.sponge.Metrics;
import io.github.retrooper.packetevents.sponge.factory.SpongePacketEventsBuilder;
import io.github.retrooper.packetevents.sponge.util.SpongeConversionUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.kyori.adventure.Adventure;
import org.spongepowered.api.Server;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.lifecycle.StartingEngineEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="packetevents")
public class PacketEventsPlugin {
    private final PluginContainer pluginContainer;
    private final Metrics metrics;

    @Inject
    public PacketEventsPlugin(PluginContainer pluginContainer, Metrics.Factory metricsFactory) {
        this.pluginContainer = pluginContainer;
        this.metrics = metricsFactory.make(11327);
    }

    @Listener(order=Order.EARLY)
    public void onServerStart(StartingEngineEvent<Server> event) {
        PacketEvents.setAPI(SpongePacketEventsBuilder.build(this.pluginContainer));
        PacketEvents.getAPI().load();
        PacketEvents.getAPI().getSettings().debug(false).downsampleColors(false).checkForUpdates(true).timeStampMode(TimeStampMode.MILLIS).reEncodeByDefault(true);
        PacketEvents.getAPI().init();
        if (!this.validateAdventureVersion()) {
            PacketEvents.getAPI().getLogManager().warn("Adventure version mismatch detected! This may cause issues with PacketEvents.");
            PacketEvents.getAPI().getLogManager().warn("Ensure that you are using the version of PacketEvents intended for this version of Sponge.");
            PacketEvents.getAPI().getLogManager().warn("This version of PacketEvents was built for Sponge API: 17.0.0-SNAPSHOT");
            PacketEvents.getAPI().getLogManager().warn("It is possible that Sponge has not yet updated to the correct Adventure API version for this Minecraft version.");
            PacketEvents.getAPI().getLogManager().warn("If this is the case, please kindly ask the Sponge team to update their Adventure API to the correct version.");
        }
        this.metrics.addCustomChart(new SimplePie("packetevents_version", () -> PacketEvents.getAPI().getVersion().toStringWithoutSnapshot()));
        SimplePacketListenerAbstract listener = new SimplePacketListenerAbstract(this, PacketListenerPriority.HIGH){

            @Override
            public void onPacketPlaySend(PacketPlaySendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
                    WrapperPlayServerWindowItems items = new WrapperPlayServerWindowItems(event);
                    for (com.github.retrooper.packetevents.protocol.item.ItemStack item : items.getItems()) {
                        ItemStack sponge = SpongeConversionUtil.toSpongeItemStack(item);
                        System.out.println(sponge.type().key(RegistryTypes.ITEM_TYPE).formatted());
                        System.out.println(SpongeConversionUtil.fromSpongeItemStack(sponge).getType().getName().toString());
                    }
                }
            }

            @Override
            public void onUserConnect(UserConnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " connected...");
            }

            @Override
            public void onUserLogin(UserLoginEvent event) {
                PacketEvents.getAPI().getLogManager().debug("You logged in! User name: " + event.getUser().getProfile().getName());
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " disconnected...");
            }
        };
    }

    @Listener(order=Order.LATE)
    public void onStopping(StoppingEngineEvent<Server> event) {
        PacketEvents.getAPI().terminate();
    }

    private boolean validateAdventureVersion() {
        String bundledAdventureVersion = null;
        try {
            URL fileUrl;
            URI uri;
            File jarFile;
            CodeSource src = Adventure.class.getProtectionDomain().getCodeSource();
            if (src == null) {
                PacketEvents.getAPI().getLogManager().warn("Unable to resolve CodeSource for Adventure JAR");
                return false;
            }
            String urlStr = src.getLocation().toString();
            if (urlStr.startsWith("jar:")) {
                urlStr = urlStr.substring(4);
            }
            if (urlStr.endsWith("!/")) {
                urlStr = urlStr.substring(0, urlStr.length() - 2);
            }
            if (!(jarFile = new File(uri = (fileUrl = new URL(urlStr)).toURI())).exists()) {
                PacketEvents.getAPI().getLogManager().warn("Adventure JAR file not found: " + String.valueOf(jarFile));
                return false;
            }
            try (JarFile jar = new JarFile(jarFile);){
                Manifest mf = jar.getManifest();
                if (mf != null) {
                    bundledAdventureVersion = mf.getMainAttributes().getValue("Specification-Version");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PacketEvents.getAPI().getLogManager().info("Runtime Adventure Version: " + bundledAdventureVersion);
        if (bundledAdventureVersion == null) {
            PacketEvents.getAPI().getLogManager().warn("Failed to validate Adventure version!");
            return false;
        }
        String expectedAdventureVersion = "4.25.0";
        PacketEvents.getAPI().getLogManager().info("Expected Adventure Version: 4.25.0");
        return Objects.equals(bundledAdventureVersion, "4.25.0");
    }
}

