/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.sponge.factory;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.injector.ChannelInjector;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.github.retrooper.packetevents.manager.server.ServerManager;
import com.github.retrooper.packetevents.netty.NettyManager;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.settings.PacketEventsSettings;
import com.github.retrooper.packetevents.util.LogManager;
import io.github.retrooper.packetevents.sponge.InternalSpongeListener;
import io.github.retrooper.packetevents.sponge.injector.SpongeChannelInjector;
import io.github.retrooper.packetevents.sponge.injector.connection.ServerConnectionInitializer;
import io.github.retrooper.packetevents.sponge.manager.InternalSpongePacketListener;
import io.github.retrooper.packetevents.sponge.manager.player.PlayerManagerImpl;
import io.github.retrooper.packetevents.sponge.manager.protocol.ProtocolManagerImpl;
import io.github.retrooper.packetevents.sponge.manager.server.ServerManagerImpl;
import io.github.retrooper.packetevents.sponge.netty.NettyManagerImpl;
import io.github.retrooper.packetevents.sponge.util.SpongeLogManager;
import io.github.retrooper.packetevents.sponge.util.SpongeReflectionUtil;
import io.github.retrooper.packetevents.sponge.util.viaversion.CustomPipelineUtil;
import io.github.retrooper.packetevents.sponge.util.viaversion.ViaVersionUtil;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.plugin.PluginContainer;

public class SpongePacketEventsBuilder {
    private static PacketEventsAPI<PluginContainer> API_INSTANCE;

    public static void clearBuildCache() {
        API_INSTANCE = null;
    }

    public static PacketEventsAPI<PluginContainer> build(PluginContainer plugin) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpongePacketEventsBuilder.buildNoCache(plugin);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<PluginContainer> build(PluginContainer plugin, PacketEventsSettings settings) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpongePacketEventsBuilder.buildNoCache(plugin, settings);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<PluginContainer> buildNoCache(PluginContainer plugin) {
        return SpongePacketEventsBuilder.buildNoCache(plugin, new PacketEventsSettings());
    }

    public static PacketEventsAPI<PluginContainer> buildNoCache(final PluginContainer plugin, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<PluginContainer>(){
            private final PacketEventsSettings settings;
            private final ProtocolManager protocolManager;
            private final ServerManager serverManager;
            private final PlayerManager playerManager;
            private final NettyManager nettyManager;
            private final SpongeChannelInjector injector;
            private final LogManager logManager;
            private boolean loaded;
            private boolean initialized;
            private boolean terminated;
            private boolean lateBind;
            {
                this.settings = inSettings;
                this.protocolManager = new ProtocolManagerImpl();
                this.serverManager = new ServerManagerImpl();
                this.playerManager = new PlayerManagerImpl();
                this.nettyManager = new NettyManagerImpl();
                this.injector = new SpongeChannelInjector();
                this.logManager = new SpongeLogManager(plugin);
                this.lateBind = false;
            }

            @Override
            public void load() {
                if (this.loaded) {
                    return;
                }
                String id = plugin.metadata().id().toLowerCase();
                PacketEvents.IDENTIFIER = "pe-" + id;
                PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                try {
                    SpongeReflectionUtil.init();
                    CustomPipelineUtil.init();
                    WrappedBlockState.ensureLoad();
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                if (!PacketType.isPrepared()) {
                    PacketType.prepare();
                }
                boolean bl = this.lateBind = !this.injector.isServerBound();
                if (!this.lateBind) {
                    this.injector.inject();
                }
                this.loaded = true;
                this.getEventManager().registerListener(new InternalSpongePacketListener());
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (this.initialized) {
                    return;
                }
                Sponge.eventManager().registerListeners(plugin, (Object)new InternalSpongeListener());
                if (this.lateBind) {
                    Runnable lateBindTask = () -> {
                        if (this.injector.isServerBound()) {
                            this.injector.inject();
                        }
                    };
                    Sponge.server().scheduler().submit(Task.builder().plugin(plugin).execute(lateBindTask).build());
                }
                if (!"true".equalsIgnoreCase(System.getenv("PE_IGNORE_INCOMPATIBILITY"))) {
                    ViaVersionUtil.checkIfViaIsPresent();
                }
                this.initialized = true;
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    this.injector.uninject();
                    for (User user : this.protocolManager.getUsers()) {
                        ServerConnectionInitializer.destroyHandlers(user.getChannel());
                    }
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public PluginContainer getPlugin() {
                return plugin;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return this.protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return this.serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return this.playerManager;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return this.injector;
            }

            @Override
            public LogManager getLogManager() {
                return this.logManager;
            }
        };
    }
}

