/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.sponge.injector.handlers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.exception.PacketProcessException;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.util.ExceptionUtil;
import com.github.retrooper.packetevents.util.PacketEventsImplHelper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import io.github.retrooper.packetevents.sponge.injector.connection.ServerConnectionInitializer;
import io.github.retrooper.packetevents.sponge.util.SpongeReflectionUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.plugin.PluginContainer;

public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    public User user;
    public UUID player;
    public boolean hasBeenRelocated;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    public PacketEventsDecoder(PacketEventsDecoder decoder) {
        this.user = decoder.user;
        this.player = decoder.player;
        this.hasBeenRelocated = decoder.hasBeenRelocated;
    }

    public void read(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) throws Exception {
        PacketEventsImplHelper.handleServerBoundPacket(ctx.channel(), this.user, this.player == null ? null : Sponge.server().player(this.player).orElse(null), input, true);
        out.add(ByteBufHelper.retain(input));
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.isReadable()) {
            this.read(ctx, buffer, out);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (ExceptionUtil.isException(cause, PacketProcessException.class) && !SpongeReflectionUtil.isMinecraftServerInstanceDebugging() && this.user != null && this.user.getDecoderState() != ConnectionState.HANDSHAKING) {
            if (PacketEvents.getAPI().getSettings().isFullStackTraceEnabled()) {
                cause.printStackTrace();
            } else {
                PacketEvents.getAPI().getLogManager().warn(cause.getMessage());
            }
            if (PacketEvents.getAPI().getSettings().isKickOnPacketExceptionEnabled()) {
                try {
                    this.user.sendPacket(new WrapperPlayServerDisconnect((Component)Component.text((String)"Invalid packet")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.user.closeConnection();
                if (this.player != null) {
                    Sponge.server().scheduler().submit(Task.builder().plugin((PluginContainer)PacketEvents.getAPI().getPlugin()).execute(() -> ((ServerPlayer)Sponge.server().player(this.player).get()).kick((Component)Component.text((String)"Invalid packet"))).build());
                }
                if (this.user != null && this.user.getProfile().getName() != null) {
                    PacketEvents.getAPI().getLogManager().warn("Disconnected " + this.user.getProfile().getName() + " due to an invalid packet!");
                }
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        ServerConnectionInitializer.relocateHandlers(ctx.channel(), this, this.user);
        super.userEventTriggered(ctx, event);
    }
}

