/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.sponge.manager.protocol;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import com.github.retrooper.packetevents.protocol.ProtocolVersion;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class ProtocolManagerImpl
implements ProtocolManager {
    private ProtocolVersion platformVersion;

    private ProtocolVersion resolveVersionNoCache() {
        return ProtocolVersion.UNKNOWN;
    }

    @Override
    public ProtocolVersion getPlatformVersion() {
        if (this.platformVersion == null) {
            this.platformVersion = this.resolveVersionNoCache();
        }
        return this.platformVersion;
    }

    @Override
    public void sendPacket(Object channel, Object byteBuf) {
        if (ChannelHelper.isOpen(channel)) {
            ChannelHelper.writeAndFlush(channel, byteBuf);
        } else {
            ((ByteBuf)byteBuf).release();
        }
    }

    @Override
    public void sendPacketSilently(Object channel, Object byteBuf) {
        if (ChannelHelper.isOpen(channel)) {
            ChannelHelper.writeAndFlushInContext(channel, PacketEvents.ENCODER_NAME, byteBuf);
        } else {
            ((ByteBuf)byteBuf).release();
        }
    }

    @Override
    public void writePacket(Object channel, Object byteBuf) {
        if (ChannelHelper.isOpen(channel)) {
            ChannelHelper.write(channel, byteBuf);
        } else {
            ((ByteBuf)byteBuf).release();
        }
    }

    @Override
    public void writePacketSilently(Object channel, Object byteBuf) {
        if (ChannelHelper.isOpen(channel)) {
            ChannelHelper.writeInContext(channel, PacketEvents.ENCODER_NAME, byteBuf);
        } else {
            ((ByteBuf)byteBuf).release();
        }
    }

    @Override
    public void receivePacket(Object channel, Object byteBuf) {
        if (ChannelHelper.isOpen(channel)) {
            List<String> handlerNames = ChannelHelper.pipelineHandlerNames(channel);
            if (handlerNames.contains("via-encoder")) {
                ChannelHelper.fireChannelReadInContext(channel, "via-decoder", byteBuf);
            } else if (handlerNames.contains("decompress")) {
                ChannelHelper.fireChannelReadInContext(channel, "decompress", byteBuf);
            } else if (handlerNames.contains("decrypt")) {
                ChannelHelper.fireChannelReadInContext(channel, "decrypt", byteBuf);
            } else {
                ChannelHelper.fireChannelReadInContext(channel, "splitter", byteBuf);
            }
        } else {
            ((ByteBuf)byteBuf).release();
        }
    }

    @Override
    public void receivePacketSilently(Object channel, Object byteBuf) {
        if (ChannelHelper.isOpen(channel)) {
            ChannelHelper.fireChannelReadInContext(channel, PacketEvents.DECODER_NAME, byteBuf);
        } else {
            ((ByteBuf)byteBuf).release();
        }
    }

    @Override
    public ClientVersion getClientVersion(Object channel) {
        User user = this.getUser(channel);
        if (user.getClientVersion() == null) {
            return ClientVersion.UNKNOWN;
        }
        return user.getClientVersion();
    }
}

