/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.chat.clickevent;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.chat.clickevent.ClickEvent;
import com.github.retrooper.packetevents.protocol.chat.clickevent.ClickEventAction;
import com.github.retrooper.packetevents.protocol.chat.clickevent.ClickEventActions;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SuggestCommandClickEvent
implements ClickEvent {
    private final String command;

    public SuggestCommandClickEvent(String command) {
        this.command = command;
    }

    public static SuggestCommandClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        String command = compound.getStringTagValueOrThrow(v1215 ? "command" : "value");
        return new SuggestCommandClickEvent(command);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, SuggestCommandClickEvent clickEvent) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        compound.setTag(v1215 ? "command" : "value", new NBTString(clickEvent.command));
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.SUGGEST_COMMAND;
    }

    @Override
    public net.kyori.adventure.text.event.ClickEvent asAdventure() {
        return net.kyori.adventure.text.event.ClickEvent.suggestCommand(this.command);
    }

    public String getCommand() {
        return this.command;
    }
}

