/*
 * Decompiled with CFR 0.152.
 */
package com.github.retrooper.packetevents.protocol.world.blockentity;

import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.world.blockentity.BlockEntityType;
import com.github.retrooper.packetevents.protocol.world.blockentity.StaticBlockEntityType;
import com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;

public final class BlockEntityTypes {
    private static final VersionedRegistry<BlockEntityType> REGISTRY = new VersionedRegistry("block_entity_type");
    public static final BlockEntityType FURNACE = BlockEntityTypes.define("furnace");
    public static final BlockEntityType CHEST = BlockEntityTypes.define("chest");
    public static final BlockEntityType TRAPPED_CHEST = BlockEntityTypes.define("trapped_chest");
    public static final BlockEntityType ENDER_CHEST = BlockEntityTypes.define("ender_chest");
    public static final BlockEntityType JUKEBOX = BlockEntityTypes.define("jukebox");
    public static final BlockEntityType DISPENSER = BlockEntityTypes.define("dispenser");
    public static final BlockEntityType DROPPER = BlockEntityTypes.define("dropper");
    public static final BlockEntityType SIGN = BlockEntityTypes.define("sign");
    public static final BlockEntityType HANGING_SIGN = BlockEntityTypes.define("hanging_sign");
    public static final BlockEntityType MOB_SPAWNER = BlockEntityTypes.define("mob_spawner");
    public static final BlockEntityType PISTON = BlockEntityTypes.define("piston");
    public static final BlockEntityType BREWING_STAND = BlockEntityTypes.define("brewing_stand");
    public static final BlockEntityType ENCHANTING_TABLE = BlockEntityTypes.define("enchanting_table");
    public static final BlockEntityType END_PORTAL = BlockEntityTypes.define("end_portal");
    public static final BlockEntityType BEACON = BlockEntityTypes.define("beacon");
    public static final BlockEntityType SKULL = BlockEntityTypes.define("skull");
    public static final BlockEntityType DAYLIGHT_DETECTOR = BlockEntityTypes.define("daylight_detector");
    public static final BlockEntityType HOPPER = BlockEntityTypes.define("hopper");
    public static final BlockEntityType COMPARATOR = BlockEntityTypes.define("comparator");
    public static final BlockEntityType BANNER = BlockEntityTypes.define("banner");
    public static final BlockEntityType STRUCTURE_BLOCK = BlockEntityTypes.define("structure_block");
    public static final BlockEntityType END_GATEWAY = BlockEntityTypes.define("end_gateway");
    public static final BlockEntityType COMMAND_BLOCK = BlockEntityTypes.define("command_block");
    public static final BlockEntityType SHULKER_BOX = BlockEntityTypes.define("shulker_box");
    public static final BlockEntityType BED = BlockEntityTypes.define("bed");
    public static final BlockEntityType CONDUIT = BlockEntityTypes.define("conduit");
    public static final BlockEntityType BARREL = BlockEntityTypes.define("barrel");
    public static final BlockEntityType SMOKER = BlockEntityTypes.define("smoker");
    public static final BlockEntityType BLAST_FURNACE = BlockEntityTypes.define("blast_furnace");
    public static final BlockEntityType LECTERN = BlockEntityTypes.define("lectern");
    public static final BlockEntityType BELL = BlockEntityTypes.define("bell");
    public static final BlockEntityType JIGSAW = BlockEntityTypes.define("jigsaw");
    public static final BlockEntityType CAMPFIRE = BlockEntityTypes.define("campfire");
    public static final BlockEntityType BEEHIVE = BlockEntityTypes.define("beehive");
    public static final BlockEntityType SCULK_SENSOR = BlockEntityTypes.define("sculk_sensor");
    public static final BlockEntityType CALIBRATED_SCULK_SENSOR = BlockEntityTypes.define("calibrated_sculk_sensor");
    public static final BlockEntityType SCULK_CATALYST = BlockEntityTypes.define("sculk_catalyst");
    public static final BlockEntityType SCULK_SHRIEKER = BlockEntityTypes.define("sculk_shrieker");
    public static final BlockEntityType CHISELED_BOOKSHELF = BlockEntityTypes.define("chiseled_bookshelf");
    @ApiStatus.Obsolete
    public static final BlockEntityType SUSPICIOUS_SAND = BlockEntityTypes.define("suspicious_sand");
    public static final BlockEntityType BRUSHABLE_BLOCK = BlockEntityTypes.define("brushable_block");
    public static final BlockEntityType DECORATED_POT = BlockEntityTypes.define("decorated_pot");
    public static final BlockEntityType CRAFTER = BlockEntityTypes.define("crafter");
    public static final BlockEntityType TRIAL_SPAWNER = BlockEntityTypes.define("trial_spawner");
    public static final BlockEntityType VAULT = BlockEntityTypes.define("vault");
    public static final BlockEntityType CREAKING_HEART = BlockEntityTypes.define("creaking_heart");
    public static final BlockEntityType TEST_BLOCK = BlockEntityTypes.define("test_block");
    public static final BlockEntityType TEST_INSTANCE_BLOCK = BlockEntityTypes.define("test_instance_block");
    public static final BlockEntityType SHELF = BlockEntityTypes.define("shelf");
    public static final BlockEntityType COPPER_GOLEM_STATUE = BlockEntityTypes.define("copper_golem_statue");

    private BlockEntityTypes() {
    }

    private static BlockEntityType define(String key) {
        return REGISTRY.define(key, StaticBlockEntityType::new);
    }

    public static VersionedRegistry<BlockEntityType> getRegistry() {
        return REGISTRY;
    }

    public static BlockEntityType getByName(String name) {
        return REGISTRY.getByName(name);
    }

    public static BlockEntityType getById(ClientVersion version, int id) {
        return REGISTRY.getById(version, id);
    }

    public static Collection<BlockEntityType> values() {
        return REGISTRY.getEntries();
    }

    static {
        REGISTRY.unloadMappings();
    }
}

